/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.shared;

import com.ibm.bi.rest.RESTClientFactory;
import javax.annotation.Resource;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class BIContextListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BIContextListener.class);
    @Resource(lookup="concurrent/biExecSvc")
    private ManagedExecutorService execSvc;
    private String contextPath = null;

    public void contextDestroyed(ServletContextEvent ctxEvent) {
        try {
            Class.forName("com.ibm.bi.rest.RESTClientFactory");
            RESTClientFactory.getInstance().shutdown();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        LOGGER.info("{} destroyed.", (Object)this.contextPath);
    }

    public void contextInitialized(ServletContextEvent ctxEvent) {
        ctxEvent.getServletContext().setAttribute("execSvc", (Object)this.execSvc);
        this.contextPath = ctxEvent.getServletContext().getContextPath();
        try {
            Class.forName("com.ibm.bi.rest.RESTClientFactory");
            RESTClientFactory.getInstance().startup(this.contextPath != null ? this.contextPath.substring(1) : null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        LOGGER.info("{} initialized.", (Object)this.contextPath);
    }
}

