/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.matrix;

public class Blas1D {
    public static double d_Abs(double x) {
        return x >= 0.0 ? x : -x;
    }

    public static double d_Max(double x, double y) {
        return y < x ? x : y;
    }

    public static double d_Sign(double x) {
        return x < 0.0 ? -1.0 : 1.0;
    }

    public static double dASum(int n, double[] x, int incx) {
        int j = 0;
        double value = 0.0;
        for (int i = 0; i < n; ++i) {
            value += Blas1D.d_Abs(x[j]);
            j += incx;
        }
        return value;
    }

    public static double dASum(int n, double[] x, int startx, int incx) {
        int j = 0;
        double value = 0.0;
        for (int i = 0; i < n; ++i) {
            value += Blas1D.d_Abs(x[startx + j]);
            j += incx;
        }
        return value;
    }

    public static void daxpy(int n, double da, double[] dx, int incx, double[] dy, int incy) {
        if (n <= 0) {
            return;
        }
        if (da == 0.0) {
            return;
        }
        if (incx != 1 || incy != 1) {
            int ix = 0 <= incx ? 0 : (-n + 1) * incx;
            int iy = 0 <= incy ? 0 : (-n + 1) * incy;
            for (int i = 0; i < n; ++i) {
                int n2 = iy;
                dy[n2] = dy[n2] + da * dx[ix];
                ix += incx;
                iy += incy;
            }
        } else {
            int i;
            int m = n % 4;
            for (i = 0; i < m; ++i) {
                int n3 = i;
                dy[n3] = dy[n3] + da * dx[i];
            }
            for (i = m; i < n; i += 4) {
                int n4 = i;
                dy[n4] = dy[n4] + da * dx[i];
                int n5 = i + 1;
                dy[n5] = dy[n5] + da * dx[i + 1];
                int n6 = i + 2;
                dy[n6] = dy[n6] + da * dx[i + 2];
                int n7 = i + 3;
                dy[n7] = dy[n7] + da * dx[i + 3];
            }
        }
    }

    public static void daxpy(int n, double da, double[] dx, int startx, int incx, double[] dy, int starty, int incy) {
        if (n <= 0) {
            return;
        }
        if (da == 0.0) {
            return;
        }
        if (incx != 1 || incy != 1) {
            int ix = 0 <= incx ? 0 : (-n + 1) * incx;
            int iy = 0 <= incy ? 0 : (-n + 1) * incy;
            for (int i = 0; i < n; ++i) {
                int n2 = starty + iy;
                dy[n2] = dy[n2] + da * dx[startx + ix];
                ix += incx;
                iy += incy;
            }
        } else {
            int i;
            int m = n % 4;
            for (i = 0; i < m; ++i) {
                int n3 = starty + i;
                dy[n3] = dy[n3] + da * dx[startx + i];
            }
            for (i = m; i < n; i += 4) {
                int n4 = starty + i;
                dy[n4] = dy[n4] + da * dx[startx + i];
                int n5 = starty + i + 1;
                dy[n5] = dy[n5] + da * dx[startx + i + 1];
                int n6 = starty + i + 2;
                dy[n6] = dy[n6] + da * dx[startx + i + 2];
                int n7 = starty + i + 3;
                dy[n7] = dy[n7] + da * dx[startx + i + 3];
            }
        }
    }

    public static double dDot(int n, double[] dx, int incx, double[] dy, int incy) {
        double dtemp = 0.0;
        if (n <= 0) {
            return dtemp;
        }
        if (incx != 1 || incy != 1) {
            int ix = 0 <= incx ? 0 : (-n + 1) * incx;
            int iy = 0 <= incy ? 0 : (-n + 1) * incy;
            for (int i = 0; i < n; ++i) {
                dtemp += dx[ix] * dy[iy];
                ix += incx;
                iy += incy;
            }
        } else {
            int i;
            int m = n % 5;
            for (i = 0; i < m; ++i) {
                dtemp += dx[i] * dy[i];
            }
            for (i = m; i < n; i += 5) {
                dtemp += dx[i] * dy[i] + dx[i + 1] * dy[i + 1] + dx[i + 2] * dy[i + 2] + dx[i + 3] * dy[i + 3] + dx[i + 4] * dy[i + 4];
            }
        }
        return dtemp;
    }

    public static double dDot(int n, double[] dx, int startx, int incx, double[] dy, int starty, int incy) {
        double dtemp = 0.0;
        if (n <= 0) {
            return dtemp;
        }
        if (incx != 1 || incy != 1) {
            int ix = 0 <= incx ? 0 : (-n + 1) * incx;
            int iy = 0 <= incy ? 0 : (-n + 1) * incy;
            for (int i = 0; i < n; ++i) {
                dtemp += dx[startx + ix] * dy[starty + iy];
                ix += incx;
                iy += incy;
            }
        } else {
            int i;
            int m = n % 5;
            for (i = 0; i < m; ++i) {
                dtemp += dx[startx + i] * dy[starty + i];
            }
            for (i = m; i < n; i += 5) {
                dtemp += dx[startx + i] * dy[starty + i] + dx[startx + i + 1] * dy[starty + i + 1] + dx[startx + i + 2] * dy[starty + i + 2] + dx[startx + i + 3] * dy[starty + i + 3] + dx[startx + i + 4] * dy[starty + i + 4];
            }
        }
        return dtemp;
    }

    public static void dScal(int n, double sa, double[] x, int incx) {
        block5: {
            if (n <= 0) break block5;
            if (incx == 1) {
                int m = n % 5;
                int i = 0;
                while (i < m) {
                    int n2 = i++;
                    x[n2] = x[n2] * sa;
                }
                for (i = m; i < n; i += 5) {
                    int n3 = i;
                    x[n3] = x[n3] * sa;
                    int n4 = i + 1;
                    x[n4] = x[n4] * sa;
                    int n5 = i + 2;
                    x[n5] = x[n5] * sa;
                    int n6 = i + 3;
                    x[n6] = x[n6] * sa;
                    int n7 = i + 4;
                    x[n7] = x[n7] * sa;
                }
            } else {
                int ix = 0 <= incx ? 0 : (-n + 1) * incx;
                for (int i = 0; i < n; ++i) {
                    int n8 = ix;
                    x[n8] = x[n8] * sa;
                    ix += incx;
                }
            }
        }
    }

    public static void dScal(int n, double sa, double[] x, int startx, int incx) {
        block5: {
            if (n <= 0) break block5;
            if (incx == 1) {
                int i;
                int m = n % 5;
                for (i = 0; i < m; ++i) {
                    int n2 = startx + i;
                    x[n2] = x[n2] * sa;
                }
                for (i = m; i < n; i += 5) {
                    int n3 = startx + i;
                    x[n3] = x[n3] * sa;
                    int n4 = startx + i + 1;
                    x[n4] = x[n4] * sa;
                    int n5 = startx + i + 2;
                    x[n5] = x[n5] * sa;
                    int n6 = startx + i + 3;
                    x[n6] = x[n6] * sa;
                    int n7 = startx + i + 4;
                    x[n7] = x[n7] * sa;
                }
            } else {
                int ix = 0 <= incx ? 0 : (-n + 1) * incx;
                for (int i = 0; i < n; ++i) {
                    int n8 = startx + ix;
                    x[n8] = x[n8] * sa;
                    ix += incx;
                }
            }
        }
    }

    public static int iDAMax(int n, double[] dx, int incx) {
        int value = 0;
        if (n < 1 || incx <= 0) {
            return value;
        }
        value = 1;
        if (n == 1) {
            return value;
        }
        if (incx == 1) {
            double dMax = Blas1D.d_Abs(dx[0]);
            for (int i = 1; i < n; ++i) {
                if (!(dMax < Blas1D.d_Abs(dx[i]))) continue;
                value = i + 1;
                dMax = Blas1D.d_Abs(dx[i]);
            }
        } else {
            int ix = 0;
            double dMax = Blas1D.d_Abs(dx[0]);
            ix += incx;
            for (int i = 1; i < n; ++i) {
                if (dMax < Blas1D.d_Abs(dx[ix])) {
                    value = i + 1;
                    dMax = Blas1D.d_Abs(dx[ix]);
                }
                ix += incx;
            }
        }
        return value;
    }

    public static int iDAMax(int n, double[] dx, int startx, int incx) {
        int value = 0;
        if (n < 1 || incx <= 0) {
            return value;
        }
        value = 1;
        if (n == 1) {
            return value;
        }
        if (incx == 1) {
            double dMax = Blas1D.d_Abs(dx[startx]);
            for (int i = 1; i < n; ++i) {
                if (!(dMax < Blas1D.d_Abs(dx[startx + i]))) continue;
                value = i + 1;
                dMax = Blas1D.d_Abs(dx[startx + i]);
            }
        } else {
            int ix = 0;
            double dMax = Blas1D.d_Abs(dx[startx]);
            ix += incx;
            for (int i = 1; i < n; ++i) {
                if (dMax < Blas1D.d_Abs(dx[startx + ix])) {
                    value = i + 1;
                    dMax = Blas1D.d_Abs(dx[startx + ix]);
                }
                ix += incx;
            }
        }
        return value;
    }
}

