/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.matrix;

import com.spss.math.matrix.DenseRectMatrix;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.statistics.MathFun;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DenseRectColOrderMatrix {
    private int nRows = 0;
    private int nCols = 0;
    private double[] mat = null;

    public DenseRectColOrderMatrix() {
    }

    public DenseRectColOrderMatrix(int nRows, int nCols) {
        this.nRows = nRows >= 0 ? nRows : 0;
        this.nCols = nCols >= 0 ? nCols : 0;
        this.mat = new double[this.nRows * this.nCols];
    }

    public DenseRectColOrderMatrix(DenseRectMatrix matR) {
        this.nRows = matR.getNRows();
        this.nCols = matR.getNCols();
        this.mat = new double[this.nRows * this.nCols];
        double[] vR = matR.getMatrix();
        int iMat = 0;
        for (int c = 0; c < this.nCols; ++c) {
            for (int r = 0; r < this.nRows; ++r) {
                this.mat[iMat++] = vR[c + r * this.nCols];
            }
        }
    }

    public void copyFrom(DenseRectMatrix matR) {
        int nRowsR = matR.getNRows();
        int nColsR = matR.getNCols();
        if (this.nRows != nRowsR || this.nCols != nColsR) {
            this.nRows = nRowsR;
            this.nCols = nColsR;
            this.mat = new double[this.nRows * this.nCols];
        }
        double[] vR = matR.getMatrix();
        int iMat = 0;
        for (int c = 0; c < this.nCols; ++c) {
            for (int r = 0; r < this.nRows; ++r) {
                this.mat[iMat++] = vR[c + r * this.nCols];
            }
        }
    }

    public boolean computeLR(DenseSymMatrix matL, DenseRectMatrix matOut) {
        boolean result = false;
        int nRRows = matL.getNRows();
        if (nRRows != this.nRows) {
            return result;
        }
        result = true;
        if (this.nRows != matOut.getNRows() || this.nCols != matOut.getNCols()) {
            matOut.resize(this.nRows, this.nCols);
        }
        double[] vL = matL.getMatrix();
        double[] vOut = matOut.getMatrix();
        int iOut = 0;
        int lFirst = 0;
        for (int iR = 0; iR < this.nRows; ++iR) {
            for (int iC = 0; iC < this.nCols; ++iC) {
                double dotProd = MathFun.dDot(iR + 1, vL, lFirst, 1, this.mat, this.nRows * iC, 1);
                vOut[iOut++] = dotProd;
            }
            lFirst += iR + 1;
        }
        return result;
    }

    public boolean computeSR(DenseSymMatrix matS, DenseRectMatrix matOut) {
        boolean result = false;
        int nRRows = matS.getNRows();
        if (nRRows != this.nRows) {
            return result;
        }
        result = true;
        if (this.nRows != matOut.getNRows() || this.nCols != matOut.getNCols()) {
            matOut.resize(this.nRows, this.nCols);
        }
        double[] vOut = matOut.getMatrix();
        int iOut = 0;
        for (int iR = 0; iR < this.nRows; ++iR) {
            double[] curRow = matS.getRow(iR);
            for (int iC = 0; iC < this.nCols; ++iC) {
                double dotProd = MathFun.dDot(this.nRows, curRow, 0, 1, this.mat, this.nRows * iC, 1);
                vOut[iOut++] = dotProd;
            }
        }
        return true;
    }

    public void resize(int nRows, int nCols) {
        this.nRows = nRows >= 0 ? nRows : 0;
        this.nCols = nCols >= 0 ? nCols : 0;
        this.mat = new double[this.nRows * this.nCols];
    }

    public void setElem(int iR, int iC, double val) {
        this.mat[iC * this.nRows + iR] = val;
    }

    public double getElem(int iR, int iC) {
        return this.mat[iC * this.nRows + iR];
    }

    public int getNRows() {
        return this.nRows;
    }

    public void setNRows(int nRows) {
        this.nRows = nRows > 0 ? nRows : 0;
        int vLen = this.nRows * this.nCols;
        this.mat = new double[vLen];
    }

    public int getNCols() {
        return this.nCols;
    }

    public void setNCols(int nCols) {
        this.nCols = nCols > 0 ? nCols : 0;
        int vLen = this.nRows * this.nCols;
        this.mat = new double[vLen];
    }

    public double[] getMat() {
        return this.mat;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nRows);
        dataOutput.writeInt(this.nCols);
        dataOutput.writeInt(this.mat.length);
        for (int i = 0; i < this.mat.length; ++i) {
            dataOutput.writeDouble(this.mat[i]);
        }
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.nRows = dataInput.readInt();
        this.nCols = dataInput.readInt();
        int matLen = dataInput.readInt();
        this.mat = new double[matLen];
        for (int i = 0; i < this.mat.length; ++i) {
            this.mat[i] = dataInput.readDouble();
        }
        return this;
    }
}

