/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.matrix;

import com.spss.math.matrix.Blas1D;

public class LinpackD {
    public static double dgeco(double[] a, int lda, int n, int[] ipvt, double[] z) {
        int l;
        double t;
        double s;
        int k;
        int i;
        int j;
        double anorm = 0.0;
        for (j = 1; j <= n; ++j) {
            anorm = Blas1D.d_Max(anorm, Blas1D.dASum(n, a, (j - 1) * lda, 1));
        }
        int info = LinpackD.dgefa(a, lda, n, ipvt);
        double ek = 1.0;
        for (i = 1; i <= n; ++i) {
            z[i - 1] = 0.0;
        }
        for (k = 1; k <= n; ++k) {
            if (z[k - 1] != 0.0) {
                ek *= Blas1D.d_Sign(-z[k - 1]);
            }
            if (Blas1D.d_Abs(a[k - 1 + (k - 1) * lda]) < Blas1D.d_Abs(ek - z[k - 1])) {
                s = Blas1D.d_Abs(a[k - 1 + (k - 1) * lda]) / Blas1D.d_Abs(ek - z[k - 1]);
                for (i = 1; i <= n; ++i) {
                    z[i - 1] = s * z[i - 1];
                }
                ek = s * ek;
            }
            double wk = ek - z[k - 1];
            double wkm = -ek - z[k - 1];
            s = Blas1D.d_Abs(wk);
            double sm = Blas1D.d_Abs(wkm);
            if (a[k - 1 + (k - 1) * lda] != 0.0) {
                wk /= a[k - 1 + (k - 1) * lda];
                wkm /= a[k - 1 + (k - 1) * lda];
            } else {
                wk = 1.0;
                wkm = 1.0;
            }
            if (k + 1 <= n) {
                for (j = k + 1; j <= n; ++j) {
                    sm += Blas1D.d_Abs(z[j - 1] + wkm * a[k - 1 + (j - 1) * lda]);
                    z[j - 1] = z[j - 1] + wk * a[k - 1 + (j - 1) * lda];
                    s += Blas1D.d_Abs(z[j - 1]);
                }
                if (s < sm) {
                    t = wkm - wk;
                    wk = wkm;
                    for (i = k + 1; i <= n; ++i) {
                        z[i - 1] = z[i - 1] + t * a[k - 1 + (i - 1) * lda];
                    }
                }
            }
            z[k - 1] = wk;
        }
        t = Blas1D.dASum(n, z, 1);
        for (i = 1; i <= n; ++i) {
            z[i - 1] = z[i - 1] / t;
        }
        for (k = n; 1 <= k; --k) {
            z[k - 1] = z[k - 1] + Blas1D.dDot(n - k, a, k + (k - 1) * lda, 1, z, k, 1);
            if (1.0 < Blas1D.d_Abs(z[k - 1])) {
                t = Blas1D.d_Abs(z[k - 1]);
                for (i = 1; i <= n; ++i) {
                    z[i - 1] = z[i - 1] / t;
                }
            }
            l = ipvt[k - 1];
            t = z[l - 1];
            z[l - 1] = z[k - 1];
            z[k - 1] = t;
        }
        t = Blas1D.dASum(n, z, 1);
        for (i = 1; i <= n; ++i) {
            z[i - 1] = z[i - 1] / t;
        }
        double ynorm = 1.0;
        for (k = 1; k <= n; ++k) {
            l = ipvt[k - 1];
            t = z[l - 1];
            z[l - 1] = z[k - 1];
            z[k - 1] = t;
            for (i = k + 1; i <= n; ++i) {
                z[i - 1] = z[i - 1] + t * a[i - 1 + (k - 1) * lda];
            }
            if (!(1.0 < Blas1D.d_Abs(z[k - 1]))) continue;
            ynorm /= Blas1D.d_Abs(z[k - 1]);
            t = Blas1D.d_Abs(z[k - 1]);
            for (i = 1; i <= n; ++i) {
                z[i - 1] = z[i - 1] / t;
            }
        }
        s = Blas1D.dASum(n, z, 1);
        for (i = 1; i <= n; ++i) {
            z[i - 1] = z[i - 1] / s;
        }
        ynorm /= s;
        for (k = n; 1 <= k; --k) {
            if (Blas1D.d_Abs(a[k - 1 + (k - 1) * lda]) < Blas1D.d_Abs(z[k - 1])) {
                s = Blas1D.d_Abs(a[k - 1 + (k - 1) * lda]) / Blas1D.d_Abs(z[k - 1]);
                for (i = 1; i <= n; ++i) {
                    z[i - 1] = s * z[i - 1];
                }
                ynorm = s * ynorm;
            }
            z[k - 1] = a[k - 1 + (k - 1) * lda] != 0.0 ? z[k - 1] / a[k - 1 + (k - 1) * lda] : 1.0;
            for (i = 1; i <= k - 1; ++i) {
                z[i - 1] = z[i - 1] - z[k - 1] * a[i - 1 + (k - 1) * lda];
            }
        }
        s = 1.0 / Blas1D.dASum(n, z, 1);
        for (i = 1; i <= n; ++i) {
            z[i - 1] = s * z[i - 1];
        }
        ynorm = s * ynorm;
        double rcond = anorm != 0.0 ? ynorm / anorm : 0.0;
        return rcond;
    }

    public static int dgefa(double[] a, int lda, int n, int[] ipvt) {
        int info = 0;
        for (int k = 1; k <= n - 1; ++k) {
            double t;
            int l;
            ipvt[k - 1] = l = Blas1D.iDAMax(n - k + 1, a, k - 1 + (k - 1) * lda, 1) + k - 1;
            if (a[l - 1 + (k - 1) * lda] == 0.0) {
                info = k;
                continue;
            }
            if (l != k) {
                t = a[l - 1 + (k - 1) * lda];
                a[l - 1 + (k - 1) * lda] = a[k - 1 + (k - 1) * lda];
                a[k - 1 + (k - 1) * lda] = t;
            }
            t = -1.0 / a[k - 1 + (k - 1) * lda];
            Blas1D.dScal(n - k, t, a, k + (k - 1) * lda, 1);
            for (int j = k + 1; j <= n; ++j) {
                t = a[l - 1 + (j - 1) * lda];
                if (l != k) {
                    a[l - 1 + (j - 1) * lda] = a[k - 1 + (j - 1) * lda];
                    a[k - 1 + (j - 1) * lda] = t;
                }
                Blas1D.daxpy(n - k, t, a, k + (k - 1) * lda, 1, a, k + (j - 1) * lda, 1);
            }
        }
        ipvt[n - 1] = n;
        if (a[n - 1 + (n - 1) * lda] == 0.0) {
            info = n;
        }
        return info;
    }

    public static void dgesl(double[] a, int lda, int n, int[] ipvt, double[] b, int job) {
        if (job == 0) {
            double t;
            int k;
            for (k = 1; k <= n - 1; ++k) {
                int l = ipvt[k - 1];
                t = b[l - 1];
                if (l != k) {
                    b[l - 1] = b[k - 1];
                    b[k - 1] = t;
                }
                Blas1D.daxpy(n - k, t, a, k + (k - 1) * lda, 1, b, k, 1);
            }
            for (k = n; 1 <= k; --k) {
                b[k - 1] = b[k - 1] / a[k - 1 + (k - 1) * lda];
                t = -b[k - 1];
                Blas1D.daxpy(k - 1, t, a, (k - 1) * lda, 1, b, 0, 1);
            }
        } else {
            double t;
            int k;
            for (k = 1; k <= n; ++k) {
                t = Blas1D.dDot(k - 1, a, (k - 1) * lda, 1, b, 0, 1);
                b[k - 1] = (b[k - 1] - t) / a[k - 1 + (k - 1) * lda];
            }
            for (k = n - 1; 1 <= k; --k) {
                b[k - 1] = b[k - 1] + Blas1D.dDot(n - k, a, k + (k - 1) * lda, 1, b, k, 1);
                int l = ipvt[k - 1];
                if (l == k) continue;
                t = b[l - 1];
                b[l - 1] = b[k - 1];
                b[k - 1] = t;
            }
        }
    }
}

