/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.random;

public class MCRNGUTwister {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int MULTIPLIER_1 = 1812433253;
    private static final int MULTIPLIER_2 = 1664525;
    private static final int MULTIPLIER_3 = 1566083941;
    private static final int MAGIC_SEED = 19650218;
    private static final int MASK_1 = -1658038656;
    private static final int MASK_2 = -272236544;
    private static final int DEFAULT_SEED = 5489;
    private int[] mt;
    private int mti = 625;

    public MCRNGUTwister(double seed) {
        this.setSeed(seed);
    }

    private void setSeed(double x) {
        if (0.0 <= x && x <= 2.147483647E9 && x == (double)((int)x)) {
            this.init_genrand((int)x);
        } else {
            int a = x == 0.0 ? 1 : 0;
            int b = x < 0.0 ? 1 : 0;
            double z = b == 1 ? -x : x;
            int c = z >= 1.0 ? 1 : 0;
            double mult = c == 1 ? 0.5 : 2.0;
            int d = 0;
            if (a == 0) {
                while (!(0.5 <= z) || !(z < 1.0)) {
                    z *= mult;
                    ++d;
                }
            }
            int[] seed = new int[3];
            seed[0] = a + 2 * (b + 2 * (c + 2 * d));
            seed[1] = (int)(z *= 6.7108864E7);
            z -= (double)seed[1];
            seed[2] = (int)(z *= 1.34217728E8);
            assert ((z -= (double)seed[2]) == 0.0);
            this.init_by_array(seed);
        }
    }

    public synchronized double nextDouble() {
        int a = this.genrand_int() >>> 5;
        int b = this.genrand_int() >>> 6;
        return ((double)a * 6.7108864E7 + (double)b) * (double)1.110223E-16f;
    }

    private void init_genrand(int s) {
        if (this.mt == null) {
            this.mt = new int[624];
        }
        this.mt[0] = s & 0xFFFFFFFF;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            ++this.mti;
        }
    }

    private void init_by_array(int[] init_key) {
        int k;
        this.init_genrand(19650218);
        int i = 1;
        int j = 0;
        int n = k = 624 > init_key.length ? 624 : init_key.length;
        while (k != 0) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1664525) + init_key[j] + j;
            ++j;
            if (++i >= 624) {
                this.mt[0] = this.mt[623];
                i = 1;
            }
            if (j >= init_key.length) {
                j = 0;
            }
            --k;
        }
        for (k = 623; k != 0; --k) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1566083941) - i;
            if (++i < 624) continue;
            this.mt[0] = this.mt[623];
            i = 1;
        }
        this.mt[0] = Integer.MIN_VALUE;
    }

    private int genrand_int() {
        int y = 0;
        if (this.mt == null) {
            this.init_genrand(5489);
        }
        if (this.mti >= 624) {
            int kk;
            int[] mag01 = new int[]{0, -1727483681};
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }
}

