/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.random;

import com.spss.math.random.RandomExt;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class RandomFiniteDiscrete {
    private final RandomExt random;
    private final int[] aliases;
    private final double[] probabilities;

    public RandomFiniteDiscrete(List<Double> probabilities, RandomExt random) {
        this.probabilities = new double[probabilities.size()];
        this.aliases = new int[probabilities.size()];
        this.random = random;
        double average = 1.0 / (double)probabilities.size();
        probabilities = new ArrayList<Double>(probabilities);
        ArrayDeque<Integer> smallProbabilities = new ArrayDeque<Integer>();
        ArrayDeque<Integer> largeProbabilities = new ArrayDeque<Integer>();
        for (int probabilityIndex = 0; probabilityIndex < probabilities.size(); ++probabilityIndex) {
            if (probabilities.get(probabilityIndex) >= average) {
                largeProbabilities.add(probabilityIndex);
                continue;
            }
            smallProbabilities.add(probabilityIndex);
        }
        while (!smallProbabilities.isEmpty() && !largeProbabilities.isEmpty()) {
            int less = (Integer)smallProbabilities.removeLast();
            int more = (Integer)largeProbabilities.removeLast();
            this.probabilities[less] = probabilities.get(less) * (double)probabilities.size();
            this.aliases[less] = more;
            probabilities.set(more, probabilities.get(more) + probabilities.get(less) - average);
            if (probabilities.get(more) >= 1.0 / (double)probabilities.size()) {
                largeProbabilities.add(more);
                continue;
            }
            smallProbabilities.add(more);
        }
        while (!smallProbabilities.isEmpty()) {
            this.probabilities[((Integer)smallProbabilities.removeLast()).intValue()] = 1.0;
        }
        while (!largeProbabilities.isEmpty()) {
            this.probabilities[((Integer)largeProbabilities.removeLast()).intValue()] = 1.0;
        }
    }

    public int next() {
        int column = this.random.nextInt(this.probabilities.length);
        boolean coin = this.random.nextDouble() < this.probabilities[column];
        return coin ? column : this.aliases[column];
    }
}

