/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.random;

import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.random.MCRNGUTwister;
import com.spss.math.statistics.MathFun;
import java.util.Arrays;

public class RandomValues {
    private long initSeed = 34567L;
    private MCRNGUTwister uniRNG;
    private double tolerance = 1.0E-12;
    private DistType distType = DistType.Uniform;
    private boolean univarDist = true;
    private int nVars = 0;
    private boolean standardDist = true;
    private double uniLowBound = 0.0;
    private double uniUppBound = 1.0;
    private double[] uniLowBounds = null;
    private double[] uniUppBounds = null;
    private double nrmMean = 0.0;
    private double[] nrmMeans = null;
    private double nrmSigmaSqr = 1.0;
    private DenseSymMatrix nrmCovar = null;
    private double chiDF = 0.0;
    private int wishartP = 0;
    private double wishartM = 0.0;
    private DenseSymMatrix wishartScale = null;
    private double nrmSigma = 1.0;
    private DenseSymMatrix nrmChol = null;
    private DenseSymMatrix wishartChol = null;

    public RandomValues() {
        this.uniRNG = new MCRNGUTwister(this.initSeed);
    }

    public RandomValues(long initSeed) {
        this.initSeed = initSeed;
        this.uniRNG = new MCRNGUTwister(this.initSeed);
    }

    public boolean setSeed(long seed) {
        boolean result;
        boolean bl = result = (double)seed > 0.0;
        if (result) {
            this.initSeed = seed;
            this.uniRNG = new MCRNGUTwister(this.initSeed);
        }
        return result;
    }

    public boolean setTolerance(double tol) {
        boolean result;
        boolean bl = result = tol > 0.0;
        if (result) {
            this.tolerance = tol;
        }
        return result;
    }

    public void setParamUniform() {
        this.uniLowBound = 0.0;
        this.uniUppBound = 1.0;
        this.distType = DistType.Uniform;
        this.standardDist = true;
        this.univarDist = true;
    }

    public boolean setParamUniform(double lowBound, double uppBound) {
        boolean result;
        boolean bl = result = lowBound < uppBound;
        if (result) {
            this.uniLowBound = lowBound;
            this.uniUppBound = uppBound;
            this.distType = DistType.Uniform;
            this.standardDist = this.uniLowBound == 0.0 && this.uniUppBound == 1.0;
            this.univarDist = true;
        }
        return result;
    }

    public boolean setParamUniform(int nVars) {
        boolean result;
        boolean bl = result = nVars > 0;
        if (result) {
            this.nVars = nVars;
            this.uniLowBounds = new double[nVars];
            this.uniUppBounds = new double[nVars];
            Arrays.fill(this.uniUppBounds, 1.0);
            this.distType = DistType.Uniform;
            this.standardDist = true;
            this.univarDist = false;
            if (nVars == 1) {
                this.uniLowBound = this.uniLowBounds[0];
                this.uniUppBound = this.uniUppBounds[0];
                this.univarDist = true;
            }
        }
        return result;
    }

    public boolean setParamUniform(double[] lowBounds, double[] uppBounds) {
        boolean result;
        int nVarsLocal = lowBounds.length;
        boolean standardDistLocal = true;
        boolean bl = result = nVarsLocal == uppBounds.length;
        if (result) {
            for (int i = 0; i < this.nVars; ++i) {
                boolean bl2 = result = lowBounds[i] < uppBounds[i];
                if (!result) break;
                standardDistLocal = standardDistLocal && lowBounds[i] == 0.0 && uppBounds[i] == 0.0;
            }
        }
        if (result) {
            this.distType = DistType.Uniform;
            this.nVars = nVarsLocal;
            this.standardDist = standardDistLocal;
            this.univarDist = false;
            this.uniLowBounds = Arrays.copyOf(lowBounds, this.nVars);
            this.uniUppBounds = Arrays.copyOf(uppBounds, this.nVars);
            if (this.nVars == 1) {
                this.uniLowBound = this.uniLowBounds[0];
                this.uniUppBound = this.uniUppBounds[0];
                this.univarDist = true;
            }
        }
        return result;
    }

    public void setParamNormal() {
        this.nrmMean = 0.0;
        this.nrmSigmaSqr = 1.0;
        this.nrmSigma = 1.0;
        this.distType = DistType.Normal;
        this.standardDist = true;
        this.univarDist = true;
    }

    public boolean setParamNormal(double mean, double sigmaSqr) {
        boolean result;
        boolean bl = result = sigmaSqr > 0.0;
        if (result) {
            this.nrmMean = mean;
            this.nrmSigmaSqr = sigmaSqr;
            this.nrmSigma = Math.sqrt(this.nrmSigmaSqr);
            this.distType = DistType.Normal;
            this.standardDist = this.nrmMean == 0.0 && this.nrmSigmaSqr == 1.0;
            this.univarDist = true;
        }
        return result;
    }

    public boolean setParamNormal(int nVars) {
        boolean result;
        boolean bl = result = nVars > 0;
        if (result) {
            this.nVars = nVars;
            this.nrmMeans = new double[nVars];
            this.nrmSigmaSqr = 1.0;
            this.nrmSigma = 1.0;
            this.distType = DistType.Normal;
            this.standardDist = true;
            this.univarDist = false;
            this.nrmCovar = new DenseSymMatrix(this.nVars);
            for (int i = 0; i < nVars; ++i) {
                this.nrmCovar.setElem(i, i, 1.0);
            }
            if (nVars == 1) {
                this.nrmMean = 0.0;
                this.nrmSigmaSqr = 1.0;
                this.nrmSigma = 1.0;
                this.univarDist = true;
            }
        }
        return result;
    }

    public boolean setParamNormal(double[] means, double sigmaSq, DenseSymMatrix covar) {
        boolean result;
        int nVarsLocal = means.length;
        boolean bl = result = nVarsLocal > 0 && nVarsLocal == covar.getNRows() && sigmaSq > 0.0;
        if (result) {
            this.nVars = nVarsLocal;
            this.nrmMeans = new double[this.nVars];
            MathFun.dCopy(means, this.nrmMeans);
            this.nrmSigmaSqr = sigmaSq;
            this.nrmSigma = Math.sqrt(this.nrmSigmaSqr);
            this.nrmCovar = new DenseSymMatrix(this.nVars);
            covar.copyTo(this.nrmCovar);
            this.distType = DistType.Normal;
            this.standardDist = false;
            this.univarDist = false;
            if (this.nVars == 1) {
                this.nrmMean = this.nrmMeans[0];
                this.univarDist = true;
            }
        }
        if (result && !this.univarDist) {
            this.nrmChol = new DenseSymMatrix(this.nVars);
            this.nrmCovar.copyTo(this.nrmChol);
            double[] minDg = new double[1];
            int nDep = this.nrmChol.lTChol(this.tolerance, 1.0E-4, minDg, false);
            result = nDep != -1 && nDep < this.nVars;
        }
        return result;
    }

    public boolean setParamChi(double df) {
        boolean result;
        boolean bl = result = df > 0.0;
        if (result) {
            this.chiDF = df;
            this.distType = DistType.Chisquare;
            this.standardDist = false;
            this.univarDist = true;
        }
        return result;
    }

    public boolean setParamWishart(int paramP, double paramM) {
        boolean result;
        boolean bl = result = paramP > 0 && paramM >= (double)paramP;
        if (result) {
            this.nVars = paramP;
            this.wishartP = paramP;
            this.wishartM = paramM;
            this.distType = DistType.Wishart;
            this.standardDist = true;
            this.univarDist = false;
            this.wishartScale = new DenseSymMatrix(this.wishartP);
            for (int i = 0; i < this.wishartP; ++i) {
                this.wishartScale.setElem(i, i, 1.0);
            }
        }
        return result;
    }

    public boolean setParamWishart(int paramP, double paramM, DenseSymMatrix scale) {
        boolean result;
        boolean bl = result = paramP > 0 && paramM >= (double)paramP && scale.getNRows() == paramP;
        if (result) {
            this.nVars = paramP;
            this.wishartP = paramP;
            this.wishartM = paramM;
            this.distType = DistType.Wishart;
            this.standardDist = false;
            this.univarDist = false;
            this.wishartScale = new DenseSymMatrix(this.wishartP);
            this.wishartChol = new DenseSymMatrix(this.wishartP);
            scale.copyTo(this.wishartScale);
            scale.copyTo(this.wishartChol);
            double[] minDg = new double[1];
            int nDep = this.wishartChol.lTChol(this.tolerance, 1.0E-4, minDg, false);
            result = nDep != -1 && nDep < this.wishartP;
        }
        return result;
    }

    public double getRandom() {
        double result = MissingValue.getMissing();
        if (this.univarDist) {
            if (this.distType == DistType.Uniform) {
                result = this.rVUni(this.uniLowBound, this.uniUppBound);
            } else if (this.distType == DistType.Normal) {
                result = this.rVNor(this.nrmMean, this.nrmSigma);
            } else if (this.distType == DistType.Chisquare) {
                result = this.rVChi(this.chiDF);
            }
        }
        return result;
    }

    public boolean getRandom(double[] rndVec) {
        boolean result;
        boolean bl = result = !this.univarDist && this.distType != DistType.Chisquare && this.distType != DistType.Wishart && rndVec.length >= this.nVars;
        if (result) {
            if (this.distType == DistType.Uniform) {
                for (int iVar = 0; iVar < this.nVars; ++iVar) {
                    double rnd;
                    rndVec[iVar] = rnd = this.rVUni(this.uniLowBounds[iVar], this.uniUppBounds[iVar]);
                }
            } else if (this.distType == DistType.Normal) {
                if (this.standardDist) {
                    for (int iVar = 0; iVar < this.nVars; ++iVar) {
                        double rnd;
                        rndVec[iVar] = rnd = this.rVSNor();
                    }
                } else {
                    double rnd;
                    int iVar;
                    double[] z = new double[this.nVars];
                    for (iVar = 0; iVar < this.nVars; ++iVar) {
                        z[iVar] = rnd = this.rVSNor();
                    }
                    double[] cholByZ = new double[this.nVars];
                    this.nrmChol.computeLV(z, cholByZ);
                    for (iVar = 0; iVar < this.nVars; ++iVar) {
                        rndVec[iVar] = rnd = this.nrmMeans[iVar] + this.nrmSigma * cholByZ[iVar];
                    }
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    public boolean getRandom(DenseSymMatrix rndSym) {
        boolean result;
        boolean bl = result = !this.univarDist && this.distType == DistType.Wishart;
        if (result) {
            DenseSymMatrix lowerTrA = new DenseSymMatrix(this.nVars);
            for (int iRow = 0; iRow < this.wishartP; ++iRow) {
                double df = this.wishartM - (double)this.wishartP;
                double rnd = this.rVChi(df);
                boolean bl2 = result = !MissingValue.isMissing(rnd) && rnd >= 0.0;
                if (!result) break;
                lowerTrA.setElem(iRow, iRow, Math.sqrt(rnd));
                for (int iCol = 0; iCol < iRow; ++iCol) {
                    rnd = this.rVSNor();
                    lowerTrA.setElem(iRow, iCol, rnd);
                }
            }
            if (result) {
                if (this.standardDist) {
                    lowerTrA.copyTo(rndSym);
                    rndSym.lTLLTrans();
                } else {
                    DenseSymMatrix tempX = new DenseSymMatrix(this.nVars);
                    lowerTrA.copyTo(tempX);
                    tempX.lTLLTrans();
                    result = tempX.computeLSLTrans(this.wishartChol, rndSym);
                }
            }
        }
        return result;
    }

    private double rVUni(double a, double b) {
        double result = MissingValue.getMissing();
        if (a <= b) {
            double u = this.uniRNG.nextDouble();
            result = a + (b - a) * u;
        }
        return result;
    }

    private static double rVAuxF(double x) {
        double a = 2.216035867166471;
        double c1 = 0.3989422804014327;
        double p1 = 0.180025191068563;
        double result = 0.0;
        if (x != 0.0) {
            double diff = 2.216035867166471 - Math.abs(x);
            if (diff < 0.0) {
                diff = 0.0;
            }
            if ((result = 0.3989422804014327 * Math.exp(-0.5 * x * x) - 0.180025191068563 * diff) < 0.0) {
                result = 0.0;
            }
        }
        return result;
    }

    private double rVSNor() {
        double a = 2.216035867166471;
        double asqhal = 2.455407482284127;
        double c1 = 1.13113163544418;
        double c21 = 0.479727404222441;
        double c22 = 0.59550713801594;
        double c23 = 0.805577924423817;
        double c24 = 0.053377549506886;
        double c31 = 0.479727404222441;
        double c32 = 1.10547366102207;
        double c33 = 0.87283497667179;
        double c34 = 0.049264496373128;
        double c42 = 0.63083480192196;
        double c43 = 0.755591531667601;
        double c44 = 0.034240503750111;
        double c5 = 0.986655477086949;
        double ubd1 = 0.884070402298758;
        double ubd2 = 0.911312780288703;
        double ubd3 = 0.958720824790463;
        double ubd4 = 0.973310954173898;
        double result = 0.0;
        double u = 0.0;
        double v = 0.0;
        double w = 0.0;
        double minV = 0.0;
        double maxV = 0.0;
        boolean bRej = false;
        u = this.uniRNG.nextDouble();
        if (u < 0.884070402298758) {
            result = 2.216035867166471 * (1.13113163544418 * u + this.uniRNG.nextDouble()) - 2.216035867166471;
        } else if (u < 0.911312780288703) {
            bRej = true;
            while (bRej) {
                v = this.uniRNG.nextDouble();
                w = this.uniRNG.nextDouble();
                minV = v;
                maxV = v;
                if (w < minV) {
                    minV = w;
                }
                if (w > maxV) {
                    maxV = w;
                }
                result = 0.479727404222441 - 0.59550713801594 * minV;
                if (maxV <= 0.805577924423817) {
                    bRej = false;
                    continue;
                }
                if (!(result >= 0.0)) continue;
                bRej = 0.053377549506886 * Math.abs(v - w) > RandomValues.rVAuxF(result);
            }
            if (v >= w) {
                result = -result;
            }
        } else if (u < 0.958720824790463) {
            bRej = true;
            while (bRej) {
                v = this.uniRNG.nextDouble();
                w = this.uniRNG.nextDouble();
                minV = v;
                maxV = v;
                if (w < minV) {
                    minV = w;
                }
                if (w > maxV) {
                    maxV = w;
                }
                result = 0.479727404222441 + 1.10547366102207 * minV;
                if (maxV <= 0.87283497667179) {
                    bRej = false;
                    continue;
                }
                bRej = 0.049264496373128 * Math.abs(v - w) > RandomValues.rVAuxF(result);
            }
            if (v >= w) {
                result = -result;
            }
        } else if (u < 0.973310954173898) {
            bRej = true;
            while (bRej) {
                v = this.uniRNG.nextDouble();
                w = this.uniRNG.nextDouble();
                minV = v;
                maxV = v;
                if (w < minV) {
                    minV = w;
                }
                if (w > maxV) {
                    maxV = w;
                }
                result = 2.216035867166471 - 0.63083480192196 * minV;
                if (maxV <= 0.755591531667601) {
                    bRej = false;
                    continue;
                }
                bRej = 0.034240503750111 * Math.abs(v - w) > RandomValues.rVAuxF(result);
            }
            if (v >= w) {
                result = -result;
            }
        } else {
            bRej = true;
            while (bRej) {
                v = this.uniRNG.nextDouble();
                bRej = v * v * (result = 2.455407482284127 - Math.log(this.uniRNG.nextDouble())) > 2.455407482284127;
            }
            result = Math.sqrt(result + result);
            if (u >= 0.986655477086949) {
                result = -result;
            }
        }
        return result;
    }

    private double rVNor(double a, double b) {
        double result = MissingValue.getMissing();
        if (b == 0.0) {
            result = a;
        } else if (b > 0.0) {
            result = a + b * this.rVSNor();
        }
        return result;
    }

    private double RVExp(double a) {
        double u;
        double result = MissingValue.getMissing();
        if (a > 0.0 && (u = this.uniRNG.nextDouble()) < 1.0) {
            result = -Math.log(1.0 - u) / a;
        }
        return result;
    }

    private double rVGam(double a, double b) {
        double e = Math.E;
        double result = MissingValue.getMissing();
        if (a > 0.0 && b > 0.0) {
            boolean bRepeat = true;
            if (a == 1.0) {
                result = this.RVExp(1.0);
            } else if (a < 1.0) {
                double g = (Math.E + a) / Math.E;
                while (bRepeat) {
                    double x;
                    double u = this.uniRNG.nextDouble();
                    while (u == 0.0) {
                        u = this.uniRNG.nextDouble();
                    }
                    double p = g * u;
                    if (p <= 1.0) {
                        x = Math.exp(Math.log(p) / a);
                        u = this.uniRNG.nextDouble();
                        if (!(u <= Math.exp(-x))) continue;
                        result = x;
                        bRepeat = false;
                        continue;
                    }
                    x = -Math.log((g - p) / a);
                    if (!(x > 0.0) || !(Math.log(1.0 - (u = this.uniRNG.nextDouble())) <= Math.log(x) * (a - 1.0))) continue;
                    result = x;
                    bRepeat = false;
                }
            } else {
                while (bRepeat) {
                    double u = this.uniRNG.nextDouble();
                    double y = -Math.log(1.0 - u);
                    double z = (1.0 - y + Math.log(y)) * (a - 1.0);
                    u = this.uniRNG.nextDouble();
                    if (!(Math.log(1.0 - u) <= z)) continue;
                    result = a * y;
                    bRepeat = false;
                }
            }
            result /= b;
        }
        return result;
    }

    private double rVChi(double a) {
        double result = MissingValue.getMissing();
        if (a > 0.0) {
            result = this.rVGam(a * 0.5, 0.5);
        }
        return result;
    }

    public static enum DistType {
        Uniform,
        Normal,
        Chisquare,
        Wishart;

    }
}

