/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.statistics;

import java.util.BitSet;

public class CCBitSet {
    private int fSetSize;
    private BitSet fBitSet;

    public CCBitSet() {
        this.fSetSize = 0;
        this.fBitSet = new BitSet(0);
    }

    public CCBitSet(int setSize) {
        this.fSetSize = setSize;
        this.fBitSet = new BitSet(this.fSetSize);
    }

    public CCBitSet(CCBitSet bSet) {
        this.fSetSize = bSet.size();
        this.fBitSet = bSet.getBitSet(0, this.fSetSize);
    }

    public boolean less(CCBitSet bs) {
        int size = Math.min(this.size(), bs.size());
        for (int i = 0; i < size; ++i) {
            if (!this.get(i) && bs.get(i)) {
                return true;
            }
            if (!this.get(i) || bs.get(i)) continue;
            return false;
        }
        return size == this.size() && this.size() != bs.size();
    }

    public int size() {
        return this.fSetSize;
    }

    public BitSet getBitSet() {
        return this.fBitSet.get(0, this.fSetSize);
    }

    public BitSet getBitSet(int from, int to) {
        return this.fBitSet.get(from, to);
    }

    public void clear() {
        this.fBitSet.clear();
    }

    public CCBitSet clone() {
        CCBitSet cloneSet = new CCBitSet(this);
        return cloneSet;
    }

    public boolean set(int index, boolean value) {
        boolean result = false;
        if (index >= 0 && index < this.fSetSize) {
            this.fBitSet.set(index, value);
            result = true;
        }
        return result;
    }

    public boolean set(int index) {
        return this.set(index, true);
    }

    public boolean set(boolean[] values) {
        boolean result = true;
        this.fSetSize = values.length;
        this.fBitSet = new BitSet(this.fSetSize);
        for (int i = 0; i < this.fSetSize; ++i) {
            this.fBitSet.set(i, values[i]);
        }
        return result;
    }

    public boolean get(int bitIndex) {
        return this.fBitSet.get(bitIndex);
    }

    public boolean equals(CCBitSet bSet) {
        return this.fSetSize == bSet.size() && this.fBitSet.equals(bSet.getBitSet());
    }

    public void negate() {
        this.fBitSet.flip(0, this.fSetSize);
    }

    public void doAND(CCBitSet bSet1, CCBitSet bSet2) {
        this.fSetSize = bSet1.size();
        if (this.fSetSize > bSet2.size()) {
            this.fSetSize = bSet2.size();
        }
        this.fBitSet = bSet1.getBitSet(0, this.fSetSize);
        BitSet set2 = bSet2.getBitSet(0, this.fSetSize);
        this.fBitSet.and(set2);
    }

    public void doOR(CCBitSet bSet1, CCBitSet bSet2) {
        this.fSetSize = bSet1.size();
        if (this.fSetSize > bSet2.size()) {
            this.fSetSize = bSet2.size();
        }
        this.fBitSet = bSet1.getBitSet(0, this.fSetSize);
        BitSet set2 = bSet2.getBitSet(0, this.fSetSize);
        this.fBitSet.or(set2);
    }

    public CCBitSet getSubset(int iFirst, int iLast) {
        CCBitSet result = new CCBitSet();
        int iFirstLocal = iFirst;
        int iLastLocal = iLast;
        if (iFirst < 0) {
            iFirstLocal = 0;
        }
        if (iLast > this.fSetSize - 1) {
            iLastLocal = this.fSetSize - 1;
        }
        if (iFirstLocal <= iLastLocal) {
            int setSize = iLastLocal - iFirstLocal + 1;
            result.resize(setSize);
            int newIndex = 0;
            for (int i = iFirstLocal; i <= iLastLocal; ++i) {
                result.set(newIndex++, this.fBitSet.get(i));
            }
        }
        return result;
    }

    public void resize(int newSize, boolean value) {
        if (newSize > 0) {
            this.fSetSize = newSize;
            this.fBitSet = new BitSet(this.fSetSize);
            this.fBitSet.set(0, this.fSetSize, value);
        } else {
            this.fSetSize = 0;
            this.fBitSet = new BitSet(0);
        }
    }

    public void resize(int newSize) {
        this.resize(newSize, false);
    }

    public boolean isIn(int index) {
        boolean result = false;
        if (index >= 0 && index < this.fSetSize) {
            result = this.fBitSet.get(index);
        }
        return result;
    }

    public void append(boolean value) {
        BitSet newSet = new BitSet(this.fSetSize + 1);
        for (int i = 0; i < this.fSetSize; ++i) {
            newSet.set(i, this.fBitSet.get(i));
        }
        newSet.set(this.fSetSize, value);
        this.fBitSet = newSet;
        ++this.fSetSize;
    }

    public void append() {
        this.append(false);
    }

    public int inRange(int iFirst, int iLast) {
        int result = -1;
        if (iFirst >= 0 && iFirst <= iLast && iLast < this.fSetSize) {
            result = 0;
            for (int i = iFirst; i <= iLast; ++i) {
                if (!this.fBitSet.get(i)) continue;
                ++result;
            }
        }
        return result;
    }

    public int inRangeS(int iFirst, int rSize) {
        return this.inRange(iFirst, iFirst + rSize - 1);
    }

    public int inSet() {
        return this.fBitSet.cardinality();
    }

    public boolean isNewFalse(CCBitSet another, int nCompare) {
        boolean result = false;
        int nCheck = this.fSetSize;
        if (nCompare < nCheck) {
            nCheck = nCompare;
        }
        for (int i = 0; i < nCheck; ++i) {
            if (!this.fBitSet.get(i) || another.isIn(i)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean setRange(int iFirst, int iLast, boolean value) {
        boolean result = false;
        if (iFirst >= 0 && iFirst <= iLast && iLast < this.fSetSize) {
            result = true;
            for (int i = iFirst; i <= iLast; ++i) {
                this.fBitSet.set(i, value);
            }
        }
        return result;
    }

    public boolean setRange(int iFirst, int iLast) {
        return this.setRange(iFirst, iLast, true);
    }

    public boolean setSubset(int[] iVec, boolean value) {
        int i;
        boolean result = true;
        int vLen = iVec.length;
        for (i = 0; i < vLen; ++i) {
            if (iVec[i] >= 0 && iVec[i] < this.fSetSize) continue;
            result = false;
        }
        if (result) {
            for (i = 0; i < vLen; ++i) {
                this.fBitSet.set(iVec[i], value);
            }
        }
        return result;
    }

    public boolean setSubset(int[] iVec) {
        return this.setSubset(iVec, true);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CCBitSet [");
        for (int i = 0; i < this.fSetSize; ++i) {
            builder.append(this.isIn(i));
            if (i == this.fSetSize - 1) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }
}

