/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.statistics;

import com.spss.math.MissingValue;
import com.spss.math.statistics.MathFun;
import com.spss.math.statistics.Power;
import java.util.Arrays;
import java.util.List;

public class MonotoneCubicInterpolation {
    private static final double TOLERANCE = 1.0E-14;
    List<Double> ST = null;
    double[] copyST = null;
    List<Double> IT = null;
    boolean isValidParameters = false;
    boolean isHandleOutside = false;
    boolean isPositiveInfinity = false;
    MonoCubicConditions curMonoCubicMethod = MonoCubicConditions.UNKNOWN;
    boolean calcIntermediate = false;
    double intermediateA = MissingValue.getMissing();
    double intermediateB = MissingValue.getMissing();
    double intermediateC = MissingValue.getMissing();
    double tailCorrToPosInfC = MissingValue.getMissing();
    double[] scopes = null;
    double[] averageSecants = null;
    double[] alphas = null;
    double[] betas = null;

    public boolean setDistinctThresholdValues(List<Double> ST, List<Double> IT) {
        this.isValidParameters = false;
        this.isValidParameters = this.hasValidParameters(ST, IT);
        if (this.isValidParameters) {
            this.ST = ST;
            this.copyST = new double[this.ST.size()];
            for (int i = 0; i < ST.size(); ++i) {
                this.copyST[i] = ST.get(i);
            }
            this.IT = IT;
            this.isPositiveInfinity = this.positiveInfinity(this.ST);
            this.curMonoCubicMethod = MonoCubicConditions.UNKNOWN;
            this.calcIntermediate = false;
            this.intermediateA = MissingValue.getMissing();
            this.intermediateB = MissingValue.getMissing();
            this.intermediateC = MissingValue.getMissing();
            this.tailCorrToPosInfC = MissingValue.getMissing();
            this.scopes = null;
            this.averageSecants = null;
            this.alphas = null;
            this.betas = null;
        }
        return this.isValidParameters;
    }

    public void setHandleOutside(boolean handle) {
        this.isHandleOutside = handle;
    }

    public double calcMonotoneCubicInterpolation(double x) {
        int usedRange;
        int ipos;
        double result = MissingValue.getMissing();
        if (!this.isValidParameters) {
            return result;
        }
        if (this.isHandleOutside) {
            if (Double.compare(x, this.ST.get(0)) == -1) {
                result = this.IT.get(0);
                return result;
            }
            if (Double.compare(x, this.ST.get(this.ST.size() - 1)) == 1) {
                result = this.IT.get(this.IT.size() - 1);
                return result;
            }
        }
        if ((ipos = this.locatePosition(x, usedRange = this.ST.size())) < 0 || ipos >= usedRange - 1) {
            return result;
        }
        this.curMonoCubicMethod = this.locateMonoCubicCondition(ipos, usedRange);
        if (this.curMonoCubicMethod == MonoCubicConditions.UNKNOWN) {
            return result;
        }
        if (this.curMonoCubicMethod == MonoCubicConditions.BISPOSINF) {
            this.calcIntermediateABC();
        } else if (this.curMonoCubicMethod == MonoCubicConditions.CISPOSINF) {
            this.calcIntermediateABC();
            this.calcTailCorrelation();
        }
        if (this.curMonoCubicMethod == MonoCubicConditions.AISPOSINF || this.curMonoCubicMethod == MonoCubicConditions.CISPOSINF || this.curMonoCubicMethod == MonoCubicConditions.ANOTPOSINF) {
            this.calcAverageSecants();
        }
        if (this.curMonoCubicMethod == MonoCubicConditions.AISPOSINF) {
            result = this.calcCubeInterpolation(x, this.ST.size() - 1);
        } else if (this.curMonoCubicMethod == MonoCubicConditions.BISPOSINF) {
            result = this.calcMonoCubicCondBforPosInf(x);
        } else if (this.curMonoCubicMethod == MonoCubicConditions.CISPOSINF) {
            result = this.calcCubeInterpolation(x, this.ST.size() - 1);
        } else if (this.curMonoCubicMethod == MonoCubicConditions.ANOTPOSINF) {
            result = this.calcCubeInterpolation(x, this.ST.size());
        } else if (this.curMonoCubicMethod == MonoCubicConditions.BNOTPOSINF) {
            result = this.calcMonoCubicCondBnotPosInf(x);
        }
        return result;
    }

    public double[] calcMonotoneCubicInterpolations(List<Double> x) {
        int cnt = x.size();
        double[] results = new double[cnt];
        if (!this.isValidParameters) {
            Arrays.fill(results, MissingValue.getMissing());
            return results;
        }
        for (int i = 0; i < cnt; ++i) {
            double interpolation;
            results[i] = interpolation = this.calcMonotoneCubicInterpolation(x.get(i));
        }
        return results;
    }

    public double calcMonotoneCubicInterpolation(List<Double> ST, List<Double> IT, double x) {
        double result = MissingValue.getMissing();
        if (!this.setDistinctThresholdValues(ST, IT)) {
            return result;
        }
        result = this.calcMonotoneCubicInterpolation(x);
        return result;
    }

    public double[] calcMonotoneCubicInterpolations(List<Double> ST, List<Double> IT, List<Double> x) {
        int cnt = x.size();
        double[] results = new double[cnt];
        if (!this.setDistinctThresholdValues(ST, IT)) {
            Arrays.fill(results, MissingValue.getMissing());
            return results;
        }
        results = this.calcMonotoneCubicInterpolations(x);
        return results;
    }

    private boolean hasValidParameters(List<Double> ST, List<Double> IT) {
        if (!this.isValidParameters) {
            if (ST == null || IT == null) {
                throw new IllegalArgumentException();
            }
            int n = ST.size();
            if (n != IT.size() || n < 2) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < n - 1; ++i) {
                if (!(ST.get(i) > ST.get(i + 1)) && !(IT.get(i) > IT.get(i + 1))) continue;
                throw new IllegalArgumentException();
            }
            this.isValidParameters = true;
        }
        return this.isValidParameters;
    }

    private boolean positiveInfinity(List<Double> ST) {
        return Double.compare(Double.POSITIVE_INFINITY, ST.get(ST.size() - 1)) == 0;
    }

    private int locatePosition(double x, int usedRange) {
        int ipos = -1;
        if (Double.compare(x, this.copyST[0]) == 0) {
            ipos = 0;
        } else {
            ipos = MathFun.binSearch(this.copyST, 1, usedRange - 1, x, false);
            --ipos;
        }
        return ipos;
    }

    private MonoCubicConditions locateMonoCubicCondition(int position, int usedRange) {
        MonoCubicConditions method = MonoCubicConditions.UNKNOWN;
        if (position < 0) {
            return method;
        }
        int n = usedRange;
        method = this.isPositiveInfinity ? (n > 3 && position < n - 3 ? MonoCubicConditions.AISPOSINF : (n == 3 || position > n - 3 ? MonoCubicConditions.BISPOSINF : MonoCubicConditions.CISPOSINF)) : (n > 2 ? MonoCubicConditions.ANOTPOSINF : MonoCubicConditions.BNOTPOSINF);
        return method;
    }

    private void calcIntermediateABC() {
        if (!this.calcIntermediate) {
            int n = this.ST.size();
            this.intermediateA = this.IT.get(n - 1);
            double n1n3 = this.IT.get(n - 1) - this.IT.get(n - 3);
            double n1n2 = this.IT.get(n - 1) - this.IT.get(n - 2);
            double pow1 = Power.pow(n1n3, this.ST.get(n - 2));
            double pow2 = Power.pow(n1n2, this.ST.get(n - 3));
            double n2n3 = this.ST.get(n - 2) - this.ST.get(n - 3);
            this.intermediateB = Power.pow(pow1 / pow2, 1.0 / n2n3);
            this.intermediateC = Math.log(n1n3 / n1n2) / n2n3;
            this.calcIntermediate = true;
        }
    }

    private void calcTailCorrelation() {
        if (MissingValue.isMissing(this.tailCorrToPosInfC) && !MissingValue.isMissing(this.intermediateB) && !MissingValue.isMissing(this.intermediateC)) {
            this.tailCorrToPosInfC = this.intermediateB * this.intermediateC * Math.exp(-this.intermediateC * this.ST.get(this.ST.size() - 2));
        }
    }

    private void calcAverageSecants() {
        int i;
        int n = this.ST.size();
        double tmp1 = MissingValue.getMissing();
        double tmp2 = MissingValue.getMissing();
        this.scopes = new double[n - 1];
        for (i = 0; i < n - 1; ++i) {
            tmp1 = this.IT.get(i + 1) - this.IT.get(i);
            tmp2 = this.ST.get(i + 1) - this.ST.get(i);
            this.scopes[i] = tmp1 / tmp2;
        }
        this.averageSecants = new double[n];
        this.averageSecants[n - 1] = this.scopes[n - 2];
        for (i = 0; i < n - 1; ++i) {
            if (this.scopes[i] < 1.0E-14) {
                this.averageSecants[i] = 0.0;
                this.averageSecants[i + 1] = 0.0;
                ++i;
                continue;
            }
            this.averageSecants[i] = i == 0 ? this.scopes[i] : this.scopes[i - 1] + this.scopes[i] / 2.0;
        }
        this.averageSecants[n - 1] = this.scopes[n - 2];
        for (i = 0; i < n - 1; ++i) {
            if (this.scopes[i] < 1.0E-14) {
                this.averageSecants[i] = 0.0;
                this.averageSecants[i + 1] = 0.0;
                ++i;
                continue;
            }
            this.averageSecants[i] = i == 0 ? this.scopes[0] : (this.scopes[i - 1] + this.scopes[i]) / 2.0;
        }
        this.alphas = new double[n - 1];
        this.betas = new double[n - 1];
        for (i = 0; i < n - 1; ++i) {
            if (this.scopes[i] > 1.0E-14) {
                this.alphas[i] = this.averageSecants[i] / this.scopes[i];
                this.betas[i] = this.averageSecants[i + 1] / this.scopes[i];
                continue;
            }
            this.alphas[i] = 0.0;
            this.betas[i] = 0.0;
        }
        for (i = 0; i < n - 1; ++i) {
            double tmp;
            if (!(this.averageSecants[i] > 1.0E-14) || !((tmp = this.alphas[i] * this.alphas[i] + this.betas[i] * this.betas[i]) > 9.0)) continue;
            double t = 3.0 / Math.sqrt(tmp);
            this.averageSecants[i] = t * this.alphas[i] * this.scopes[i];
            this.averageSecants[i + 1] = t * this.betas[i] * this.scopes[i];
            ++i;
        }
    }

    private double calcMonoCubicCondBforPosInf(double x) {
        double result = MissingValue.getMissing();
        if (!(MissingValue.isMissing(this.intermediateA) || MissingValue.isMissing(this.intermediateB) || MissingValue.isMissing(this.intermediateC))) {
            result = this.intermediateA - this.intermediateB * Math.exp(-this.intermediateC * x);
        }
        return result;
    }

    private double calcMonoCubicCondBnotPosInf(double x) {
        return this.IT.get(0) + (this.IT.get(1) - this.IT.get(0)) * (x - this.ST.get(0)) / (this.ST.get(1) - this.ST.get(0));
    }

    private double calcCubeInterpolation(double x, int usedRange) {
        double result = MissingValue.getMissing();
        int n = usedRange;
        int ipos = this.locatePosition(x, usedRange);
        if (ipos >= 0 && ipos < n - 1) {
            if (this.curMonoCubicMethod == MonoCubicConditions.CISPOSINF && !MissingValue.isMissing(this.tailCorrToPosInfC)) {
                this.averageSecants[n - 1] = this.tailCorrToPosInfC;
            }
            double h = this.ST.get(ipos + 1) - this.ST.get(ipos);
            double t = (x - this.ST.get(ipos)) / h;
            double t2 = t * t;
            double t3 = t2 * t;
            double h00 = 2.0 * t3 - 3.0 * t2 + 1.0;
            double h10 = t3 - 2.0 * t2 + t;
            double h01 = -2.0 * t3 + 3.0 * t2;
            double h11 = t3 - t2;
            result = this.IT.get(ipos) * h00 + h * this.averageSecants[ipos] * h10 + this.IT.get(ipos + 1) * h01 + h * this.averageSecants[ipos + 1] * h11;
        }
        return result;
    }

    static enum MonoCubicConditions {
        UNKNOWN,
        AISPOSINF,
        BISPOSINF,
        CISPOSINF,
        ANOTPOSINF,
        BNOTPOSINF;

    }
}

