/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.statistics;

import com.spss.math.MissingValue;
import com.spss.math.statistics.MathFun;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class OutlierDetectionAlgorithms {
    private static final double TOLERANCE = 1.0E-14;
    private static final int DIXONQ_MIN_NUM = 3;
    private static final int DIXONQ_MAX_NUM = 30;
    private static final double[][] DIXONQ_TABLE = new double[][]{{0.941, 0.765, 0.642, 0.56, 0.507, 0.468, 0.437, 0.412, 0.392, 0.377, 0.362, 0.349, 0.337, 0.331, 0.321, 0.314, 0.305, 0.301, 0.295, 0.288, 0.286, 0.281, 0.276, 0.273, 0.268, 0.265, 0.262, 0.259}, {0.97, 0.829, 0.71, 0.625, 0.568, 0.526, 0.493, 0.466, 0.442, 0.425, 0.409, 0.396, 0.384, 0.376, 0.365, 0.356, 0.351, 0.343, 0.338, 0.333, 0.327, 0.321, 0.316, 0.313, 0.307, 0.304, 0.3, 0.297}, {0.994, 0.926, 0.821, 0.74, 0.68, 0.634, 0.598, 0.568, 0.543, 0.521, 0.501, 0.487, 0.471, 0.462, 0.454, 0.441, 0.436, 0.426, 0.421, 0.411, 0.406, 0.4, 0.395, 0.388, 0.383, 0.38, 0.377, 0.369}};

    private OutlierDetectionAlgorithms() {
    }

    public static double[] modifiedZScore(List<Double> inputs, List<Double> weights) {
        boolean result;
        double[] outStrengths = null;
        int n = inputs.size();
        boolean bl = result = n == weights.size();
        if (result) {
            int i;
            double median = MathFun.calcMedian(inputs, weights);
            ArrayList<Double> devs = new ArrayList<Double>();
            ArrayList<Double> absDevs = new ArrayList<Double>();
            for (int i2 = 0; i2 < n; ++i2) {
                double temp = inputs.get(i2) - median;
                devs.add(temp);
                absDevs.add(Math.abs(temp));
            }
            double MAD = MathFun.calcMedian(absDevs, weights);
            double meanAD = 0.0;
            double totalWeight = 0.0;
            for (i = 0; i < n; ++i) {
                meanAD += weights.get(i) * (Double)absDevs.get(i);
                totalWeight += weights.get(i).doubleValue();
            }
            meanAD /= totalWeight;
            outStrengths = new double[n];
            for (i = 0; i < n; ++i) {
                outStrengths[i] = MAD < 1.0E-14 ? (Double)devs.get(i) / (1.253314 * meanAD) : (Double)devs.get(i) / (1.4826 * MAD);
            }
        }
        return outStrengths;
    }

    public static double[] studentizedResiduals(List<Double> preVals, List<Double> tagVals, List<Double> weights) {
        double[] stuRes = null;
        int n = preVals.size();
        if (n == tagVals.size() && n == weights.size()) {
            int i;
            double sumWeights = 0.0;
            double sumWmultiplyX = 0.0;
            double sumWmultiplyY = 0.0;
            for (i = 0; i < n; ++i) {
                sumWeights += weights.get(i).doubleValue();
                sumWmultiplyX += weights.get(i) * preVals.get(i);
                sumWmultiplyY += weights.get(i) * tagVals.get(i);
            }
            if (sumWeights > 1.0) {
                double divsumWeights = 1.0 / sumWeights;
                double xMean = divsumWeights * sumWmultiplyX;
                double yMean = divsumWeights * sumWmultiplyY;
                double Sxx = 0.0;
                double Sxy = 0.0;
                double temp = 0.0;
                for (i = 0; i < n; ++i) {
                    temp = preVals.get(i) - xMean;
                    Sxx += weights.get(i) * temp * temp;
                    Sxy += weights.get(i) * (temp * (tagVals.get(i) - yMean));
                }
                temp = 1.0 / (sumWeights - 1.0);
                double beta1 = (Sxy *= temp) / (Sxx *= temp);
                double beta0 = yMean - beta1 * xMean;
                double SSe = 0.0;
                double[] eks = new double[n];
                for (i = 0; i < n; ++i) {
                    double yk = beta1 * preVals.get(i) + beta0;
                    eks[i] = tagVals.get(i) - yk;
                    SSe += weights.get(i) * eks[i] * eks[i];
                }
                double dfe = sumWeights - 2.0;
                double hkbottom = Sxx * (sumWeights - 1.0);
                double divdfe = SSe / dfe;
                if (dfe > 1.0E-14 && divdfe > 1.0E-14) {
                    stuRes = new double[n];
                    for (i = 0; i < n; ++i) {
                        temp = preVals.get(i) - xMean;
                        double hk = temp * temp / hkbottom + divsumWeights;
                        stuRes[i] = hk < 1.0 ? eks[i] / Math.sqrt(divdfe * (1.0 - hk)) : MissingValue.getMissing();
                    }
                }
            }
        }
        return stuRes;
    }

    public static int[] dixonQ(List<Double> inputs, double conf) {
        boolean result;
        int[] outliers = null;
        int n = inputs.size();
        boolean bl = result = n >= 3 && n <= 30;
        if (result) {
            int i = 0;
            class DoubleIntPair {
                public double first;
                public int second;

                public DoubleIntPair(double a, int b) {
                    this.first = a;
                    this.second = b;
                }
            }
            DoubleIntPair[] dataset = new DoubleIntPair[n];
            for (i = 0; i < n; ++i) {
                dataset[i] = new DoubleIntPair(inputs.get(i), i);
            }
            Arrays.sort(dataset, new Comparator<DoubleIntPair>(){

                @Override
                public int compare(DoubleIntPair obj1, DoubleIntPair obj2) {
                    return Double.compare(obj1.first, obj2.first);
                }
            });
            if (dataset[0].first != dataset[n - 1].first) {
                double qTest = MissingValue.getMissing();
                if (Math.abs(conf - 0.9) < 1.0E-14) {
                    qTest = DIXONQ_TABLE[0][n];
                } else if (Math.abs(conf - 0.95) < 1.0E-14) {
                    qTest = DIXONQ_TABLE[1][n - 3];
                } else if (Math.abs(conf - 0.99) < 1.0E-14) {
                    qTest = DIXONQ_TABLE[2][n - 3];
                }
                if (!MissingValue.isMissing(qTest)) {
                    double uppQ;
                    double outlier1 = MissingValue.getMissing();
                    double outlier2 = MissingValue.getMissing();
                    double lowQ = (dataset[1].first - dataset[0].first) / (dataset[n - 1].first - dataset[0].first);
                    if (lowQ > qTest) {
                        outlier1 = dataset[0].second;
                    }
                    if ((uppQ = (dataset[n - 1].first - dataset[n - 2].first) / (dataset[n - 1].first - dataset[0].first)) > qTest) {
                        outlier2 = dataset[n - 1].second;
                    }
                    if (!MissingValue.isMissing(outlier1) && !MissingValue.isMissing(outlier2)) {
                        outliers = new int[]{(int)outlier1, (int)outlier2};
                    } else if (!MissingValue.isMissing(outlier1)) {
                        outliers = new int[]{(int)outlier1};
                    } else if (!MissingValue.isMissing(outlier2)) {
                        outliers = new int[]{(int)outlier2};
                    }
                }
            }
        }
        return outliers;
    }
}

