/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.statistics.probability;

import com.spss.math.statistics.probability.CdfFunction;
import com.spss.math.statistics.probability.CumulateStdNormalFunc;
import com.spss.math.statistics.probability.NaturalLogFunc;

public class GammaFunc
extends CdfFunction {
    private final int UNDETERMINED_METHOD = 0;
    private final int PEARSON_EXPANSION = 1;
    private final int CONTINUED_EXPANSION = 2;
    private final int NORMAL_APPROXIMATION = 3;
    private final int EXPLICIT_FORMULA = 4;
    private final long MAX_LONG = Long.MAX_VALUE;
    private final double TOLERANCE = 1.0E-14;

    public double apply(double X, double df, boolean isQuoteCdf) {
        double pn2;
        double iter3;
        double iter1;
        double pn1;
        double expArg = 0.0;
        double result = 0.0;
        int methodType = 0;
        if (X <= 0.0) {
            methodType = 4;
            if (!isQuoteCdf) {
                result = 1.0;
            }
        } else if (df == 1.0) {
            methodType = 4;
            expArg = -X;
            if (expArg >= -708.0) {
                result = Math.exp(expArg);
            }
            if (isQuoteCdf) {
                result = 1.0 - result;
            }
        } else if (X <= 1.0 || X <= df) {
            methodType = 1;
            double termNumber = Math.log10(X / (df + 1.0));
            if (termNumber != 0.0) {
                termNumber = Math.log10(1.0E-14) / termNumber;
                if (termNumber > 0.0) {
                    termNumber = 10.0 + 2.0 * Math.sqrt(termNumber);
                    pn1 = 9.223372036854776E18;
                    if (Math.pow(termNumber, 2.0) >= pn1) {
                        methodType = 3;
                    }
                }
            } else {
                methodType = 3;
            }
            if (methodType == 1 && this.isMissingValue(expArg = new NaturalLogFunc().apply(df + 1.0))) {
                methodType = 3;
            }
        } else {
            methodType = 2;
            expArg = new NaturalLogFunc().apply(df);
            if (this.isMissingValue(expArg) || 4.0 * Math.log(X) > 709.0) {
                methodType = 3;
            }
        }
        if (methodType == 1 || methodType == 2) {
            expArg = df * Math.log(X) - (expArg + X);
        }
        if (methodType == 1) {
            iter1 = df;
            result = 1.0;
            iter3 = 1.0;
            do {
                iter3 = iter3 * X / (iter1 += 1.0);
                result += iter3;
            } while (!(iter3 < 1.0E-14));
            if ((expArg += Math.log(result)) > 0.0) {
                methodType = 3;
            } else if (expArg >= -708.0) {
                result = Math.exp(expArg);
                if (!isQuoteCdf) {
                    result = 1.0 - result;
                }
            } else {
                result = isQuoteCdf ? 0.0 : 1.0;
            }
        }
        if (methodType == 2) {
            iter1 = 1.0 - df;
            double iter2 = iter1 + X + 1.0;
            iter3 = 0.0;
            pn1 = 1.0;
            pn2 = X;
            double pn3 = X + 1.0;
            double pn4 = X * iter2;
            result = pn3 / pn4;
            while (true) {
                double temp = (iter1 += 1.0) * (iter3 += 1.0);
                double pn5 = (iter2 += 2.0) * pn3 - temp * pn1;
                double pn6 = iter2 * pn4 - temp * pn2;
                if (Math.abs(pn6) > 0.0) {
                    double resultIterVal = pn5 / pn6;
                    double toleranceMin = 1.0E-14 * resultIterVal;
                    if (1.0E-14 < toleranceMin) {
                        toleranceMin = 1.0E-14;
                    }
                    if (Math.abs(result - resultIterVal) <= toleranceMin) break;
                    result = resultIterVal;
                }
                pn1 = pn3;
                pn2 = pn4;
                pn3 = pn5;
                pn4 = pn6;
                if (!(Math.abs(pn5) >= MAX_SQUARE_ROOT)) continue;
                pn1 /= MAX_SQUARE_ROOT;
                pn2 /= MAX_SQUARE_ROOT;
                pn3 /= MAX_SQUARE_ROOT;
                pn4 /= MAX_SQUARE_ROOT;
            }
            expArg += Math.log(result);
            if (expArg > 0.0) {
                methodType = 3;
            } else if (expArg >= -708.0) {
                result = Math.exp(expArg);
                if (isQuoteCdf) {
                    result = 1.0 - result;
                }
            } else {
                result = isQuoteCdf ? 1.0 : 0.0;
            }
        }
        if (methodType == 3) {
            if (isQuoteCdf || df < 0.5) {
                pn1 = 3.0 * Math.sqrt(df);
                if (X != df) {
                    expArg = Math.log(X / df) / 3.0;
                    pn2 = expArg >= -708.0 ? Math.exp(expArg) : 0.0;
                    pn1 *= pn2 + 1.0 / (9.0 * df) - 1.0;
                } else {
                    pn1 = 1.0 / pn1;
                }
                if (!isQuoteCdf) {
                    pn1 = -pn1;
                }
                result = new CumulateStdNormalFunc().apply(pn1);
            } else {
                pn1 = (df - 0.5) / X;
                if (pn1 == 0.0) {
                    pn2 = Math.sqrt(2.0 / X);
                } else if (pn1 == 1.0) {
                    pn2 = Math.sqrt(1.0 / X);
                } else {
                    pn2 = 2.0 * (1.0 + pn1 * Math.log(pn1) - pn1);
                    pn2 = Math.sqrt(pn2 / X) / Math.abs(1.0 - pn1);
                }
                pn1 = (df + 0.022 / df - X - 0.3333333333333333) * pn2;
                result = new CumulateStdNormalFunc().apply(pn1);
            }
        }
        return result;
    }
}

