/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.avro;

import com.ibm.ba.flint.thrift.types.SchemaField;
import com.ibm.ba.flint.util.DecimalUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;

public class AvroHelper {
    private static final String DECIMAL4_RECORD = "decimal4";
    private static final Schema DECIMAL4_SCHEMA = (Schema)SchemaBuilder.builder().fixed("decimal4").size(4);
    private static final String DECIMAL8_RECORD = "decimal8";
    private static final Schema DECIMAL8_SCHEMA = (Schema)SchemaBuilder.builder().fixed("decimal8").size(8);
    private static final String DECIMAL16_RECORD = "decimal16";
    private static final Schema DECIMAL16_SCHEMA = (Schema)SchemaBuilder.builder().fixed("decimal16").size(16);
    private static final String DATE_RECORD = "date";
    private static final String DATE_YEAR_FIELD = "year";
    private static final String DATE_MONTH_FIELD = "month";
    private static final String DATE_DAY_FIELD = "day";
    private static final Schema DATE_SCHEMA = (Schema)SchemaBuilder.builder().record("date").fields().requiredInt("year").requiredInt("month").requiredInt("day").endRecord();
    private static final String TIMESTAMP_RECORD = "timestamp";
    private static final String TIMESTAMP_SECONDS_FIELD = "seconds";
    private static final String TIMESTAMP_NANOS_FIELD = "nanos";
    private static final Schema TIMESTAMP_SCHEMA = (Schema)SchemaBuilder.builder().record("timestamp").fields().requiredLong("seconds").requiredInt("nanos").endRecord();
    private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);

    private AvroHelper() {
    }

    public static Schema toAvroSchema(com.ibm.ba.flint.thrift.types.Schema flintSchema) {
        SchemaBuilder.FieldAssembler assembler = SchemaBuilder.record((String)"row").fields();
        int fieldIndex = 0;
        for (SchemaField field : flintSchema.getFields()) {
            AvroHelper.assembleField(field, fieldIndex++, (SchemaBuilder.FieldAssembler<Schema>)assembler);
        }
        return (Schema)assembler.endRecord();
    }

    public static Schema getDecimalType(int precision, int scale) {
        if (precision < 1 || precision > 38) {
            throw new IllegalArgumentException("precision must be >= 1 and <= 38");
        }
        if (scale < 0 || scale > precision) {
            throw new IllegalArgumentException("scale must be >= 0 and <= precision");
        }
        int byteLength = DecimalUtil.decimalPrecisionToByteLength(precision);
        switch (byteLength) {
            case 4: {
                return DECIMAL4_SCHEMA;
            }
            case 8: {
                return DECIMAL8_SCHEMA;
            }
        }
        return DECIMAL16_SCHEMA;
    }

    public static GenericFixed createDecimalFixed(int precision) {
        return new GenericData.Fixed(AvroHelper.getDecimalType(precision, 0));
    }

    public static GenericRecord createDateRecord() {
        return new GenericData.Record(DATE_SCHEMA);
    }

    public static GenericRecord createTimestampRecord() {
        return new GenericData.Record(TIMESTAMP_SCHEMA);
    }

    public static GenericFixed encodeDecimal(BigDecimal decimal, int precision, int scale) {
        BigDecimal adjusted = DecimalUtil.adjustDecimalForPrecisionAndScale(decimal, precision, scale);
        GenericFixed fixed = AvroHelper.createDecimalFixed(precision);
        byte[] fixedBytes = fixed.bytes();
        DecimalUtil.decimalToUnscaledBytes(adjusted, precision, fixedBytes);
        return fixed;
    }

    public static BigDecimal decodeDecimal(GenericFixed fixed, int precision, int scale) {
        if (fixed.bytes().length != DecimalUtil.decimalPrecisionToByteLength(precision)) {
            throw new IllegalArgumentException("byte length of field is not consistent with precision of decimal type");
        }
        BigInteger unscaledVal = new BigInteger(fixed.bytes());
        return new BigDecimal(unscaledVal, scale);
    }

    public static GenericRecord encodeDate(Date value) {
        GenericRecord record = AvroHelper.createDateRecord();
        LocalDate localDate = value.toLocalDate();
        record.put(DATE_YEAR_FIELD, (Object)localDate.getYear());
        record.put(DATE_MONTH_FIELD, (Object)localDate.getMonthValue());
        record.put(DATE_DAY_FIELD, (Object)localDate.getDayOfMonth());
        return record;
    }

    public static Date decodeDate(GenericRecord record) {
        int year = (Integer)record.get(DATE_YEAR_FIELD);
        int month = (Integer)record.get(DATE_MONTH_FIELD);
        int day = (Integer)record.get(DATE_DAY_FIELD);
        return Date.valueOf(LocalDate.of(year, month, day));
    }

    public static GenericRecord encodeTimestamp(Timestamp value) {
        GenericRecord record = AvroHelper.createTimestampRecord();
        Instant instant = value.toInstant();
        record.put(TIMESTAMP_SECONDS_FIELD, (Object)instant.getEpochSecond());
        record.put(TIMESTAMP_NANOS_FIELD, (Object)instant.getNano());
        return record;
    }

    public static Timestamp decodeTimestamp(GenericRecord record) {
        long seconds = (Long)record.get(TIMESTAMP_SECONDS_FIELD);
        int nanos = (Integer)record.get(TIMESTAMP_NANOS_FIELD);
        return Timestamp.from(Instant.ofEpochSecond(seconds, nanos));
    }

    private static void assembleField(SchemaField field, int fieldIndex, SchemaBuilder.FieldAssembler<Schema> assembler) {
        Schema type;
        SchemaBuilder.FieldBuilder fieldBuilder = assembler.name("C" + fieldIndex);
        switch (field.getType()) {
            case BINARY: {
                type = Schema.create((Schema.Type)Schema.Type.BYTES);
                break;
            }
            case STRING: {
                type = Schema.create((Schema.Type)Schema.Type.STRING);
                break;
            }
            case BOOLEAN: {
                type = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                type = Schema.create((Schema.Type)Schema.Type.INT);
                break;
            }
            case LONG: {
                type = Schema.create((Schema.Type)Schema.Type.LONG);
                break;
            }
            case FLOAT: {
                type = Schema.create((Schema.Type)Schema.Type.FLOAT);
                break;
            }
            case DOUBLE: {
                type = Schema.create((Schema.Type)Schema.Type.DOUBLE);
                break;
            }
            case DATE: {
                type = DATE_SCHEMA;
                break;
            }
            case TIMESTAMP: {
                type = TIMESTAMP_SCHEMA;
                break;
            }
            case DECIMAL: {
                type = AvroHelper.getDecimalType(field.getPrecision(), field.getScale());
                break;
            }
            default: {
                type = NULL_SCHEMA;
            }
        }
        if (field.isNullable() && type != NULL_SCHEMA) {
            type = Schema.createUnion(Arrays.asList(type, NULL_SCHEMA));
        }
        fieldBuilder.type(type).noDefault();
    }
}

