/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.avro;

import com.ibm.ba.flint.avro.AvroHelper;
import com.ibm.ba.flint.avro.AvroReadableRow;
import com.ibm.ba.flint.util.AbstractRowReader;
import com.ibm.ba.flint.util.ReadableRow;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.ByteBufferInputStream;

public class AvroRowReader
extends AbstractRowReader {
    private final DataFileStream<GenericRecord> reader;
    private final AvroReadableRow readableRow;
    private boolean closed = false;

    public AvroRowReader(com.ibm.ba.flint.thrift.types.Schema schema, InputStream in) throws IOException {
        super(schema);
        Schema avroSchema = AvroHelper.toAvroSchema(schema);
        this.reader = new DataFileStream(in, GenericData.get().createDatumReader(avroSchema));
        this.readableRow = new AvroReadableRow(this.flintSchema, (GenericRecord)new GenericData.Record(avroSchema));
    }

    public AvroRowReader(com.ibm.ba.flint.thrift.types.Schema schema, List<ByteBuffer> buffers) throws IOException {
        this(schema, (InputStream)new ByteBufferInputStream(buffers));
    }

    @Override
    public boolean hasMore() throws IOException {
        this.expectNotClosed();
        return this.reader.hasNext();
    }

    @Override
    public ReadableRow readRow() throws IOException {
        this.expectNotClosed();
        this.reader.next((Object)this.readableRow.getGenericRecord());
        return this.readableRow;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.reader.close();
        }
    }

    private void expectNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
    }
}

