/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.crypto;

import com.ibm.ba.flint.crypto.ICryptoProvider;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class BlockCryptoInputStream
extends InputStream {
    private final InputStream in;
    private final ICryptoProvider cryptoProvider;
    private final byte[] lenBuf = new byte[4];
    private byte[] encryptedBlock = new byte[0];
    private ByteBuffer decryptedBlock = ByteBuffer.allocate(0);
    private boolean closed = false;

    public BlockCryptoInputStream(InputStream in, ICryptoProvider cryptoProvider) {
        if (null == in) {
            throw new IllegalArgumentException("in was null");
        }
        if (null == cryptoProvider) {
            throw new IllegalArgumentException("cryptoProvider was null");
        }
        this.in = in;
        this.cryptoProvider = cryptoProvider;
    }

    private static int unpackInt(byte[] buf) {
        return (buf[0] << 24) + ((buf[1] & 0xFF) << 16) + ((buf[2] & 0xFF) << 8) + (buf[3] & 0xFF);
    }

    @Override
    public int read() throws IOException {
        this.assertNotClosed();
        if (!this.decryptedBlock.hasRemaining() && !this.readNextBlock()) {
            return -1;
        }
        return this.decryptedBlock.get() & 0xFF;
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        if (null == buf) {
            throw new IllegalArgumentException("buf was null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset < 0");
        }
        if (offset + length > buf.length) {
            throw new IndexOutOfBoundsException("(offset + length) > buf.length");
        }
        this.assertNotClosed();
        if (!this.decryptedBlock.hasRemaining() && !this.readNextBlock()) {
            return -1;
        }
        int numBytesRead = Math.min(length, this.decryptedBlock.remaining());
        this.decryptedBlock.get(buf, offset, numBytesRead);
        return numBytesRead;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.in.close();
    }

    private boolean readNextBlock() throws IOException {
        try {
            this.readFully(this.lenBuf);
        }
        catch (EOFException ex) {
            return false;
        }
        int encryptedBytesLen = BlockCryptoInputStream.unpackInt(this.lenBuf);
        if (encryptedBytesLen <= 0) {
            throw new IOException("Invalid encrypted block length: " + encryptedBytesLen + "; stream corrupted?");
        }
        if (this.encryptedBlock.length != encryptedBytesLen) {
            this.encryptedBlock = new byte[encryptedBytesLen];
        }
        this.readFully(this.encryptedBlock, 0, encryptedBytesLen);
        this.decryptedBlock = ByteBuffer.wrap(this.cryptoProvider.decryptBytes(this.encryptedBlock));
        return true;
    }

    private void readFully(byte[] buf) throws IOException {
        this.readFully(buf, 0, buf.length);
    }

    private void readFully(byte[] buf, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.in.read(buf, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    private void assertNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }
}

