/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.crypto;

import com.ibm.ba.flint.crypto.ICryptoProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class BlockCryptoOutputStream
extends OutputStream {
    private static final int DEFAULT_BLOCK_SIZE = 32768;
    private final OutputStream out;
    private final ICryptoProvider cryptoProvider;
    private final ByteBuffer block;
    private final byte[] lenBuf = new byte[4];
    private boolean closed = false;

    public BlockCryptoOutputStream(OutputStream out, ICryptoProvider cryptoProvider) {
        this(out, cryptoProvider, 32768);
    }

    public BlockCryptoOutputStream(OutputStream out, ICryptoProvider cryptoProvider, int blockSize) {
        if (null == out) {
            throw new IllegalArgumentException("out was null");
        }
        if (null == cryptoProvider) {
            throw new IllegalArgumentException("cryptoProvider was null");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize < 1");
        }
        this.out = out;
        this.cryptoProvider = cryptoProvider;
        this.block = ByteBuffer.allocate(blockSize);
    }

    private static void packInt(byte[] buf, int value) {
        buf[0] = (byte)(value >>> 24);
        buf[1] = (byte)(value >>> 16);
        buf[2] = (byte)(value >>> 8);
        buf[3] = (byte)value;
    }

    @Override
    public void write(int b) throws IOException {
        this.assertNotClosed();
        if (!this.block.hasRemaining()) {
            this.flushBlock(false);
        }
        this.block.put((byte)(b & 0xFF));
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        if (null == buf) {
            throw new IllegalArgumentException("buf was null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset < 0");
        }
        if (offset + length > buf.length) {
            throw new IndexOutOfBoundsException("(offset + length) > buf.length");
        }
        this.assertNotClosed();
        int numWritten = 0;
        while (length - numWritten > 0) {
            if (!this.block.hasRemaining()) {
                this.flushBlock(false);
            }
            int numToWrite = Math.min(length - numWritten, this.block.remaining());
            this.block.put(buf, offset + numWritten, numToWrite);
            numWritten += numToWrite;
        }
    }

    @Override
    public void flush() throws IOException {
        this.assertNotClosed();
        if (!this.block.hasRemaining()) {
            this.flushBlock(false);
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flushBlock(true);
        this.out.close();
    }

    private void flushBlock(boolean lastBlock) throws IOException {
        if (!lastBlock && this.block.hasRemaining()) {
            throw new IllegalStateException("Expecting to flush a full block, but " + this.block.remaining() + " bytes are remaining.");
        }
        if (this.block.position() == 0) {
            return;
        }
        byte[] encryptedBlock = this.encryptBlock();
        BlockCryptoOutputStream.packInt(this.lenBuf, encryptedBlock.length);
        this.out.write(this.lenBuf);
        this.out.write(encryptedBlock);
        this.block.clear();
    }

    private byte[] encryptBlock() throws IOException {
        byte[] bytesToEncrypt;
        this.block.flip();
        if (this.block.remaining() < this.block.capacity()) {
            bytesToEncrypt = new byte[this.block.remaining()];
            this.block.get(bytesToEncrypt);
        } else {
            bytesToEncrypt = this.block.array();
        }
        return this.cryptoProvider.encryptBytes(bytesToEncrypt);
    }

    private void assertNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }
}

