/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.hadoop.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FSUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FSUtils.class);

    private FSUtils() {
    }

    public static long saveToFile(FileSystem fs, Path path, List<ByteBuffer> buffers, boolean overwrite) throws IOException {
        long bytesWritten = 0L;
        try (FSDataOutputStream out = fs.create(path, overwrite);){
            for (ByteBuffer buf : buffers) {
                bytesWritten += FSUtils.copyToStream(buf, (OutputStream)out);
            }
        }
        LOGGER.debug("Saved {} bytes to file: {}", (Object)bytesWritten, (Object)path);
        return bytesWritten;
    }

    public static boolean delete(FileSystem fs, Path path, boolean recursive) throws IOException {
        LOGGER.debug("Deleting path (recursive:{}): {}", (Object)recursive, (Object)path);
        if (fs.exists(path)) {
            return fs.delete(path, recursive);
        }
        LOGGER.warn("Path does not exist: {}", (Object)path);
        return false;
    }

    public static boolean deleteQuietly(FileSystem fs, Path path, boolean recursive) {
        try {
            return FSUtils.delete(fs, path, recursive);
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to delete path (recursive:{}): {}", new Object[]{recursive, path, ex});
            return false;
        }
    }

    public static boolean cleanDirectory(FileSystem fs, Path dir) throws IOException {
        LOGGER.debug("Cleaning directory: {}", (Object)dir);
        for (FileStatus stat : fs.listStatus(dir)) {
            if (FSUtils.delete(fs, stat.getPath(), true)) continue;
            return false;
        }
        return true;
    }

    public static boolean cleanDirectoryQuietly(FileSystem fs, Path dir) {
        LOGGER.debug("Cleaning directory: {}", (Object)dir);
        boolean result = true;
        try {
            if (fs.exists(dir)) {
                for (FileStatus stat : fs.listStatus(dir)) {
                    result &= FSUtils.deleteQuietly(fs, stat.getPath(), true);
                }
            } else {
                result = false;
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to clean directory: {}", (Object)dir, (Object)ex);
            result = false;
        }
        return result;
    }

    private static long copyToStream(ByteBuffer buf, OutputStream out) throws IOException {
        byte[] copyBuf = null;
        long bytesWritten = 0L;
        while (buf.hasRemaining()) {
            int len;
            if (buf.hasArray()) {
                len = buf.remaining();
                out.write(buf.array(), buf.arrayOffset() + buf.position(), len);
                buf.position(buf.position() + len);
                bytesWritten += (long)len;
                continue;
            }
            if (null == copyBuf) {
                copyBuf = new byte[8192];
            }
            len = Math.min(copyBuf.length, buf.remaining());
            buf.get(copyBuf, 0, len);
            out.write(copyBuf, 0, len);
            bytesWritten += (long)len;
        }
        return bytesWritten;
    }
}

