/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.io.buf;

import com.ibm.ba.flint.io.buf.AbstractByteBufferPool;
import com.ibm.ba.flint.io.buf.ByteBufferAllocator;
import com.ibm.ba.flint.io.buf.ByteBufferPool;
import com.ibm.ba.flint.util.Bits;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Objects;

public class FixedSizeByteBufferPool
extends AbstractByteBufferPool {
    private final ByteBuffer[] freeList;
    private final BitSet filledSlots;
    private int overwritePos = 0;

    public FixedSizeByteBufferPool(int maxBuffers) {
        if (maxBuffers < 1) {
            throw new IllegalArgumentException("maxBuffers must be > 0");
        }
        this.freeList = new ByteBuffer[Bits.nextPow2(maxBuffers)];
        this.filledSlots = new BitSet(this.freeList.length);
    }

    public FixedSizeByteBufferPool(int maxBuffers, ByteBufferAllocator allocator, ByteBufferPool.SelectionPolicy selectionPolicy, int minAllocateSize) {
        super(allocator, selectionPolicy, minAllocateSize);
        if (maxBuffers < 1) {
            throw new IllegalArgumentException("maxBuffers must be > 0");
        }
        this.freeList = new ByteBuffer[Bits.nextPow2(maxBuffers)];
        this.filledSlots = new BitSet(this.freeList.length);
    }

    @Override
    protected ByteBuffer findBufferFirstFit(int capacity) {
        int i = this.filledSlots.nextSetBit(0);
        while (i != -1) {
            ByteBuffer buf = this.freeList[i];
            if (buf.capacity() >= capacity) {
                this.freeList[i] = null;
                this.filledSlots.clear(i);
                return buf;
            }
            i = this.filledSlots.nextSetBit(i + 1);
        }
        return null;
    }

    @Override
    protected ByteBuffer findBufferBestFit(int capacity) {
        Buffer best = null;
        int bestIndex = -1;
        int i = this.filledSlots.nextSetBit(0);
        while (i != -1) {
            ByteBuffer buf = this.freeList[i];
            if (buf.capacity() >= capacity && (null == best || buf.capacity() < best.capacity())) {
                bestIndex = i;
                best = this.freeList[i];
            }
            i = this.filledSlots.nextSetBit(i + 1);
        }
        if (bestIndex != -1) {
            this.freeList[bestIndex] = null;
            this.filledSlots.clear(bestIndex);
            return best;
        }
        return null;
    }

    @Override
    public void release(ByteBuffer buf) {
        Objects.requireNonNull(buf, "buf must not be null");
        int i = this.filledSlots.nextClearBit(0);
        if (i < this.freeList.length) {
            this.freeList[i] = buf;
            this.filledSlots.set(i);
        } else {
            this.freeList[this.overwritePos] = buf;
            this.overwritePos = Bits.modPow2(this.overwritePos + 1, this.freeList.length);
        }
    }
}

