/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.io.buf;

import com.ibm.ba.flint.io.buf.AbstractByteBufferPool;
import com.ibm.ba.flint.io.buf.ByteBufferAllocator;
import com.ibm.ba.flint.io.buf.ByteBufferPool;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ListByteBufferPool
extends AbstractByteBufferPool {
    private final List<ByteBuffer> freeList;

    public ListByteBufferPool(List<ByteBuffer> freeList) {
        Objects.requireNonNull(freeList, "freeList must not be null");
        this.freeList = freeList;
    }

    public ListByteBufferPool(List<ByteBuffer> freeList, ByteBufferAllocator allocator, ByteBufferPool.SelectionPolicy selectionPolicy, int minAllocateSize) {
        super(allocator, selectionPolicy, minAllocateSize);
        Objects.requireNonNull(freeList, "freeList must not be null");
        this.freeList = freeList;
    }

    @Override
    protected ByteBuffer findBufferFirstFit(int capacity) {
        Iterator<ByteBuffer> it = this.freeList.iterator();
        while (it.hasNext()) {
            ByteBuffer buf = it.next();
            if (buf.capacity() < capacity) continue;
            it.remove();
            return buf;
        }
        return null;
    }

    @Override
    protected ByteBuffer findBufferBestFit(int capacity) {
        Iterator<ByteBuffer> it = this.freeList.iterator();
        ByteBuffer best = null;
        while (it.hasNext()) {
            ByteBuffer buf = it.next();
            if (buf.capacity() < capacity || null != best && buf.capacity() >= best.capacity()) continue;
            best = buf;
        }
        if (null != best) {
            this.freeList.remove(best);
            return best;
        }
        return null;
    }

    @Override
    public void release(ByteBuffer buf) {
        Objects.requireNonNull(buf, "buf must not be null");
        this.freeList.add(buf);
    }
}

