/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.thrift.util;

import com.ibm.ba.flint.thrift.types.AnyValue;
import com.ibm.ba.flint.thrift.types.DateValue;
import com.ibm.ba.flint.thrift.types.DecimalValue;
import com.ibm.ba.flint.thrift.types.Row;
import com.ibm.ba.flint.thrift.types.TimestampValue;
import com.ibm.ba.flint.util.DecimalUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;

public class ThriftHelper {
    protected ThriftHelper() {
    }

    public static Date toSqlDate(DateValue dateValue) {
        if (null == dateValue) {
            return null;
        }
        LocalDate localDate = LocalDate.of((int)dateValue.getYear(), dateValue.getMonth(), (int)dateValue.getDay());
        return Date.valueOf(localDate);
    }

    public static DateValue toDateValue(Date date) {
        if (null == date) {
            return null;
        }
        LocalDate localDate = Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        return new DateValue((short)localDate.getYear(), (short)localDate.getMonthValue(), (short)localDate.getDayOfMonth());
    }

    public static Timestamp toSqlTimestamp(TimestampValue timestampValue) {
        if (null == timestampValue) {
            return null;
        }
        return Timestamp.from(Instant.ofEpochSecond(timestampValue.seconds, timestampValue.nanos));
    }

    public static TimestampValue toTimestampValue(Timestamp ts) {
        if (null == ts) {
            return null;
        }
        Instant instant = ts.toInstant();
        return new TimestampValue(instant.getEpochSecond(), instant.getNano());
    }

    public static DecimalValue toDecimalValue(BigDecimal decimal) {
        if (null == decimal) {
            return null;
        }
        return new DecimalValue(decimal.scale(), ByteBuffer.wrap(decimal.unscaledValue().toByteArray()));
    }

    public static DecimalValue toDecimalValue(BigDecimal decimal, int precision, int scale) {
        if (null == decimal) {
            return null;
        }
        BigDecimal adjusted = DecimalUtil.adjustDecimalForPrecisionAndScale(decimal, precision, scale);
        return ThriftHelper.toDecimalValue(adjusted);
    }

    public static BigDecimal toBigDecimal(DecimalValue decimal) {
        if (null == decimal) {
            return null;
        }
        BigInteger unscaled = new BigInteger(decimal.getUnscaledValue());
        return new BigDecimal(unscaled, decimal.getScale());
    }

    public static AnyValue toAnyValue(Object o) {
        AnyValue any = null;
        if (null == o) {
            any = AnyValue.nullValue((boolean)true);
        } else if (o instanceof Number) {
            if (o instanceof Byte) {
                any = AnyValue.byteValue((byte)((Byte)o));
            } else if (o instanceof Short) {
                any = AnyValue.shortValue((short)((Short)o));
            } else if (o instanceof Integer) {
                any = AnyValue.intValue((int)((Integer)o));
            } else if (o instanceof Long) {
                any = AnyValue.longValue((long)((Long)o));
            } else if (o instanceof Float) {
                any = AnyValue.floatValue((double)((Float)o).floatValue());
            } else if (o instanceof Double) {
                any = AnyValue.doubleValue((double)((Double)o));
            } else if (o instanceof BigDecimal) {
                any = AnyValue.decimalValue((DecimalValue)ThriftHelper.toDecimalValue((BigDecimal)o));
            }
        } else {
            any = o instanceof Date ? AnyValue.dateValue((DateValue)ThriftHelper.toDateValue((Date)o)) : (o instanceof Timestamp ? AnyValue.timestampValue((TimestampValue)ThriftHelper.toTimestampValue((Timestamp)o)) : (o instanceof Boolean ? AnyValue.booleanValue((boolean)((Boolean)o)) : (o instanceof byte[] ? AnyValue.binaryValue((byte[])((byte[])o)) : AnyValue.stringValue((String)o.toString()))));
        }
        return any;
    }

    public static Row makeRow(Object ... values) {
        ArrayList<AnyValue> anyValues = new ArrayList<AnyValue>(values.length);
        for (Object value : values) {
            anyValues.add(ThriftHelper.toAnyValue(value));
        }
        return new Row(anyValues);
    }
}

