/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.thrift.util;

import com.ibm.ba.flint.thrift.types.Row;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.util.ThriftWritableRow;
import com.ibm.ba.flint.util.ArrayRowAccessor;
import com.ibm.ba.flint.util.ReadableRow;
import com.ibm.ba.flint.util.RowUtils;
import com.ibm.ba.flint.util.RowWriter;
import java.io.IOException;
import java.util.List;

public class ThriftListRowWriter
implements RowWriter {
    private final Schema flintSchema;
    private final List<Row> outputList;
    private final ThriftWritableRow writableRow;
    private final RowUtils.RowTransfer rowCloner;
    private boolean closed = false;

    public ThriftListRowWriter(Schema flintSchema, List<Row> outputList) {
        this.flintSchema = flintSchema;
        this.outputList = outputList;
        this.writableRow = new ThriftWritableRow(flintSchema);
        this.rowCloner = RowUtils.createRowCloner(flintSchema);
    }

    @Override
    public void writeArray(Object[] source) throws IOException {
        this.writeRow(new ArrayRowAccessor(source));
    }

    @Override
    public void writeRow(ReadableRow source) throws IOException {
        if (source.size() != this.flintSchema.getFieldsSize()) {
            throw new IllegalArgumentException("source size does not match the number of fields in schema");
        }
        this.expectNotClosed();
        Row thriftRow = new Row();
        this.writableRow.setThriftRow(thriftRow);
        this.writableRow.resizeThriftRow();
        this.rowCloner.apply(source, this.writableRow);
        this.outputList.add(thriftRow);
    }

    @Override
    public void flush() throws IOException {
        this.expectNotClosed();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    private void expectNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Writer closed");
        }
    }
}

