/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.thrift.util;

import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.util.ThriftReadableRow;
import com.ibm.ba.flint.util.AbstractRowReader;
import com.ibm.ba.flint.util.ReadableRow;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ThriftStreamRowReader
extends AbstractRowReader {
    private final PushbackInputStream peekableInput;
    private final TTransport transport;
    private final TProtocol protocol;
    private final ThriftReadableRow readableRow;
    private boolean closed = false;

    public ThriftStreamRowReader(Schema schema, InputStream in) {
        super(schema);
        this.peekableInput = new PushbackInputStream(in, 1);
        this.transport = new TIOStreamTransport((InputStream)this.peekableInput);
        this.protocol = new TCompactProtocol(this.transport);
        this.readableRow = new ThriftReadableRow();
    }

    @Override
    public boolean hasMore() throws IOException {
        this.expectNotClosed();
        int nextByte = this.peekableInput.read();
        if (-1 == nextByte) {
            return false;
        }
        this.peekableInput.unread(nextByte);
        return true;
    }

    @Override
    public ReadableRow readRow() throws IOException {
        this.expectNotClosed();
        try {
            this.readableRow.getThriftRow().read(this.protocol);
        }
        catch (TException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new IOException("Failed to read row using Thrift protocol", ex);
        }
        return this.readableRow;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.transport.close();
        }
    }

    private void expectNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Writer closed");
        }
    }
}

