/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.thrift.util;

import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.util.ThriftWritableRow;
import com.ibm.ba.flint.util.ArrayRowAccessor;
import com.ibm.ba.flint.util.ReadableRow;
import com.ibm.ba.flint.util.RowUtils;
import com.ibm.ba.flint.util.RowWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ThriftStreamRowWriter
implements RowWriter {
    private final Schema flintSchema;
    private final TTransport transport;
    private final TProtocol protocol;
    private final ThriftWritableRow writableRow;
    private final RowUtils.RowTransfer rowCloner;
    private boolean closed = false;

    public ThriftStreamRowWriter(Schema schema, OutputStream out) {
        this.flintSchema = schema;
        this.transport = new TIOStreamTransport(out);
        this.protocol = new TCompactProtocol(this.transport);
        this.writableRow = new ThriftWritableRow(this.flintSchema);
        this.rowCloner = RowUtils.createRowCloner(this.flintSchema);
    }

    @Override
    public void writeArray(Object[] source) throws IOException {
        this.writeRow(new ArrayRowAccessor(source));
    }

    @Override
    public void writeRow(ReadableRow source) throws IOException {
        if (source.size() != this.flintSchema.getFieldsSize()) {
            throw new IllegalArgumentException("source size does not match the number of fields in schema");
        }
        this.expectNotClosed();
        this.rowCloner.apply(source, this.writableRow);
        try {
            this.writableRow.getThriftRow().write(this.protocol);
        }
        catch (TException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new IOException("Failed to write row using Thrift protocol", ex);
        }
    }

    @Override
    public void flush() throws IOException {
        this.expectNotClosed();
        try {
            this.transport.flush();
        }
        catch (TException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new IOException("Failed to flush Thrift transport", ex);
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.transport.close();
        }
    }

    private void expectNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
    }
}

