/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.util;

import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.util.ArrayRowAccessor;
import com.ibm.ba.flint.util.RowReader;
import com.ibm.ba.flint.util.RowUtils;
import com.ibm.ba.flint.util.WritableRow;
import java.io.IOException;

public abstract class AbstractRowReader
implements RowReader {
    protected final Schema flintSchema;
    private final RowUtils.RowTransfer rowCloner;

    protected AbstractRowReader(Schema flintSchema) {
        if (null == flintSchema) {
            throw new IllegalArgumentException("flintSchema was null");
        }
        this.flintSchema = flintSchema;
        this.rowCloner = RowUtils.createRowCloner(flintSchema);
    }

    @Override
    public Object[] readArray(Object[] reuse) throws IOException {
        int numFields = this.flintSchema.getFieldsSize();
        Object[] row = null != reuse && reuse.length >= numFields ? reuse : new Object[numFields];
        this.readRow(new ArrayRowAccessor(row));
        return row;
    }

    @Override
    public void readRow(WritableRow target) throws IOException {
        if (target.size() < this.flintSchema.getFieldsSize()) {
            throw new IllegalArgumentException("target size does not match the number of fields in schema");
        }
        this.rowCloner.apply(this.readRow(), target);
    }
}

