/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.util;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.ImmutablePair;

public final class MapEntries {
    private MapEntries() {
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new ImmutablePair(key, value);
    }

    public static <K, V> Map.Entry<K, V> entry(Supplier<K> keySupplier, Supplier<V> valueSupplier) {
        Objects.requireNonNull(keySupplier, "keySupplier must not be null");
        Objects.requireNonNull(valueSupplier, "valueSupplier must not be null");
        return MapEntries.entry(keySupplier.get(), valueSupplier.get());
    }

    public static <K, V> Predicate<Map.Entry<K, V>> keyValuePredicate(Predicate<K> keyPredicate, Predicate<V> valuePredicate) {
        Objects.requireNonNull(keyPredicate, "keyPredicate must not be null");
        Objects.requireNonNull(valuePredicate, "valuePredicate must not be null");
        return e -> keyPredicate.test(e.getKey()) && valuePredicate.test(e.getValue());
    }

    public static <K, V> Predicate<Map.Entry<K, V>> keyPredicate(Predicate<K> keyPredicate) {
        Objects.requireNonNull(keyPredicate, "keyPredicate must not be null");
        return e -> keyPredicate.test(e.getKey());
    }

    public static <K, V> Predicate<Map.Entry<K, V>> valuePredicate(Predicate<V> valuePredicate) {
        Objects.requireNonNull(valuePredicate, "valuePredicate must not be null");
        return e -> valuePredicate.test(e.getValue());
    }

    public static <K, V> Comparator<Map.Entry<K, V>> keyValueComparator(Comparator<K> keyComparator, Comparator<V> valueComparator) {
        Objects.requireNonNull(keyComparator, "keyComparator must not be null");
        Objects.requireNonNull(valueComparator, "valueComparator must not be null");
        Comparator<Map.Entry<K, V>> comp1 = MapEntries.keyComparator(keyComparator);
        Comparator<Map.Entry<K, V>> comp2 = MapEntries.valueComparator(valueComparator);
        return comp1.thenComparing(comp2);
    }

    public static <K extends Comparable<? super K>, V extends Comparable<? super V>> Comparator<Map.Entry<K, V>> naturalKeyValueComparator() {
        Comparator comp1 = Map.Entry.comparingByKey();
        Comparator comp2 = Map.Entry.comparingByValue();
        return comp1.thenComparing(comp2);
    }

    public static <K, V> Comparator<Map.Entry<K, V>> keyComparator(Comparator<K> keyComparator) {
        Objects.requireNonNull(keyComparator, "keyComparator must not be null");
        return Map.Entry.comparingByKey(keyComparator);
    }

    public static <K, V> Comparator<Map.Entry<K, V>> valueComparator(Comparator<V> valueComparator) {
        Objects.requireNonNull(valueComparator, "valueComparator must not be null");
        return Map.Entry.comparingByValue(valueComparator);
    }

    public static <K1, V1, K2, V2> Function<Map.Entry<K1, V1>, Map.Entry<K2, V2>> keyValueMapper(Function<K1, K2> keyMapper, Function<V1, V2> valueMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper must not be null");
        Objects.requireNonNull(valueMapper, "valueMapper must not be null");
        return e -> MapEntries.entry(keyMapper.apply(e.getKey()), valueMapper.apply(e.getValue()));
    }

    public static <K1, K2, V> Function<Map.Entry<K1, V>, Map.Entry<K2, V>> keyMapper(Function<K1, K2> keyMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper must not be null");
        return e -> MapEntries.entry(keyMapper.apply(e.getKey()), e.getValue());
    }

    public static <K, V1, V2> Function<Map.Entry<K, V1>, Map.Entry<K, V2>> valueMapper(Function<V1, V2> valueMapper) {
        Objects.requireNonNull(valueMapper, "valueMapper must not be null");
        return e -> MapEntries.entry(e.getKey(), valueMapper.apply(e.getValue()));
    }
}

