/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.util;

import com.ibm.ba.flint.avro.AvroRowReader;
import com.ibm.ba.flint.crypto.BlockCryptoInputStream;
import com.ibm.ba.flint.crypto.ICryptoProvider;
import com.ibm.ba.flint.io.InputStreamDecorator;
import com.ibm.ba.flint.thrift.query.SerializationFormat;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.util.ThriftStreamRowReader;
import com.ibm.ba.flint.util.DeserializePartitionsFromFiles;
import com.ibm.ba.flint.util.RowReader;
import com.ibm.ba.flint.util.StreamRowReaderFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodecFactory;

public class ResultDeserializer {
    private final Configuration hadoopConf;
    private final CompressionCodecFactory codecFactory;
    private final ICryptoProvider cryptoProvider;

    public ResultDeserializer(Configuration hadoopConf) {
        this(hadoopConf, null);
    }

    public ResultDeserializer(Configuration hadoopConf, ICryptoProvider cryptoProvider) {
        if (null == hadoopConf) {
            throw new IllegalArgumentException("hadoopConf was null");
        }
        this.hadoopConf = hadoopConf;
        this.cryptoProvider = cryptoProvider;
        this.codecFactory = new CompressionCodecFactory(hadoopConf);
    }

    private static String getFileExtension(SerializationFormat format) {
        switch (format) {
            case AVRO: {
                return "avro";
            }
            case THRIFT: {
                return "thrift";
            }
            case THRIFT_GZIP: {
                return "thrift.gz";
            }
            case THRIFT_SNAPPY: {
                return "thrift.snappy";
            }
        }
        throw new IllegalArgumentException("Unsupported serialization format: " + format);
    }

    public RowReader deserialize(Schema schema, Path inPath, SerializationFormat format) throws IOException {
        String fileExtension = ResultDeserializer.getFileExtension(format);
        StreamRowReaderFactory readerFactory = this.getRowReaderFactory(format);
        return new DeserializePartitionsFromFiles(schema, inPath, fileExtension, this.hadoopConf, readerFactory).deserialize();
    }

    private StreamRowReaderFactory getRowReaderFactory(SerializationFormat format) {
        StreamRowReaderFactory baseReaderFactory;
        InputStreamDecorator streamDecorator = InputStreamDecorator.identity();
        switch (format) {
            case AVRO: {
                baseReaderFactory = AvroRowReader::new;
                break;
            }
            case THRIFT: {
                baseReaderFactory = ThriftStreamRowReader::new;
                break;
            }
            case THRIFT_GZIP: {
                baseReaderFactory = ThriftStreamRowReader::new;
                streamDecorator = in -> this.codecFactory.getCodecByName("gzip").createInputStream(in);
                break;
            }
            case THRIFT_SNAPPY: {
                baseReaderFactory = ThriftStreamRowReader::new;
                streamDecorator = in -> this.codecFactory.getCodecByName("snappy").createInputStream(in);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported serialization format: " + format);
            }
        }
        if (null != this.cryptoProvider) {
            streamDecorator = streamDecorator.compose(in -> new BlockCryptoInputStream(in, this.cryptoProvider));
        }
        return baseReaderFactory.decorateStream(streamDecorator);
    }
}

