/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.util;

import com.ibm.ba.flint.thrift.types.DataType;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.types.SchemaField;
import com.ibm.ba.flint.util.ReadableRow;
import com.ibm.ba.flint.util.WritableRow;

public final class RowUtils {
    private RowUtils() {
    }

    public static RowTransfer createRowCloner(Schema schema) {
        RowTransfer[] fieldCloners = new RowTransfer[schema.getFieldsSize()];
        for (int i = 0; i < fieldCloners.length; ++i) {
            fieldCloners[i] = RowUtils.createFieldCloner(i, (SchemaField)schema.getFields().get(i));
        }
        return RowUtils.createRowCloner(fieldCloners, 0, fieldCloners.length);
    }

    private static RowTransfer createRowCloner(RowTransfer[] fieldCloners, int start, int length) {
        if (start < 0) {
            throw new IllegalArgumentException("start < 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (start + length > fieldCloners.length) {
            throw new IndexOutOfBoundsException("start + length > fieldCloners.length");
        }
        switch (length) {
            case 0: {
                return (source, target) -> {};
            }
            case 1: {
                return fieldCloners[start];
            }
            case 2: {
                return (source, target) -> {
                    fieldCloners[start].apply(source, target);
                    fieldCloners[start + 1].apply(source, target);
                };
            }
            case 3: {
                return (source, target) -> {
                    fieldCloners[start].apply(source, target);
                    fieldCloners[start + 1].apply(source, target);
                    fieldCloners[start + 2].apply(source, target);
                };
            }
            case 4: {
                return (source, target) -> {
                    fieldCloners[start].apply(source, target);
                    fieldCloners[start + 1].apply(source, target);
                    fieldCloners[start + 2].apply(source, target);
                    fieldCloners[start + 3].apply(source, target);
                };
            }
            case 5: {
                return (source, target) -> {
                    fieldCloners[start].apply(source, target);
                    fieldCloners[start + 1].apply(source, target);
                    fieldCloners[start + 2].apply(source, target);
                    fieldCloners[start + 3].apply(source, target);
                    fieldCloners[start + 4].apply(source, target);
                };
            }
            case 6: {
                return (source, target) -> {
                    fieldCloners[start].apply(source, target);
                    fieldCloners[start + 1].apply(source, target);
                    fieldCloners[start + 2].apply(source, target);
                    fieldCloners[start + 3].apply(source, target);
                    fieldCloners[start + 4].apply(source, target);
                    fieldCloners[start + 5].apply(source, target);
                };
            }
            case 7: {
                return (source, target) -> {
                    fieldCloners[start].apply(source, target);
                    fieldCloners[start + 1].apply(source, target);
                    fieldCloners[start + 2].apply(source, target);
                    fieldCloners[start + 3].apply(source, target);
                    fieldCloners[start + 4].apply(source, target);
                    fieldCloners[start + 5].apply(source, target);
                    fieldCloners[start + 6].apply(source, target);
                };
            }
            case 8: {
                return (source, target) -> {
                    fieldCloners[start].apply(source, target);
                    fieldCloners[start + 1].apply(source, target);
                    fieldCloners[start + 2].apply(source, target);
                    fieldCloners[start + 3].apply(source, target);
                    fieldCloners[start + 4].apply(source, target);
                    fieldCloners[start + 5].apply(source, target);
                    fieldCloners[start + 6].apply(source, target);
                    fieldCloners[start + 7].apply(source, target);
                };
            }
            case 9: {
                return (source, target) -> {
                    fieldCloners[start].apply(source, target);
                    fieldCloners[start + 1].apply(source, target);
                    fieldCloners[start + 2].apply(source, target);
                    fieldCloners[start + 3].apply(source, target);
                    fieldCloners[start + 4].apply(source, target);
                    fieldCloners[start + 5].apply(source, target);
                    fieldCloners[start + 6].apply(source, target);
                    fieldCloners[start + 7].apply(source, target);
                    fieldCloners[start + 8].apply(source, target);
                };
            }
            case 10: {
                return (source, target) -> {
                    fieldCloners[start].apply(source, target);
                    fieldCloners[start + 1].apply(source, target);
                    fieldCloners[start + 2].apply(source, target);
                    fieldCloners[start + 3].apply(source, target);
                    fieldCloners[start + 4].apply(source, target);
                    fieldCloners[start + 5].apply(source, target);
                    fieldCloners[start + 6].apply(source, target);
                    fieldCloners[start + 7].apply(source, target);
                    fieldCloners[start + 8].apply(source, target);
                    fieldCloners[start + 9].apply(source, target);
                };
            }
        }
        int div10 = length / 10;
        int mod10 = length % 10;
        RowTransfer[] groups = new RowTransfer[div10 + 1];
        for (int i = 0; i < div10; ++i) {
            groups[i] = RowUtils.createRowCloner(fieldCloners, start + 10 * i, 10);
        }
        groups[div10] = RowUtils.createRowCloner(fieldCloners, start + 10 * div10, mod10);
        return (source, target) -> {
            for (RowTransfer c : groups) {
                c.apply(source, target);
            }
        };
    }

    private static RowTransfer createFieldCloner(int index, SchemaField field) {
        RowTransfer nonNullCloner = RowUtils.createNonNullFieldCloner(index, field.getType());
        if (field.isNullable()) {
            return (source, target) -> {
                if (source.isNull(index)) {
                    target.setNull(index);
                } else {
                    nonNullCloner.apply(source, target);
                }
            };
        }
        if (field.getType() == DataType.UNKNOWN) {
            return nonNullCloner;
        }
        return (source, target) -> {
            if (source.isNull(index)) {
                throw new IllegalArgumentException("Cannot set null value for non-nullable field: " + field.toString());
            }
            nonNullCloner.apply(source, target);
        };
    }

    private static RowTransfer createNonNullFieldCloner(int index, DataType type) {
        switch (type) {
            case BINARY: {
                return (source, target) -> target.setBinary(index, source.getBinary(index));
            }
            case BOOLEAN: {
                return (source, target) -> target.setBoolean(index, source.getBoolean(index));
            }
            case BYTE: {
                return (source, target) -> target.setByte(index, source.getByte(index));
            }
            case DATE: {
                return (source, target) -> target.setDate(index, source.getDate(index));
            }
            case DECIMAL: {
                return (source, target) -> target.setDecimal(index, source.getDecimal(index));
            }
            case DOUBLE: {
                return (source, target) -> target.setDouble(index, source.getDouble(index));
            }
            case FLOAT: {
                return (source, target) -> target.setFloat(index, source.getFloat(index));
            }
            case INT: {
                return (source, target) -> target.setInt(index, source.getInt(index));
            }
            case LONG: {
                return (source, target) -> target.setLong(index, source.getLong(index));
            }
            case SHORT: {
                return (source, target) -> target.setShort(index, source.getShort(index));
            }
            case STRING: {
                return (source, target) -> target.setString(index, source.getString(index));
            }
            case TIMESTAMP: {
                return (source, target) -> target.setTimestamp(index, source.getTimestamp(index));
            }
            case UNKNOWN: {
                return (source, target) -> {};
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    @FunctionalInterface
    public static interface RowTransfer {
        public void apply(ReadableRow var1, WritableRow var2);
    }
}

