/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.util;

import com.ibm.ba.flint.util.EmptyRowReader;
import com.ibm.ba.flint.util.ReadableRow;
import com.ibm.ba.flint.util.RowReader;
import com.ibm.ba.flint.util.WritableRow;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class UnionRowReader
implements RowReader {
    private final Iterator<RowReaderSupplier> supplierIter;
    private RowReader current = EmptyRowReader.INSTANCE;
    private boolean hasMoreKnown = false;

    public UnionRowReader(Collection<RowReader> readers) {
        this(readers.stream().map(r -> () -> r).iterator());
    }

    public UnionRowReader(Iterator<RowReaderSupplier> supplierIter) {
        this.supplierIter = supplierIter;
    }

    @Override
    public boolean hasMore() throws IOException {
        if (this.hasMoreKnown) {
            return true;
        }
        while (!this.current.hasMore()) {
            if (this.supplierIter.hasNext()) {
                this.current.close();
                this.current = this.supplierIter.next().get();
                continue;
            }
            return false;
        }
        this.hasMoreKnown = true;
        return true;
    }

    @Override
    public Object[] readArray(Object[] reuse) throws IOException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        this.hasMoreKnown = false;
        return this.current.readArray(reuse);
    }

    @Override
    public ReadableRow readRow() throws IOException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        this.hasMoreKnown = false;
        return this.current.readRow();
    }

    @Override
    public void readRow(WritableRow target) throws IOException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        this.hasMoreKnown = false;
        this.current.readRow(target);
    }

    @Override
    public void close() throws IOException {
        try {
            this.current.close();
        }
        finally {
            this.current = EmptyRowReader.INSTANCE;
            this.hasMoreKnown = false;
        }
    }

    @FunctionalInterface
    public static interface RowReaderSupplier {
        public RowReader get() throws IOException;
    }
}

