/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications.dbstore;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import java.util.List;
import java.util.Properties;
import org.dom4j.Element;

public class LogDbStoreScriptParameters {
    private static final String CONFIGURATION_ADVANCED_PROPERTIES = "advancedProperties";
    private static final String CONFIGURATION_ADVANCED_PROPERTIES_PARAMETER = "parameter";
    private static final String CONFIGURATION_ADVANCED_PROPERTIES_VALUE = "value";
    private static final String CONFIGURATION_ADVANCED_PROPERTIES_PARAMETER_NAME = "name";
    private static final String IPFSCRIPT_PARAMETER_PREFIX = "IPFSCRIPT";
    private Properties m_scriptParameters = new Properties();

    protected void loadFromConfiguration() throws Exception {
        ICCLConfiguration oConfig = CCLConfigurationFactory.createConfiguration();
        oConfig.init();
        Element e = oConfig.getValueElement(CONFIGURATION_ADVANCED_PROPERTIES, true);
        if (e == null) {
            return;
        }
        List parametersList = e.elements(CONFIGURATION_ADVANCED_PROPERTIES_PARAMETER);
        for (Element parameterElement : parametersList) {
            String parameterName = parameterElement.attributeValue(CONFIGURATION_ADVANCED_PROPERTIES_PARAMETER_NAME);
            if (!parameterName.startsWith(IPFSCRIPT_PARAMETER_PREFIX)) continue;
            Element valueElement = parameterElement.element(CONFIGURATION_ADVANCED_PROPERTIES_VALUE);
            String parameterValue = valueElement.getText();
            this.m_scriptParameters.put(parameterName, parameterValue);
        }
    }

    public void initialize() throws Exception {
        this.loadFromConfiguration();
    }

    public String getParameter(String parameterName) {
        return this.m_scriptParameters.getProperty(parameterName);
    }

    public String getParameter(String parameterName, String defaultValue) {
        String parameterValue = this.m_scriptParameters.getProperty(parameterName);
        if (parameterValue != null) {
            return parameterValue;
        }
        return defaultValue;
    }

    public String replaceAllParameters(String line) {
        if (line.indexOf(IPFSCRIPT_PARAMETER_PREFIX) < 0) {
            return line;
        }
        for (String string : this.m_scriptParameters.keySet()) {
            String parameterValue = (String)this.m_scriptParameters.get(string);
            line = line.replaceAll(string, parameterValue);
        }
        return line;
    }
}

