/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWAdaptor;
import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWClusterOwner;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWConnectionManager;
import com.cognos.mfw4j.framework.MFWGatewayImpl;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.log.MFWLogGateway;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class MFW {
    private static MFW gSingleton = new MFW();
    private static final String OFFLINE_OLAP_UNIT_TESTING = "offLineOLAPUnitTesting";
    private ReentrantReadWriteLock mRWLock = new ReentrantReadWriteLock();
    private ArrayList<MFWAdaptor> mAdaptors = new ArrayList();
    private ConcurrentLinkedQueue<MFWGatewayImpl> mGateways = new ConcurrentLinkedQueue();

    static MFW getInstance() {
        return gSingleton;
    }

    private MFW() {
        MFWModel.getInstance();
        MFWConnectionManager.getInstance();
    }

    void destroy() {
        Iterator<MFWGatewayImpl> gwItr = this.mGateways.iterator();
        while (gwItr.hasNext()) {
            gwItr.next().destroy();
        }
        for (MFWAdaptor anAdaptor : this.mAdaptors) {
            anAdaptor.destroy();
        }
        this.mGateways.clear();
        this.mAdaptors.clear();
        MFWModelRes.getInstance().destroy();
        MFWModel.getInstance().destroy();
        MFWConfiguration.getInstance().destroy();
    }

    void setupGateway(MFWGatewayImpl newGW, MFWMetadataSource aSrc) {
        String meth = "MFW::setupGateway";
        MFWLogGateway log = new MFWLogGateway("MFW::setupGateway", newGW.getID(), newGW.getRequestContext(), aSrc);
        try {
            MFWRequestContextUser newGWContext = newGW.getRequestContext();
            MFWCluster aCluster = this.findOrCreateCluster(newGW, newGWContext, aSrc, null);
            newGW.setCluster(aCluster);
            newGWContext.setGatewayCluster(aCluster);
        }
        catch (RuntimeException t) {
            newGW.destroy();
            log.logEnd(t);
            throw t;
        }
        log.logEnd();
        this.mGateways.add(newGW);
    }

    void teardownGateway(MFWGatewayImpl oldGW) {
        boolean bIsValid = this.mGateways.remove(oldGW);
        if (bIsValid) {
            oldGW.destroy();
        }
        oldGW = null;
    }

    MFWCluster findOrCreateCluster(MFWClusterOwner anOwner, MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc, MFWNodeObject aLinkNodeParent) {
        MFWCluster outCluster = null;
        MFWAdaptor anAdaptor = this.findOrCreateAdaptor(aContext, aMetadataSrc);
        MFWConnection aConnection = anAdaptor.findOrCreateConnection(anOwner, aContext, aMetadataSrc, aLinkNodeParent);
        aConnection.waitForSetup();
        MFWException.ASSERT(aConnection.getCluster() != null, "Connection cannot be null ... the adaptor failed to return a valid connection");
        outCluster = aConnection.getCluster();
        outCluster.setLastAccessedTime(System.currentTimeMillis());
        return outCluster;
    }

    private MFWAdaptor findOrCreateAdaptor(MFWRequestContextUser aContext, MFWMetadataSource aSource) {
        MFWConfiguration.MFWConfigSource aSrcCnfg = MFWConfiguration.getInstance().getConfigInfoFor(aSource.getType());
        MFWException.ASSERT(aSrcCnfg != null, "no configuration entry was found for source type of:", aSource.getType());
        String adaptorClassName = aSrcCnfg.getAdaptorClassName();
        if ("com.cognos.mfwa4j.adaptorDim.MFWDimAdaptor".equals(adaptorClassName) && aContext.getXQEExecutionEnvironment() == null && (aContext.getPromptResolution() == null || !OFFLINE_OLAP_UNIT_TESTING.equals(aContext.getPromptResolution().getName()))) {
            adaptorClassName = "com.cognos.mfwa4j.adaptorDimMDDS.MFWDimAdaptor";
        }
        return this.findOrLoadAdaptor(aSource.getType(), adaptorClassName, aSrcCnfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MFWAdaptor findOrLoadAdaptor(String srcType, String adaptorClassName, MFWConfiguration.MFWConfigSource aSrcCnfg) {
        MFWAdaptor outAdaptor = null;
        this.mRWLock.readLock().lock();
        try {
            outAdaptor = this.findAdaptor(srcType, adaptorClassName);
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
        if (outAdaptor == null) {
            this.mRWLock.writeLock().lock();
            try {
                outAdaptor = this.findAdaptor(srcType, adaptorClassName);
                if (outAdaptor != null) {
                    MFWAdaptor mFWAdaptor = outAdaptor;
                    return mFWAdaptor;
                }
                outAdaptor = this.instantiateAdaptor(adaptorClassName);
                MFWException.ASSERT(outAdaptor != null, "Unable to instantiate an adaptor of type:", adaptorClassName);
                outAdaptor.setSourceConfig(aSrcCnfg);
                this.mAdaptors.add(outAdaptor);
            }
            finally {
                this.mRWLock.writeLock().unlock();
            }
        }
        return outAdaptor;
    }

    private MFWAdaptor findAdaptor(String srcType, String adaptorClassName) {
        for (MFWAdaptor anAdaptor : this.mAdaptors) {
            if (!anAdaptor.getSourceConfig().getSourceType().equals(srcType) || !anAdaptor.getClass().getName().equals(adaptorClassName)) continue;
            return anAdaptor;
        }
        return null;
    }

    private MFWAdaptor instantiateAdaptor(String adaptorClassName) {
        MFWAdaptor outAdaptor = null;
        try {
            Class<?> adaptorClass = Class.forName(adaptorClassName);
            outAdaptor = (MFWAdaptor)adaptorClass.newInstance();
        }
        catch (Exception e) {
            MFWException.ASSERT(false, "Failed to create adaptor of type: " + adaptorClassName);
        }
        return outAdaptor;
    }

    void cleanCaches(boolean includePMCs) {
        for (MFWAdaptor anAdaptor : this.mAdaptors) {
            anAdaptor.evictConnections();
        }
        if (includePMCs) {
            ArrayList<String> inUsePMCs = new ArrayList<String>(100);
            for (MFWAdaptor anAdaptor : this.mAdaptors) {
                anAdaptor.collectInUsePMCs(inUsePMCs);
            }
            HashMap<String, ArrayList<String>> mapExpiredPMCs = new HashMap<String, ArrayList<String>>(20);
            MFWAdaptor.collectExpiredPMCs(inUsePMCs, mapExpiredPMCs);
            for (Map.Entry expEntry : mapExpiredPMCs.entrySet()) {
                MFWConfiguration.MFWConfigSource aSrcCnfg = MFWConfiguration.getInstance().getConfigInfoFor((String)expEntry.getKey());
                MFWException.ASSERT(aSrcCnfg != null, "no configuration entry was found for source type of:", (String)expEntry.getKey());
                MFWAdaptor anAdaptor = this.findOrLoadAdaptor((String)expEntry.getKey(), aSrcCnfg.getAdaptorClassName(), aSrcCnfg);
                anAdaptor.deleteExpiredPMCs((ArrayList)expEntry.getValue());
            }
        }
    }
}

