/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWClusterOwner;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWConnectionManager;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.implPersistence.MFWPersistentMetadataCluster;
import com.cognos.mfw4j.framework.log.MFWLogEviction;
import com.cognos.mfw4j.framework.log.MFWLogEvictionExamination;
import com.cognos.mfw4j.framework.log.MFWLogEvictionExaminationPMC;
import com.cognos.mfw4j.framework.log.MFWLogException;
import com.cognos.mfw4j.framework.policies.MFWEvictionPolicy;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class MFWAdaptor {
    private ReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();
    private MFWConfiguration.MFWConfigSource mSrcConfig = null;
    private ArrayList<MFWConnection> mConnections = new ArrayList(20);

    protected MFWAdaptor() {
    }

    protected void destroy() {
        for (MFWConnection aConnection : this.mConnections) {
            this.unregister(aConnection);
        }
        MFWException.ASSERT(this.mConnections.size() == 0, "All connectios by now must have been disconnected");
        this.mReadWriteLock = null;
        this.mSrcConfig = null;
        this.mConnections = null;
    }

    protected void associateEvictionPolicy(MFWEvictionPolicy policy) {
        MFWConnectionManager.getInstance().addEvictionPolicy(policy);
    }

    public abstract MFWConnection connect(MFWConnectionReuseInfo var1, MFWRequestContextUser var2);

    protected abstract MFWConnectionReuseInfo createReuseInfo(MFWRequestContextUser var1, MFWMetadataSource var2, MFWNodeObject var3);

    public MFWConnectionReuseInfo reconstructReuseInfo(MFWPersistentMetadataCluster aPMC, int aPosition) {
        MFWException.ASSERT(false, "ReconstructReuseInfo  is not suppoerted for connections of this type:", this.getSourceConfig().getSourceType());
        return null;
    }

    public MFWConfiguration.MFWConfigSource getSourceConfig() {
        return this.mSrcConfig;
    }

    protected void setSourceConfig(MFWConfiguration.MFWConfigSource aSrcConfig) {
        this.mSrcConfig = aSrcConfig;
    }

    private void unregister(MFWConnection aConnection) {
        this.mReadWriteLock.writeLock().lock();
        try {
            int index = this.mConnections.indexOf(aConnection);
            MFWException.ASSERT(index >= 0, "Unable to find the connection that is being unregistered");
            this.mConnections.remove(index);
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
        aConnection.getCluster().destroy();
        aConnection.destroy();
    }

    private boolean persistentCachingEnabled(MFWMetadataSource aMetadataSrc) {
        boolean isEnabled;
        String sCacheMode = (String)aMetadataSrc.getConnectionItem("cachingMode");
        boolean bl = isEnabled = "persistent".equals(sCacheMode) || sCacheMode == null && "persistent".equals(this.mSrcConfig.getCapability("cachingMode"));
        if (isEnabled && "com.cognos.mfwa4j.adaptorDimMDDS.MFWDimAdaptor".equals(this.getClass().getName())) {
            isEnabled = false;
        }
        return isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MFWConnection findOrCreateConnection(MFWClusterOwner anOwner, MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc, MFWNodeObject aLinkParent) {
        MFWConnectionReuseInfo inReuseInfo = this.createReuseInfo(aContext, aMetadataSrc, aLinkParent);
        MFWConnection outConn = null;
        this.mReadWriteLock.readLock().lock();
        try {
            outConn = this.findOpenConnection(anOwner, aContext, inReuseInfo);
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
        if (outConn != null) {
            return outConn;
        }
        MFWCluster newCluster = null;
        MFWConnection.EClusterSetup eSetupType = MFWConnection.EClusterSetup.kEUnknown;
        this.mReadWriteLock.writeLock().lock();
        try {
            outConn = this.findOpenConnection(anOwner, aContext, inReuseInfo);
            if (outConn != null) {
                MFWConnection mFWConnection = outConn;
                return mFWConnection;
            }
            if (this.persistentCachingEnabled(aMetadataSrc)) {
                outConn = this.connect(inReuseInfo, aContext);
                newCluster = new MFWCluster(outConn);
                boolean bCreated = MFWPersistentMetadataCluster.findOrCreate(aContext, newCluster, inReuseInfo);
                eSetupType = bCreated ? MFWConnection.EClusterSetup.kEInitializeExpandAll : MFWConnection.EClusterSetup.kEReconstruct;
                this.mConnections.add(outConn);
            } else {
                outConn = this.connect(inReuseInfo, aContext);
                newCluster = new MFWCluster(outConn);
                eSetupType = MFWConnection.EClusterSetup.kEInitialize;
                this.mConnections.add(outConn);
            }
            outConn.setCluster(newCluster);
            newCluster.registerOwner(anOwner, aContext);
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
        outConn.setup(newCluster, aContext, aLinkParent, eSetupType);
        return outConn;
    }

    private MFWConnection findOpenConnection(MFWClusterOwner anOwner, MFWRequestContextUser aContext, MFWConnectionReuseInfo inReuseInfo) {
        for (int i = 0; i < this.mConnections.size(); ++i) {
            MFWConnection aConn = this.mConnections.get(i);
            if (!aConn.isReusable() || !aConn.getReuseInfo().isReusableFor(inReuseInfo) || !aConn.getReuseInfo().isCacheUpToDate(aContext, inReuseInfo)) continue;
            aConn.getCluster().registerOwner(anOwner, aContext);
            return aConn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evictConnections() {
        MFWLogEvictionExamination log = new MFWLogEvictionExamination("MFWAdaptor::evictConnections for adaptpr:" + this.getSourceConfig().getSourceType(), this.mConnections.size());
        this.mReadWriteLock.writeLock().lock();
        try {
            ArrayList<MFWConnection> failedConns = new ArrayList<MFWConnection>();
            for (int i = this.mConnections.size() - 1; i >= 0; --i) {
                MFWConnection conn = this.mConnections.get(i);
                this.evictClusterIfRequired(conn, failedConns);
            }
            for (MFWConnection aConn : failedConns) {
                this.mConnections.remove(aConn);
            }
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
        log.logEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterOwner(MFWClusterOwner owner, MFWCluster aCluster, MFWRequestContextUser aContext) {
        this.mReadWriteLock.writeLock().lock();
        try {
            aCluster.unregisterOwner(owner, aContext);
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
    }

    boolean shouldEvictCluster(MFWConnection aConn) {
        boolean bEvict = false;
        ArrayList<MFWEvictionPolicy> vDefaultPolicies = MFWConnectionManager.getInstance().getEvictionPolicies();
        for (int i = 0; i < vDefaultPolicies.size(); ++i) {
            MFWEvictionPolicy aPolicy = vDefaultPolicies.get(i);
            short evictAction = aPolicy.getEvictionAction(aConn.getReuseInfo());
            if (evictAction != 1) continue;
            MFWLogEviction log = new MFWLogEviction("MFWAdaptor::shouldEvictCluster", aConn.getReuseInfo(), aPolicy.toString());
            log.logEnd();
            bEvict = true;
        }
        return bEvict;
    }

    private boolean evictClusterIfRequired(MFWConnection aConn, List<MFWConnection> failedConns) {
        boolean bEvicted = false;
        MFWCluster aCluster = aConn.getCluster();
        MFWLogEvictionExamination log = new MFWLogEvictionExamination("MFWAdaptor:evictClusterIfRequired", aCluster);
        try {
            if (aCluster.getReferenceCount() == 0) {
                boolean bl = bEvicted = aConn.canBeCheckedForEviction() && (!aConn.isReusable() || this.shouldEvictCluster(aConn));
                if (bEvicted) {
                    this.unregister(aConn);
                }
            }
        }
        catch (Throwable t) {
            aConn.setReusable(false);
            log.logEnd(t);
            failedConns.add(aConn);
        }
        log.logEnd();
        return bEvicted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collectInUsePMCs(List<String> inUsePMCs) {
        this.mReadWriteLock.readLock().lock();
        try {
            for (MFWConnection aConn : this.mConnections) {
                if (!aConn.isAssociatedWithPMC()) continue;
                inUsePMCs.add(aConn.getPMC().getPMCStore().getCanonicalFilePath());
            }
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    static void collectExpiredPMCs(List<String> inUsePMCFilePaths, Map<String, ArrayList<String>> mapExpiredPMCs) {
        File pmcDir = new File(MFWConfiguration.getInstance().getPMCDirectoryPath());
        ArrayList<File> pmcFiles = new ArrayList<File>(100);
        MFWAdaptor.collectReuseInfo(pmcDir, pmcFiles, MFWConnectionReuseInfo.PMCFileFilter);
        MFWLogEvictionExaminationPMC logAll = new MFWLogEvictionExaminationPMC("MFWAdaptor::removePMCsIfRequired", "All", pmcFiles.size());
        ArrayList<MFWEvictionPolicy> vPMCPolicies = MFWConnectionManager.getInstance().getPMCEvictionPolicies();
        ListIterator<File> itr = pmcFiles.listIterator();
        while (itr.hasNext()) {
            try {
                File aPMCFile = itr.next();
                if (inUsePMCFilePaths.contains(aPMCFile.getCanonicalPath())) continue;
                MFWPersistentMetadataCluster.collectIfExpired(vPMCPolicies, aPMCFile, mapExpiredPMCs);
            }
            catch (RuntimeException t) {
                throw t;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        logAll.logEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteExpiredPMCs(ArrayList<String> expiredPMCs) {
        this.mReadWriteLock.writeLock().lock();
        try {
            ArrayList<String> inUsePMCs = new ArrayList<String>(this.mConnections.size());
            for (MFWConnection aConn : this.mConnections) {
                if (!aConn.isAssociatedWithPMC()) continue;
                inUsePMCs.add(aConn.getPMC().getPMCStore().getCanonicalFilePath());
            }
            for (String expPMCFilePath : expiredPMCs) {
                try {
                    if (inUsePMCs.contains(expPMCFilePath)) continue;
                    MFWPersistentMetadataCluster.deletePMCFile(expPMCFilePath);
                }
                catch (Throwable t) {
                    MFWLogException le = new MFWLogException(t, "");
                    le.logEnd();
                }
            }
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
    }

    private static void collectReuseInfo(File entry, ArrayList<File> pmcFiles, FileFilter nameFilter) {
        if (entry.isDirectory()) {
            File[] children = entry.listFiles(nameFilter);
            for (int i = 0; i < children.length; ++i) {
                MFWAdaptor.collectReuseInfo(children[i], pmcFiles, nameFilter);
            }
        } else {
            pmcFiles.add(entry);
        }
    }
}

