/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFW;
import com.cognos.mfw4j.framework.log.MFWLogEvictionManagerWakeup;
import com.cognos.mfw4j.framework.policies.MFWEvictionPolicy;
import com.cognos.mfw4j.framework.policies.MFWEvictionPolicyLastAccessed;
import com.cognos.mfw4j.framework.policies.MFWEvictionPolicyMaxAge;
import com.cognos.mfw4j.framework.policies.MFWEvictionPolicyOnClose;
import com.cognos.mfw4j.framework.policies.MFWPMCEvictionPolicyLastAccessed;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MFWConnectionManager
extends Thread {
    private long m_wakeUpInterval = 20000L;
    private Object m_countingSemaphor = new Object();
    private ArrayList<MFWEvictionPolicy> m_evictionPoliciesCluster = new ArrayList();
    private ArrayList<MFWEvictionPolicy> m_evictionPoliciesPMC = new ArrayList();
    private boolean m_finished = false;
    private short m_checkPMCsCycle;
    private short m_curCycle;
    private static MFWConnectionManager CONNECTION_MANAGER = new MFWConnectionManager();

    private MFWConnectionManager() {
        this.setDaemon(true);
        this.setName("MFWConnectionManager");
        this.m_checkPMCsCycle = (short)10;
        this.m_curCycle = 0;
    }

    static MFWConnectionManager getInstance() {
        return CONNECTION_MANAGER;
    }

    ArrayList<MFWEvictionPolicy> getEvictionPolicies() {
        return this.m_evictionPoliciesCluster;
    }

    ArrayList<MFWEvictionPolicy> getPMCEvictionPolicies() {
        return this.m_evictionPoliciesPMC;
    }

    void addEvictionPolicy(MFWEvictionPolicy policy) {
        this.m_evictionPoliciesCluster.add(policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.m_finished) {
            Object object = this.m_countingSemaphor;
            synchronized (object) {
                try {
                    this.m_countingSemaphor.wait(this.m_wakeUpInterval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String cMeth = "MFWConnectionManager::run()";
            MFWLogEvictionManagerWakeup log = new MFWLogEvictionManagerWakeup("MFWConnectionManager::run()");
            try {
                this.m_curCycle = (short)(this.m_curCycle + 1);
                if (this.m_curCycle == this.m_checkPMCsCycle) {
                    this.m_curCycle = 0;
                    MFW.getInstance().cleanCaches(true);
                } else {
                    MFW.getInstance().cleanCaches(false);
                }
            }
            catch (Throwable t) {
                try {
                    log.logEnd(t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            log.logEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutDownAndExit() {
        this.m_finished = true;
        Object object = this.m_countingSemaphor;
        synchronized (object) {
            this.m_countingSemaphor.notifyAll();
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWakeup() {
        Object object = this.m_countingSemaphor;
        synchronized (object) {
            this.m_countingSemaphor.notify();
        }
    }

    private void initializeFromConfigFile() {
        NodeList evePolicies;
        NodeList pmcCycle;
        Element elmRoot = MFWConfiguration.getInstance().getConnectionManagerConfiguration();
        NodeList wakeup = elmRoot.getElementsByTagName("wakeupInterval");
        if (wakeup.getLength() > 0) {
            String value = wakeup.item(0).getFirstChild().getNodeValue();
            int inMinutes = Integer.parseInt(value);
            this.m_wakeUpInterval = (long)inMinutes * 60000L;
        }
        if ((pmcCycle = elmRoot.getElementsByTagName("checkPMCsCycle")).getLength() > 0) {
            String value = pmcCycle.item(0).getFirstChild().getNodeValue();
            this.m_checkPMCsCycle = (short)Integer.parseInt(value);
        }
        MFWException.ASSERT((evePolicies = elmRoot.getElementsByTagName("evictionPolicies")).getLength() == 1, "Expecting a single sectioon for eviction policies in the config file");
        for (Node aNode = evePolicies.item(0).getFirstChild(); aNode != null; aNode = aNode.getNextSibling()) {
            String val;
            if (aNode.getNodeType() != 1 || !"clusterPolicy".equals(aNode.getNodeName()) && !"PMCPolicy".equals(aNode.getNodeName())) continue;
            Element elem = (Element)aNode;
            boolean isClusterPolicy = "clusterPolicy".equals(elem.getNodeName());
            String priorityString = elem.getAttribute("priority");
            int priority = 0;
            if (!"".equals(priorityString)) {
                priority = Integer.parseInt(priorityString);
            }
            MFWEvictionPolicy evictionPolicy = null;
            String attValue = elem.getAttribute("type");
            if (isClusterPolicy && "lastAccessed".equals(attValue)) {
                val = MFWConnectionManager.getPropertyValue("lastAccessed", elem);
                if (!"".equals(val)) {
                    evictionPolicy = new MFWEvictionPolicyLastAccessed(priority, Integer.parseInt(val));
                }
            } else if (isClusterPolicy && "maxAge".equals(attValue)) {
                val = MFWConnectionManager.getPropertyValue("maxAge", elem);
                if (!"".equals(val)) {
                    evictionPolicy = new MFWEvictionPolicyMaxAge(priority, Integer.parseInt(val));
                }
            } else if (isClusterPolicy && "onClose".equals(attValue)) {
                evictionPolicy = new MFWEvictionPolicyOnClose(priority);
            } else if (!isClusterPolicy && "lastAccessed".equals(attValue) && !"".equals(val = MFWConnectionManager.getPropertyValue("lastAccessed", elem))) {
                evictionPolicy = new MFWPMCEvictionPolicyLastAccessed(priority, Integer.parseInt(val));
            }
            NodeList elemChildren = elem.getChildNodes();
            Node appliesTo = null;
            for (int childIdx = 0; childIdx < elemChildren.getLength(); ++childIdx) {
                Element el;
                Node node = elemChildren.item(childIdx);
                if (node.getNodeType() != 1 || !"appliesTo".equals((el = (Element)node).getTagName())) continue;
                appliesTo = el;
                break;
            }
            if (evictionPolicy != null) {
                if (isClusterPolicy) {
                    this.m_evictionPoliciesCluster.add(evictionPolicy);
                } else {
                    this.m_evictionPoliciesPMC.add(evictionPolicy);
                }
            }
            if (appliesTo == null || evictionPolicy == null) continue;
            NodeList appliesToChildren = appliesTo.getChildNodes();
            for (int childIdx = 0; childIdx < appliesToChildren.getLength(); ++childIdx) {
                Element source;
                Node node = appliesToChildren.item(childIdx);
                if (node.getNodeType() != 1 || !"source".equals((source = (Element)node).getTagName())) continue;
                evictionPolicy.addAppliesToSource(source.getFirstChild().getNodeValue());
            }
        }
    }

    private static String getPropertyValue(String propName, Element elem) {
        NodeList props = elem.getElementsByTagName("property");
        for (int i = 0; i < props.getLength(); ++i) {
            Element prop = (Element)props.item(i);
            Element name = (Element)prop.getElementsByTagName("name").item(0);
            String nameVal = name.getFirstChild().getNodeValue();
            if (!propName.equals(nameVal)) continue;
            Element value = (Element)prop.getElementsByTagName("value").item(0);
            return value.getFirstChild().getNodeValue();
        }
        return null;
    }

    static {
        CONNECTION_MANAGER.initializeFromConfigFile();
        CONNECTION_MANAGER.start();
    }
}

