/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFW;
import com.cognos.mfw4j.framework.MFWGatewayImpl;
import com.cognos.mfw4j.framework.MFWGatewayReuseIndicator;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.nodeKey.MFWNodeKey;
import com.cognos.mfw4j.utilities.IMFWUsageIndicator;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.List;

public abstract class MFWGateway {
    private static final String TAG_OPEN = "MFW4j/MFWGateway/open";

    public static MFWGateway open(String aGatewayID, MFWRequestContext aContext, MFWMetadataSource aMetadataSrc) {
        MFWException.ASSERT(aContext instanceof MFWRequestContextUser, "Unexpected request context type");
        IMFWUsageIndicator xqeUsageIndicatorService = aContext.getXQEUsageIndicatorService();
        long runTime = System.currentTimeMillis();
        MFWGatewayImpl outGW = new MFWGatewayImpl(aGatewayID, (MFWRequestContextUser)aContext);
        MFW.getInstance().setupGateway(outGW, aMetadataSrc);
        long executionTime = System.currentTimeMillis() - runTime;
        if (xqeUsageIndicatorService != null) {
            xqeUsageIndicatorService.logMeasurements(TAG_OPEN, executionTime);
        }
        return outGW;
    }

    public void close() {
        MFW.getInstance().teardownGateway((MFWGatewayImpl)this);
    }

    protected MFWGateway() {
    }

    public abstract MFWRequestContext getContext();

    public abstract String getID();

    public abstract MFWNodeHandle[] query(MFWQuerySpec var1);

    public abstract String getPropertyValue(MFWNodeHandle var1);

    public abstract boolean getBooleanPropertyValue(MFWNodeHandle var1);

    public abstract int getEnumPropertyValue(MFWNodeHandle var1);

    public abstract MFWNodeHandle getReferencePropertyValue(MFWNodeHandle var1);

    public abstract MFWNodeHandle[] queryObject(MFWNodeHandle var1, MFWQuerySpec var2);

    public abstract MFWNodeHandle[] getObjectChildren(MFWNodeHandle var1, short var2);

    public abstract MFWNodeHandle[] getAllObjectChildren(MFWNodeHandle var1);

    public abstract MFWNodeHandle[] findChildObjects(MFWNodeHandle var1, short var2, short var3, String var4);

    public abstract String getObjectPropertyValue(MFWNodeHandle var1, short var2);

    public abstract boolean getObjectBooleanPropertyValue(MFWNodeHandle var1, short var2);

    public abstract int getObjectEnumPropertyValue(MFWNodeHandle var1, short var2);

    public abstract MFWNodeHandle getObjectReferencePropertyValue(MFWNodeHandle var1, short var2);

    public abstract List<String> getObjectPropertyValues(MFWNodeHandle var1, short var2);

    public abstract MFWMetadataSource getAssociatedMetadataSource(MFWNodeHandle var1);

    public abstract MFWNodeHandle[] resolveCrnID(String var1);

    public abstract MFWNodeKey getNodeKey(MFWNodeHandle var1);

    public abstract MFWNodeHandle getNodeByKey(MFWNodeKey var1);

    public abstract MFWGatewayReuseIndicator getReuseIndicator();

    public abstract MFWNodeHandle[] lookupObjectsByType(short var1);

    public abstract boolean hasUserSecurityViews();

    public abstract boolean hasRoleBasedSecurityViews();

    public abstract boolean isStale(boolean var1);

    public abstract boolean isStale(boolean var1, MFWMetadataSource var2);

    public abstract boolean isStale(boolean var1, MFWMetadataSource var2, boolean var3);
}

