/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.ArrayList;

public abstract class MFWInfo {
    public static final short NODE_TYPE_UNKNOWN = 0;
    public static final short NODE_TYPE_PROPERTY = 1;
    public static final short NODE_TYPE_OBJECT = 2;
    public static final short NODE_TYPE_LINK = 3;
    private String mName = null;
    private short mGUID;
    private short mRID;
    private ArrayList<MFWInfoObject> mParents = null;

    protected MFWInfo(String aName, short aGUID) {
        this.mName = aName.intern();
        this.mGUID = aGUID;
        this.mRID = MFWModelRes.getInstance().addResource(aName);
    }

    public abstract short getNodeType();

    public final String getName() {
        return this.mName;
    }

    public MFWInfo findChildInfo(String childName) {
        return null;
    }

    public MFWInfo findChildInfo(short childRID) {
        return null;
    }

    public final short getGUID() {
        return this.mGUID;
    }

    public final MFWInfoObject[] getParents() {
        if (this.mParents == null || this.mParents.size() == 0) {
            return null;
        }
        MFWInfoObject[] outParents = new MFWInfoObject[this.mParents.size()];
        for (int idx = 0; idx < this.mParents.size(); ++idx) {
            MFWInfoObject anInfo;
            outParents[idx] = anInfo = this.mParents.get(idx);
        }
        return outParents;
    }

    public final short getRID() {
        return this.mRID;
    }

    protected final void addParent(MFWInfoObject pParentInfo) {
        if (this.mParents == null) {
            this.mParents = new ArrayList();
        }
        this.mParents.add(pParentInfo);
    }

    void destroy() {
        if (this.mParents != null) {
            this.mParents.clear();
        }
    }

    public static MFWInfo getInfoForGUID(short guid, short eNodeType) {
        MFWInfo anInfo = MFWModel.getInstance().findInfoByGUID(guid);
        if (anInfo == null) {
            StringBuffer sMsg1 = new StringBuffer("Unable to find a valid info for GUID '");
            sMsg1.append(Integer.toString(guid));
            sMsg1.append("'.");
            MFWException.ASSERT(false, sMsg1.toString());
        }
        if (eNodeType != 0 && anInfo.getNodeType() != eNodeType) {
            StringBuffer sMsg2 = new StringBuffer("Unexpected info type for GUID '");
            sMsg2.append(Integer.toString(guid));
            sMsg2.append("' (");
            sMsg2.append(anInfo.getName());
            sMsg2.append(").");
            MFWException.ASSERT(false, sMsg2.toString());
        }
        return anInfo;
    }
}

