/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.ArrayList;

public final class MFWInfoPropertyImpl
extends MFWInfoProperty {
    private short mDataType = 1;
    private String mDefaultValue = "";
    private boolean mIsIndexed = false;
    private boolean mIsDynamic = false;
    private ArrayList<EnumerationInfo> mEnumerations = null;

    MFWInfoPropertyImpl(String aName, short aGUID) {
        super(aName, aGUID);
    }

    @Override
    public short getDataType() {
        return this.mDataType;
    }

    @Override
    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    @Override
    public boolean getDefaultBooleanValue() {
        return "true".equals(this.mDefaultValue);
    }

    @Override
    public boolean isIndexed() {
        return this.mIsIndexed;
    }

    @Override
    public boolean isDynamic() {
        return this.mIsDynamic;
    }

    void setDataType(short aDataType) {
        this.mDataType = aDataType;
    }

    void setDefaultValue(String aDefaultValue) {
        if (this.mDataType == 4) {
            MFWException.ASSERT("true".equals(aDefaultValue) || "false".equals(aDefaultValue), "Invalid default boolean value", aDefaultValue);
        } else if (this.mDataType == 2) {
            this.getEnumCode(aDefaultValue);
        }
        this.mDefaultValue = aDefaultValue;
    }

    void setIndexed(boolean bIsIndexed) {
        this.mIsIndexed = bIsIndexed;
    }

    void setDynamic(boolean bIsDynamic) {
        this.mIsDynamic = bIsDynamic;
    }

    @Override
    public int getDefaultEnumValue() {
        MFWException.ASSERT(this.mDataType == 2, "getDefaultEnumValue method is only supported for enum properties");
        EnumerationInfo enumInfo = this.findEnumerationInfo(this.mDefaultValue);
        MFWException.ASSERT(enumInfo != null, "Unable to find enumeration info for default value :", this.mDefaultValue);
        return enumInfo.mEnumNum;
    }

    void addEnumeratedValue(int enumNum, String enumLabel) {
        if (this.mEnumerations == null) {
            this.mEnumerations = new ArrayList();
        }
        this.mEnumerations.add(new EnumerationInfo(enumNum, enumLabel));
    }

    @Override
    public int getEnumCode(String enumLabel) {
        EnumerationInfo eInfo = this.findEnumerationInfo(enumLabel);
        if (eInfo == null) {
            return this.getDefaultEnumValue();
        }
        return eInfo.mEnumNum;
    }

    public String validateEnumeratedValue(int enumNum) {
        EnumerationInfo eInfo = this.findEnumerationInfo(enumNum);
        if (eInfo == null) {
            return this.getDefaultValue();
        }
        return eInfo.mEnumLabel;
    }

    private EnumerationInfo findEnumerationInfo(String enumLabel) {
        EnumerationInfo outEnumInfo = null;
        if (this.mEnumerations == null) {
            return outEnumInfo;
        }
        for (int idx = 0; outEnumInfo == null && idx < this.mEnumerations.size(); ++idx) {
            EnumerationInfo anEnumInfo = this.mEnumerations.get(idx);
            if (!anEnumInfo.mEnumLabel.equals(enumLabel)) continue;
            outEnumInfo = anEnumInfo;
        }
        return outEnumInfo;
    }

    private EnumerationInfo findEnumerationInfo(int enumCode) {
        EnumerationInfo outEnumInfo = null;
        if (this.mEnumerations == null) {
            return outEnumInfo;
        }
        for (int idx = 0; outEnumInfo == null && idx < this.mEnumerations.size(); ++idx) {
            EnumerationInfo anEnumInfo = this.mEnumerations.get(idx);
            if (anEnumInfo.mEnumNum != enumCode) continue;
            outEnumInfo = anEnumInfo;
        }
        return outEnumInfo;
    }

    @Override
    void destroy() {
        super.destroy();
        if (this.mEnumerations != null) {
            this.mEnumerations.clear();
        }
    }

    private static class EnumerationInfo {
        private String mEnumLabel;
        private int mEnumNum;

        private EnumerationInfo(int enumNum, String enumLabel) {
            this.mEnumNum = enumNum;
            this.mEnumLabel = enumLabel.intern();
        }
    }
}

