/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObjectImpl;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWNodeProperty;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.MFWXPathExpressionResult;
import com.cognos.mfw4j.framework.MFWXPathNameStep;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWMessage;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jaxen.expr.BinaryExpr;
import org.jaxen.expr.EqualityExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LiteralExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.Predicate;

public final class MFWXPathEvaluator {
    private MFWRequestContextUser mContext;
    private MFWQuerySpec mQuerySpec;

    public MFWXPathEvaluator(MFWRequestContextUser aContext) {
        this.mContext = aContext;
    }

    public void evaluate(MFWNodeObject node, MFWQuerySpec querySpec, List<MFWNode> outResults) {
        this.mQuerySpec = querySpec;
        MFWXPathNameStep currentStep = MFWXPathNameStep.getNextStep(querySpec.getRootPath(), null);
        if (MFWXPathNameStep.getNextStep(querySpec.getRootPath(), currentStep) == null) {
            this.evaluatePath(currentStep, node, outResults);
            return;
        }
        ArrayList<MFWNode> currentSet = new ArrayList<MFWNode>();
        currentSet.add(node);
        while (currentStep != null) {
            if (MFWXPathNameStep.getNextStep(querySpec.getRootPath(), currentStep) == null) {
                for (int i = 0; i < currentSet.size(); ++i) {
                    this.evaluatePath(currentStep, (MFWNode)currentSet.get(i), outResults);
                }
            } else {
                int i;
                ArrayList<MFWNode> resultSet = new ArrayList<MFWNode>();
                for (i = 0; i < currentSet.size(); ++i) {
                    this.evaluatePath(currentStep, (MFWNode)currentSet.get(i), resultSet);
                }
                currentSet.clear();
                for (i = 0; i < resultSet.size(); ++i) {
                    currentSet.add(resultSet.get(i));
                }
            }
            currentStep = MFWXPathNameStep.getNextStep(querySpec.getRootPath(), currentStep);
        }
    }

    private void evaluatePath(MFWXPathNameStep aStep, MFWNode element, List<MFWNode> resultSet) {
        if (!aStep.mIsDescendant) {
            this.selectAllChildrenWithStepPattern(aStep.mStep, element, resultSet);
        } else {
            this.selectAllDescendentWithStepPattern(aStep.mStep, element, resultSet);
        }
    }

    private MFWInfoProperty isIndexedLookup(NameStep nextNameStep, StringBuffer sValue) {
        if (!"*".equals(nextNameStep.getLocalName()) || nextNameStep.getPredicates().size() != 1) {
            return null;
        }
        Expr predExpr = ((Predicate)nextNameStep.getPredicates().get(0)).getExpr();
        if (predExpr == null || !(predExpr instanceof EqualityExpr) || !"=".equals(((EqualityExpr)predExpr).getOperator())) {
            return null;
        }
        EqualityExpr eqPredExpr = (EqualityExpr)predExpr;
        Expr predLHS = eqPredExpr.getLHS();
        Expr predRHS = eqPredExpr.getRHS();
        if (predLHS instanceof LocationPath && predRHS instanceof LiteralExpr) {
            List lhsSteps = ((LocationPath)predLHS).getSteps();
            if (lhsSteps.size() != 1 || !(lhsSteps.get(0) instanceof NameStep)) {
                return null;
            }
            NameStep lhsStep = (NameStep)lhsSteps.get(0);
            if (lhsStep.getPredicates().size() != 0) {
                return null;
            }
            MFWInfoProperty aPropInfo = (MFWInfoProperty)MFWModel.getInstance().findInfoByRID(MFWModelRes.getInstance().getResourceID(lhsStep.getLocalName()));
            if (aPropInfo != null && aPropInfo.isIndexed()) {
                String unescapeVal = MFWStringHelper.unescapeXMLChars(((LiteralExpr)predRHS).getLiteral());
                sValue.append(unescapeVal);
                return aPropInfo;
            }
        }
        return null;
    }

    private void selectAllDescendentWithStepPattern(NameStep nextNameStep, MFWNode element, List<MFWNode> resultSet) {
        MFWException.ASSERT(element instanceof MFWNodeObject, "Descendant query expects a valid object node");
        MFWNodeObject objectNode = (MFWNodeObject)element;
        this.mQuerySpec.setCurrentStep(nextNameStep);
        StringBuffer sPropValue = new StringBuffer();
        MFWInfoProperty indexedPropInfo = this.isIndexedLookup(nextNameStep, sPropValue);
        if (indexedPropInfo != null) {
            MFWNodeObject pObjNode = objectNode.getCluster().lookup(indexedPropInfo, sPropValue.toString(), this.mContext, null);
            if (pObjNode != null) {
                resultSet.add(pObjNode);
            }
        } else {
            ArrayList<MFWInfo> vIntermediateInfo = new ArrayList<MFWInfo>();
            ArrayList<MFWInfo> possibleTargets = MFWModel.getInstance().findAllInfoByRID(this.mQuerySpec.getCurrentStepPatternRID());
            for (int idx = 0; idx < possibleTargets.size(); ++idx) {
                MFWInfo anInfo = possibleTargets.get(idx);
                vIntermediateInfo.clear();
                boolean bResult = MFWModel.getInstance().canLeadTo(anInfo, objectNode.getObjectInfo(), vIntermediateInfo);
                if (!bResult) continue;
                if (nextNameStep.getPredicates().size() == 0) {
                    this.matchPathRecursively(objectNode, anInfo, vIntermediateInfo, resultSet, this.mQuerySpec.getRetrievalDepth());
                    continue;
                }
                ArrayList<MFWNode> vChildNodes = new ArrayList<MFWNode>();
                this.matchPathRecursively(objectNode, anInfo, vIntermediateInfo, vChildNodes, this.mQuerySpec.getRetrievalDepth());
                this.applyPredicate(nextNameStep, vChildNodes, resultSet);
            }
        }
    }

    private void matchPathRecursively(MFWNodeObject objParent, MFWInfo infoDescendant, ArrayList<MFWInfo> vPathInfo, List<MFWNode> outResults, int depth) {
        if (depth == 0) {
            return;
        }
        int newDepth = --depth;
        MFWInfoObjectImpl infoParent = (MFWInfoObjectImpl)objParent.getInfo();
        ArrayList<MFWNode> vChildren = new ArrayList<MFWNode>(infoParent.getChildrenSize() * 5);
        objParent.queryAllChildren(this.mContext, vChildren);
        for (int idx = 0; idx < vChildren.size(); ++idx) {
            MFWNode aChild = vChildren.get(idx);
            if (aChild.getInfo() == infoDescendant) {
                outResults.add(aChild);
            }
            if (aChild.getInfo().getNodeType() != 2 || !vPathInfo.contains(aChild.getInfo())) continue;
            this.matchPathRecursively((MFWNodeObject)aChild, infoDescendant, vPathInfo, outResults, newDepth);
        }
    }

    private void selectAllChildrenWithStepPattern(NameStep nameStep, MFWNode element, List<MFWNode> resultSet) {
        if (!element.isObject()) {
            return;
        }
        MFWNodeObject objectNode = (MFWNodeObject)element;
        switch (nameStep.getAxis()) {
            case 11: {
                resultSet.add(element);
                break;
            }
            case 3: {
                if (element.getParentObject() != null) {
                    resultSet.add(element.getParentObject());
                    break;
                }
                this.throwUnsupported("MFW_CMN_NODE_HAS_NO_PARENT");
                break;
            }
            case 1: {
                if ("*".equals(nameStep.getLocalName())) {
                    this.matchWithWildCardStepPattern(nameStep, objectNode, resultSet);
                    break;
                }
                this.matchWithSimpleStepPattern(nameStep, objectNode, resultSet);
                break;
            }
            default: {
                this.throwUnsupported("MFW_CMN_COMPLEX_STEP_PATTERNS_NOT_SUPPORTED");
            }
        }
    }

    private void matchWithWildCardStepPattern(NameStep nameStep, MFWNodeObject objectNode, List<MFWNode> resultSet) {
        this.mQuerySpec.setCurrentStep(nameStep);
        if (nameStep.getPredicates().size() == 0) {
            objectNode.queryAllChildren(this.mContext, this.mQuerySpec, resultSet);
        } else {
            ArrayList<MFWNode> vChildNodes = new ArrayList<MFWNode>();
            objectNode.queryAllChildren(this.mContext, this.mQuerySpec, vChildNodes);
            this.applyPredicate(nameStep, vChildNodes, resultSet);
        }
    }

    private void matchWithSimpleStepPattern(NameStep nameStep, MFWNodeObject objectNode, List<MFWNode> resultSet) {
        this.mQuerySpec.setCurrentStep(nameStep);
        if (nameStep.getPredicates().size() == 0) {
            objectNode.queryChild(this.mContext, this.mQuerySpec, resultSet);
        } else {
            ArrayList<MFWNode> vChildNodes = new ArrayList<MFWNode>();
            objectNode.queryChild(this.mContext, this.mQuerySpec, vChildNodes);
            this.applyPredicate(nameStep, vChildNodes, resultSet);
        }
    }

    private void applyPredicate(NameStep nameStep, List<MFWNode> vRawResults, List<MFWNode> vFinalResults) {
        if (nameStep.getPredicates().size() != 1) {
            this.throwUnsupported("MFW_CMN_MULTIPLE_PREDICATES_NOT_SUPPORTED");
        }
        Expr predExpr = ((Predicate)nameStep.getPredicates().get(0)).getExpr();
        int matchedStepIndex = 0;
        for (int i = 0; i < vRawResults.size(); ++i) {
            MFWXPathExpressionResult result = this.getExpressionResult(predExpr, vRawResults.get(i));
            switch (result.getExpressionResultType()) {
                case 0: {
                    if (!result.getBoolResult()) break;
                    vFinalResults.add(vRawResults.get(i));
                    break;
                }
                case 1: {
                    if (result.getIntResult() != matchedStepIndex) break;
                    vFinalResults.add(vRawResults.get(i));
                    break;
                }
                case 4: {
                    if (result.getPathPatternValues() == null || result.getPathPatternValues().size() <= 0) break;
                    vFinalResults.add(vRawResults.get(i));
                    break;
                }
                default: {
                    this.throwUnsupported("MFW_CMN_PREDICATE_VALUE_NOT_SUPPORTED");
                }
            }
            ++matchedStepIndex;
        }
    }

    private String calcFunctionArgument(MFWNode currNode, Expr funcArgExpr) {
        String outValue = null;
        if (funcArgExpr instanceof LiteralExpr) {
            outValue = MFWStringHelper.unescapeXMLChars(((LiteralExpr)funcArgExpr).getLiteral());
        } else if (funcArgExpr instanceof LocationPath) {
            MFWXPathExpressionResult exprResult = new MFWXPathExpressionResult();
            ArrayList<MFWNode> currentSet = new ArrayList<MFWNode>();
            currentSet.add(currNode);
            MFWXPathNameStep currStep = MFWXPathNameStep.getNextStep((LocationPath)funcArgExpr, null);
            while (currStep != null) {
                ArrayList<MFWNode> intermediateResults = new ArrayList<MFWNode>();
                for (int idx = 0; idx < currentSet.size(); ++idx) {
                    this.evaluatePath(currStep, (MFWNode)currentSet.get(idx), intermediateResults);
                }
                if ((currStep = MFWXPathNameStep.getNextStep((LocationPath)funcArgExpr, currStep)) == null) {
                    for (int i = 0; i < intermediateResults.size(); ++i) {
                        if (intermediateResults.get(i).isProperty()) {
                            MFWNodeProperty pNode = (MFWNodeProperty)intermediateResults.get(i);
                            exprResult.addPathPatternValue(pNode.getValue());
                            continue;
                        }
                        this.throwUnsupported("MFW_CMN_FUNCTION_EXPECTED_PROPERTY_ARG");
                    }
                    continue;
                }
                currentSet = intermediateResults;
            }
            Vector<String> values = exprResult.getPathPatternValues();
            if (values.size() == 1) {
                outValue = values.get(0);
            } else {
                this.throwUnsupported("MFW_CMN_FUNCTION_XPATH_TO_EVAL_TO_SINGLE_OBJECT");
            }
        }
        return outValue;
    }

    private List<String> evaluateArguments(MFWNode currNode, List arglist) {
        if (arglist != null && arglist.size() == 2) {
            ArrayList<String> outArgValues = new ArrayList<String>(2);
            String arg1Val = this.calcFunctionArgument(currNode, (Expr)arglist.get(0));
            if (arg1Val == null) {
                this.throwUnsupported("MFW_CMN_FUNCTION_FIRST_ARGUMENT_WRONG");
            } else {
                outArgValues.add(arg1Val);
            }
            String arg2Val = this.calcFunctionArgument(currNode, (Expr)arglist.get(1));
            if (arg2Val == null) {
                this.throwUnsupported("MFW_CMN_FUNCTION_SECOND_ARGUMENT_WRONG");
            } else {
                outArgValues.add(arg2Val);
            }
            return outArgValues;
        }
        this.throwUnsupported("MFW_CMN_FUNCTION_WRONG_NUMBER_ARGUMENTS");
        return null;
    }

    private MFWXPathExpressionResult handleFunction(MFWNode currNode, String functionName, List argList) {
        MFWXPathExpressionResult outResult = null;
        if ("local-name".equals(functionName)) {
            boolean bCaseSensitive = currNode.getCluster().getConnection().isCaseSensitive();
            outResult = new MFWXPathExpressionResult(currNode.getInfo().getName(), bCaseSensitive);
        } else {
            List<String> argValues = this.evaluateArguments(currNode, argList);
            String arg1Value = argValues.get(0);
            String arg2Value = argValues.get(1);
            if ("starts-with".equals(functionName)) {
                outResult = new MFWXPathExpressionResult(arg1Value.startsWith(arg2Value));
            } else if ("starts-with-nocase".equals(functionName)) {
                outResult = new MFWXPathExpressionResult(arg1Value.toLowerCase().startsWith(arg2Value.toLowerCase()));
            } else if ("ends-with".equals(functionName)) {
                outResult = new MFWXPathExpressionResult(arg1Value.endsWith(arg2Value));
            } else if ("ends-with-nocase".equals(functionName)) {
                outResult = new MFWXPathExpressionResult(arg1Value.toLowerCase().endsWith(arg2Value.toLowerCase()));
            } else if ("contains".equals(functionName)) {
                outResult = new MFWXPathExpressionResult(arg1Value.contains(arg2Value));
            } else if ("contains-nocase".equals(functionName)) {
                outResult = new MFWXPathExpressionResult(arg1Value.toLowerCase().contains(arg2Value.toLowerCase()));
            } else {
                this.throwUnsupported("XPH_PRS_FUNCTIONS_NOT_SUPPORTED");
            }
        }
        return outResult;
    }

    private MFWXPathExpressionResult getExpressionResult(Expr predExpr, MFWNode currNode) {
        MFWXPathExpressionResult outResult = null;
        if (predExpr instanceof FunctionCallExpr) {
            FunctionCallExpr predFuncCall = (FunctionCallExpr)predExpr;
            outResult = this.handleFunction(currNode, predFuncCall.getFunctionName(), predFuncCall.getParameters());
        } else if (predExpr instanceof NumberExpr) {
            Number predNum = ((NumberExpr)predExpr).getNumber();
            outResult = predNum instanceof Integer || predNum instanceof Short || predNum instanceof Double ? new MFWXPathExpressionResult(predNum.intValue()) : new MFWXPathExpressionResult(predNum.floatValue());
        } else if (predExpr instanceof LiteralExpr) {
            String unescapeVal = MFWStringHelper.unescapeXMLChars(((LiteralExpr)predExpr).getLiteral());
            boolean bCaseSensitive = currNode.getCluster().getConnection().isCaseSensitive();
            outResult = new MFWXPathExpressionResult(unescapeVal, bCaseSensitive);
        } else if (predExpr instanceof LocationPath) {
            outResult = this.getLocationPathExpressionResult((LocationPath)predExpr, currNode);
        } else if (predExpr instanceof BinaryExpr) {
            BinaryExpr predExprBin = (BinaryExpr)predExpr;
            MFWXPathExpressionResult leftExpressionResult = this.getExpressionResult(predExprBin.getLHS(), currNode);
            MFWXPathExpressionResult rightExpressionResult = this.getExpressionResult(predExprBin.getRHS(), currNode);
            boolean bCaseSensitive = currNode.getCluster().getConnection().isCaseSensitive();
            outResult = new MFWXPathExpressionResult(predExprBin.getOperator(), leftExpressionResult, rightExpressionResult, bCaseSensitive);
        } else {
            MFWException.ASSERT(false, "Unexpected predicate expression type", predExpr.getText());
        }
        return outResult;
    }

    private MFWXPathExpressionResult getLocationPathExpressionResult(LocationPath predLocPathExpr, MFWNode currNode) {
        MFWXPathExpressionResult outResult = new MFWXPathExpressionResult();
        ArrayList<MFWNode> currentSet = new ArrayList<MFWNode>();
        currentSet.add(currNode);
        MFWXPathNameStep currStep = MFWXPathNameStep.getNextStep(predLocPathExpr, null);
        while (currStep != null) {
            ArrayList<MFWNode> intermediateResults = new ArrayList<MFWNode>();
            for (int idx = 0; idx < currentSet.size(); ++idx) {
                if (((MFWNode)currentSet.get(idx)).isProperty()) {
                    intermediateResults.add((MFWNode)currentSet.get(idx));
                    continue;
                }
                this.evaluatePath(currStep, (MFWNode)currentSet.get(idx), intermediateResults);
            }
            if ((currStep = MFWXPathNameStep.getNextStep(predLocPathExpr, currStep)) == null) {
                for (int i = 0; i < intermediateResults.size(); ++i) {
                    MFWNode pNode;
                    if (intermediateResults.get(i).isProperty()) {
                        pNode = (MFWNodeProperty)intermediateResults.get(i);
                        outResult.addPathPatternValue(((MFWNodeProperty)pNode).getValue());
                        continue;
                    }
                    pNode = (MFWNodeObject)intermediateResults.get(i);
                    outResult.addPathPatternValue(pNode.getName());
                }
                continue;
            }
            currentSet = intermediateResults;
        }
        return outResult;
    }

    private void throwUnsupported(String errorCode) {
        MFWMessage errorMsg = new MFWMessage("mfw4j", errorCode, new Object[]{this.mQuerySpec.getXPathQuery()});
        MFWException exc = new MFWException();
        exc.addMessage(errorMsg);
        throw exc;
    }
}

