/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.utilities.MFWException;
import java.util.Vector;

public final class MFWXPathExpressionResult {
    public static final int eBoolType = 0;
    public static final int eIntType = 1;
    public static final int eFloatType = 2;
    public static final int eLiteralType = 3;
    public static final int ePathPatternType = 4;
    private boolean m_boolValue;
    private int m_intValue;
    private float m_floatValue;
    private String m_stringValue;
    private Vector<String> m_pathPatternValues;
    private int m_resultType;
    private boolean m_bCaseSensitive = true;

    public MFWXPathExpressionResult() {
        this.m_resultType = 4;
    }

    public MFWXPathExpressionResult(int value) {
        this.initializeAll();
        this.m_resultType = 1;
        this.m_intValue = value;
    }

    public MFWXPathExpressionResult(float value) {
        this.initializeAll();
        this.m_resultType = 2;
        this.m_floatValue = value;
    }

    public MFWXPathExpressionResult(boolean value) {
        this.initializeAll();
        this.m_resultType = 0;
        this.m_boolValue = value;
    }

    public MFWXPathExpressionResult(String value, boolean bCaseSensitive) {
        this.initializeAll();
        this.m_bCaseSensitive = bCaseSensitive;
        this.m_resultType = 3;
        this.m_stringValue = value;
    }

    public MFWXPathExpressionResult(String operatorType, MFWXPathExpressionResult leftSide, MFWXPathExpressionResult rightSide, boolean bCaseSensitive) {
        this.m_bCaseSensitive = bCaseSensitive;
        if ("=".equals(operatorType)) {
            this.handleOperatorEqual(leftSide, rightSide);
        } else if ("<".equals(operatorType)) {
            this.handleOperatorLessThan(leftSide, rightSide, false);
        } else if (">".equals(operatorType)) {
            this.handleOperatorGreaterThan(leftSide, rightSide, false);
        } else if ("!=".equals(operatorType)) {
            this.handleOperatorNotEqual(leftSide, rightSide);
        } else if ("<=".equals(operatorType)) {
            this.handleOperatorGreaterThan(leftSide, rightSide, true);
        } else if (">=".equals(operatorType)) {
            this.handleOperatorGreaterThan(leftSide, rightSide, true);
        } else if ("and".equals(operatorType)) {
            if (leftSide.m_resultType == 0 && rightSide.m_resultType == 0) {
                this.m_resultType = 0;
                this.m_boolValue = leftSide.m_boolValue && rightSide.m_boolValue;
            } else {
                this.throwUnsupported("MFWXPathExpressionResult.handleOperatorAnd");
            }
        } else if ("or".equals(operatorType)) {
            if (leftSide.m_resultType == 0 && rightSide.m_resultType == 0) {
                this.m_resultType = 0;
                this.m_boolValue = leftSide.m_boolValue || rightSide.m_boolValue;
            } else {
                this.throwUnsupported("MFWXPathExpressionResult:eOperatorOr");
            }
        } else if ("+".equals(operatorType)) {
            this.handleOperatorPlus(leftSide, rightSide);
        } else if ("-".equals(operatorType)) {
            this.handleOperatorMinus(leftSide, rightSide);
        } else if ("*".equals(operatorType)) {
            this.handleOperatorMultiply(leftSide, rightSide);
        } else if ("div".equals(operatorType)) {
            this.handleOperatorDivide(leftSide, rightSide);
        } else if ("mod".equals(operatorType)) {
            this.handleOperatorMod(leftSide, rightSide);
        } else {
            MFWException.ASSERT(false, "Unsupported predicate operator:", operatorType);
        }
    }

    private void initializeAll() {
        this.m_boolValue = false;
        this.m_intValue = 0;
        this.m_floatValue = 0.0f;
        this.m_stringValue = "";
        this.m_resultType = 0;
    }

    public void addPathPatternValue(String pathPatternValue) {
        if (this.m_pathPatternValues == null) {
            this.m_pathPatternValues = new Vector();
        }
        this.m_pathPatternValues.add(pathPatternValue);
    }

    public Vector<String> getPathPatternValues() {
        return this.m_pathPatternValues;
    }

    private void handleOperatorPlus(MFWXPathExpressionResult leftSide, MFWXPathExpressionResult rightSide) {
        if (!(leftSide.m_resultType != 2 && leftSide.m_resultType != 1 || rightSide.m_resultType != 2 && rightSide.m_resultType != 1)) {
            this.m_resultType = leftSide.m_resultType == 2 || rightSide.m_resultType == 2 ? 2 : 1;
            float leftSideVal = 1.0f;
            float rightSideVal = 1.0f;
            if (leftSide.m_resultType == 1) {
                leftSideVal = leftSide.m_intValue;
            } else if (leftSide.m_resultType == 2) {
                leftSideVal = leftSide.m_floatValue;
            }
            if (rightSide.m_resultType == 1) {
                rightSideVal = rightSide.m_intValue;
            } else if (rightSide.m_resultType == 2) {
                rightSideVal = rightSide.m_floatValue;
            }
            if (this.m_resultType == 2) {
                this.m_floatValue = leftSideVal + rightSideVal;
            } else {
                this.m_intValue = (int)(leftSideVal + rightSideVal);
            }
        } else {
            this.throwUnsupported("XPathExpressionPart::eOperatorPlus");
        }
    }

    private void handleOperatorMinus(MFWXPathExpressionResult leftSide, MFWXPathExpressionResult rightSide) {
        if (!(leftSide.m_resultType != 2 && leftSide.m_resultType != 1 || rightSide.m_resultType != 2 && rightSide.m_resultType != 1)) {
            this.m_resultType = leftSide.m_resultType == 2 || rightSide.m_resultType == 2 ? 2 : 1;
            float leftSideVal = 1.0f;
            float rightSideVal = 1.0f;
            if (leftSide.m_resultType == 1) {
                leftSideVal = leftSide.m_intValue;
            } else if (leftSide.m_resultType == 2) {
                leftSideVal = leftSide.m_floatValue;
            }
            if (rightSide.m_resultType == 1) {
                rightSideVal = rightSide.m_intValue;
            } else if (rightSide.m_resultType == 2) {
                rightSideVal = rightSide.m_floatValue;
            }
            if (this.m_resultType == 2) {
                this.m_floatValue = leftSideVal - rightSideVal;
            } else {
                this.m_intValue = (int)(leftSideVal - rightSideVal);
            }
        } else {
            this.throwUnsupported("MFWXPathExpressionResult:eOperatorMinus");
        }
    }

    private void handleOperatorMultiply(MFWXPathExpressionResult leftSide, MFWXPathExpressionResult rightSide) {
        if (!(leftSide.m_resultType != 2 && leftSide.m_resultType != 1 || rightSide.m_resultType != 2 && rightSide.m_resultType != 1)) {
            this.m_resultType = leftSide.m_resultType == 2 || rightSide.m_resultType == 2 ? 2 : 1;
            float leftSideVal = 1.0f;
            float rightSideVal = 1.0f;
            if (leftSide.m_resultType == 1) {
                leftSideVal = leftSide.m_intValue;
            } else if (leftSide.m_resultType == 2) {
                leftSideVal = leftSide.m_floatValue;
            }
            if (rightSide.m_resultType == 1) {
                rightSideVal = this.m_intValue;
            } else if (rightSide.m_resultType == 2) {
                rightSideVal = rightSide.m_floatValue;
            }
            if (this.m_resultType == 2) {
                this.m_floatValue = leftSideVal * rightSideVal;
            } else {
                this.m_intValue = (int)(leftSideVal * rightSideVal);
            }
        } else {
            this.throwUnsupported("MFWXPathExpressionResult:eOperatorMult");
        }
    }

    private void handleOperatorDivide(MFWXPathExpressionResult leftSide, MFWXPathExpressionResult rightSide) {
        if (!(leftSide.m_resultType != 2 && leftSide.m_resultType != 1 || rightSide.m_resultType != 2 && rightSide.m_resultType != 1)) {
            this.m_resultType = leftSide.m_resultType == 2 || rightSide.m_resultType == 2 ? 2 : 1;
            float leftSideVal = 1.0f;
            float rightSideVal = 1.0f;
            if (leftSide.m_resultType == 1) {
                leftSideVal = leftSide.m_intValue;
            } else if (leftSide.m_resultType == 2) {
                leftSideVal = leftSide.m_floatValue;
            }
            if (rightSide.m_resultType == 1) {
                rightSideVal = rightSide.m_intValue;
            } else if (rightSide.m_resultType == 2) {
                rightSideVal = rightSide.m_floatValue;
            }
            if (this.m_resultType == 2) {
                this.m_floatValue = leftSideVal / rightSideVal;
            } else {
                this.m_intValue = (int)(leftSideVal / rightSideVal);
            }
        } else {
            this.throwUnsupported("MFWXPathExpressionResult:eOperatorDiv");
        }
    }

    private void handleOperatorMod(MFWXPathExpressionResult leftSide, MFWXPathExpressionResult rightSide) {
        if (!(leftSide.m_resultType != 2 && leftSide.m_resultType != 1 || rightSide.m_resultType != 2 && rightSide.m_resultType != 1)) {
            this.m_resultType = leftSide.m_resultType == 2 || rightSide.m_resultType == 2 ? 2 : 1;
            float leftSideVal = 1.0f;
            float rightSideVal = 1.0f;
            if (leftSide.m_resultType == 1) {
                leftSideVal = leftSide.m_intValue;
            } else if (leftSide.m_resultType == 2) {
                leftSideVal = leftSide.m_floatValue;
            }
            if (rightSide.m_resultType == 1) {
                rightSideVal = rightSide.m_intValue;
            } else if (rightSide.m_resultType == 2) {
                rightSideVal = rightSide.m_floatValue;
            }
            this.m_intValue = (int)leftSideVal % (int)rightSideVal;
        } else {
            this.throwUnsupported("MFWXPathExpressionResult:eOperatorMod");
        }
    }

    private void handleOperatorGreaterThan(MFWXPathExpressionResult leftSide, MFWXPathExpressionResult rightSide, boolean orEqual) {
        this.m_resultType = 0;
        this.m_boolValue = false;
        if (leftSide.m_resultType == 4) {
            Vector<String> pathPatternValues = leftSide.getPathPatternValues();
            if (pathPatternValues == null) {
                return;
            }
            if (rightSide.m_resultType == 1) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    int parsedNum = Integer.parseInt(pathPatternValues.elementAt(i).toString());
                    if (parsedNum <= rightSide.m_intValue && (!orEqual || parsedNum != rightSide.m_intValue)) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (rightSide.m_resultType == 2) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    float parsedNum = Float.parseFloat(pathPatternValues.elementAt(i).toString());
                    if (!(parsedNum > rightSide.m_floatValue) && (!orEqual || parsedNum != rightSide.m_floatValue)) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (rightSide.m_resultType == 4) {
                Vector<String> rightPatternValues = rightSide.getPathPatternValues();
                block2: for (int i = 0; rightPatternValues != null && i < pathPatternValues.size(); ++i) {
                    for (int j = 0; j < rightPatternValues.size(); ++j) {
                        int compareToVal = pathPatternValues.get(i).toString().compareTo(rightPatternValues.get(i).toString());
                        if (compareToVal <= 0 && (!orEqual || compareToVal != 0)) continue;
                        this.m_boolValue = true;
                        continue block2;
                    }
                }
            }
        } else if (rightSide.m_resultType == 4) {
            Vector<String> pathPatternValues = rightSide.getPathPatternValues();
            if (pathPatternValues == null) {
                return;
            }
            if (leftSide.m_resultType == 1) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    int parsedNum = Integer.parseInt(pathPatternValues.get(i).toString());
                    if (leftSide.m_intValue <= parsedNum && (!orEqual || leftSide.m_intValue != parsedNum)) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (leftSide.m_resultType == 2) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    float parsedNum = Float.parseFloat(pathPatternValues.get(i).toString());
                    if (!(leftSide.m_floatValue > parsedNum) && (!orEqual || leftSide.m_floatValue != parsedNum)) continue;
                    this.m_boolValue = true;
                    break;
                }
            }
        } else {
            float leftSideVal = 1.0f;
            float rightSideVal = 1.0f;
            if (leftSide.m_resultType == 1) {
                leftSideVal = leftSide.m_intValue;
            } else if (leftSide.m_resultType == 2) {
                leftSideVal = leftSide.m_floatValue;
            } else {
                this.throwUnsupported("MFWXPathExpressionResult::handleOperatorGreaterThan");
            }
            if (rightSide.m_resultType == 1) {
                rightSideVal = rightSide.m_intValue;
            } else if (rightSide.m_resultType == 2) {
                rightSideVal = rightSide.m_floatValue;
            } else {
                this.throwUnsupported("MFWXPathExpressionResult::handleOperatorGreaterThan");
            }
            this.m_boolValue = leftSideVal > rightSideVal || orEqual && leftSideVal == rightSideVal;
        }
    }

    private void handleOperatorLessThan(MFWXPathExpressionResult leftSide, MFWXPathExpressionResult rightSide, boolean orEqual) {
        this.m_resultType = 0;
        this.m_boolValue = false;
        if (leftSide.m_resultType == 4) {
            Vector<String> pathPatternValues = leftSide.getPathPatternValues();
            if (pathPatternValues == null) {
                return;
            }
            if (rightSide.m_resultType == 1) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    int parsedNum = Integer.parseInt(pathPatternValues.get(i).toString());
                    if (parsedNum >= rightSide.m_intValue && (!orEqual || parsedNum != rightSide.m_intValue)) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (rightSide.m_resultType == 2) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    float parsedNum = Float.parseFloat(pathPatternValues.get(i).toString());
                    if (!(parsedNum < rightSide.m_floatValue) && (!orEqual || parsedNum != rightSide.m_floatValue)) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (rightSide.m_resultType == 4) {
                Vector<String> rightPatternValues = rightSide.getPathPatternValues();
                block2: for (int i = 0; rightPatternValues != null && i < pathPatternValues.size(); ++i) {
                    for (int j = 0; j < rightPatternValues.size(); ++j) {
                        int compareToVal = pathPatternValues.get(i).toString().compareTo(rightPatternValues.get(i).toString());
                        if (compareToVal >= 0 && (!orEqual || compareToVal != 0)) continue;
                        this.m_boolValue = true;
                        continue block2;
                    }
                }
            }
        } else if (rightSide.m_resultType == 4) {
            Vector<String> pathPatternValues = rightSide.getPathPatternValues();
            if (pathPatternValues == null) {
                return;
            }
            if (leftSide.m_resultType == 1) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    int parsedNum = Integer.parseInt(pathPatternValues.elementAt(i));
                    if (leftSide.m_intValue >= parsedNum && (!orEqual || leftSide.m_intValue != parsedNum)) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (leftSide.m_resultType == 2) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    float parsedNum = Float.parseFloat(pathPatternValues.elementAt(i));
                    if (!(leftSide.m_floatValue < parsedNum) && (!orEqual || leftSide.m_floatValue != parsedNum)) continue;
                    this.m_boolValue = true;
                    break;
                }
            }
        } else {
            float leftSideVal = 1.0f;
            float rightSideVal = 1.0f;
            if (leftSide.m_resultType == 1) {
                leftSideVal = leftSide.m_intValue;
            } else if (leftSide.m_resultType == 2) {
                leftSideVal = leftSide.m_floatValue;
            } else {
                this.throwUnsupported("MFWXPathExpressionResult::handleOperatorGreaterThan");
            }
            if (rightSide.m_resultType == 1) {
                rightSideVal = rightSide.m_intValue;
            } else if (rightSide.m_resultType == 2) {
                rightSideVal = rightSide.m_floatValue;
            } else {
                this.throwUnsupported("MFWXPathExpressionResult::handleOperatorGreaterThan");
            }
            this.m_boolValue = leftSideVal < rightSideVal || orEqual && leftSideVal == rightSideVal;
        }
    }

    private void handleOperatorNotEqual(MFWXPathExpressionResult leftSide, MFWXPathExpressionResult rightSide) {
        if (leftSide.m_resultType == 4) {
            this.m_resultType = 0;
            this.m_boolValue = false;
            Vector<String> pathPatternValues = leftSide.getPathPatternValues();
            if (pathPatternValues == null) {
                return;
            }
            if (rightSide.m_resultType == 1) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    int parsedNum = Integer.parseInt(pathPatternValues.elementAt(i));
                    if (parsedNum == rightSide.m_intValue) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (rightSide.m_resultType == 2) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    float parsedNum = Float.parseFloat(pathPatternValues.elementAt(i));
                    if (parsedNum == rightSide.m_floatValue) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (rightSide.m_resultType == 3) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    if (!(this.m_bCaseSensitive ? !pathPatternValues.elementAt(i).equals(rightSide.m_stringValue) : !pathPatternValues.elementAt(i).equalsIgnoreCase(rightSide.m_stringValue))) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (rightSide.m_resultType == 4) {
                Vector<String> rightPatternValues = rightSide.getPathPatternValues();
                block3: for (int i = 0; rightPatternValues != null && i < pathPatternValues.size(); ++i) {
                    for (int j = 0; j < rightPatternValues.size(); ++j) {
                        if (pathPatternValues.elementAt(i).equals(rightPatternValues.elementAt(j))) continue;
                        this.m_boolValue = true;
                        continue block3;
                    }
                }
            }
        } else if (rightSide.m_resultType == 4) {
            this.m_resultType = 0;
            this.m_boolValue = false;
            Vector<String> pathPatternValues = rightSide.getPathPatternValues();
            if (pathPatternValues == null) {
                return;
            }
            if (leftSide.m_resultType == 1) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    int parsedNum = Integer.parseInt(pathPatternValues.elementAt(i).toString());
                    if (parsedNum == leftSide.m_intValue) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (leftSide.m_resultType == 2) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    float parsedNum = Float.parseFloat(pathPatternValues.elementAt(i).toString());
                    if (parsedNum == (float)leftSide.m_intValue) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (leftSide.m_resultType == 3) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    if (!(this.m_bCaseSensitive ? !pathPatternValues.elementAt(i).equals(leftSide.m_stringValue) : !pathPatternValues.elementAt(i).equalsIgnoreCase(leftSide.m_stringValue))) continue;
                    this.m_boolValue = true;
                    break;
                }
            }
        } else if (!(leftSide.m_resultType != 2 && leftSide.m_resultType != 1 || rightSide.m_resultType != 2 && rightSide.m_resultType != 1)) {
            this.m_resultType = 0;
            float leftSideVal = 1.0f;
            float rightSideVal = 1.0f;
            if (leftSide.m_resultType == 1) {
                leftSideVal = leftSide.m_intValue;
            } else if (leftSide.m_resultType == 2) {
                leftSideVal = leftSide.m_floatValue;
            }
            if (rightSide.m_resultType == 1) {
                rightSideVal = rightSide.m_intValue;
            } else if (rightSide.m_resultType == 2) {
                rightSideVal = rightSide.m_floatValue;
            }
            this.m_boolValue = leftSideVal != rightSideVal;
        } else if (leftSide.m_resultType == 3 && rightSide.m_resultType == 3) {
            this.m_resultType = 0;
            this.m_boolValue = leftSide.m_stringValue != rightSide.m_stringValue;
        } else if (leftSide.m_resultType == 0 && rightSide.m_resultType == 0) {
            this.m_resultType = 0;
            this.m_boolValue = leftSide.m_boolValue != rightSide.m_boolValue;
        } else {
            this.throwUnsupported("MFWXPathExpressionResult::handleOperatorNotEqual");
        }
    }

    private void handleOperatorEqual(MFWXPathExpressionResult leftSide, MFWXPathExpressionResult rightSide) {
        if (leftSide.m_resultType == 4) {
            this.m_resultType = 0;
            this.m_boolValue = false;
            Vector<String> pathPatternValues = leftSide.getPathPatternValues();
            if (pathPatternValues == null) {
                return;
            }
            if (rightSide.m_resultType == 1) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    int parsedNum = Integer.parseInt(pathPatternValues.elementAt(i));
                    if (parsedNum != rightSide.m_intValue) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (rightSide.m_resultType == 2) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    float parsedNum = Float.parseFloat(pathPatternValues.elementAt(i));
                    if (parsedNum != rightSide.m_floatValue) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (rightSide.m_resultType == 3) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    if (!(this.m_bCaseSensitive ? pathPatternValues.elementAt(i).equals(rightSide.m_stringValue) : pathPatternValues.elementAt(i).equalsIgnoreCase(rightSide.m_stringValue))) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (rightSide.m_resultType == 4) {
                Vector<String> rightPatternValues = rightSide.getPathPatternValues();
                block3: for (int i = 0; rightPatternValues != null && i < pathPatternValues.size(); ++i) {
                    for (int j = 0; j < rightPatternValues.size(); ++j) {
                        if (!pathPatternValues.elementAt(i).equals(rightPatternValues.elementAt(j))) continue;
                        this.m_boolValue = true;
                        continue block3;
                    }
                }
            }
        } else if (rightSide.m_resultType == 4) {
            this.m_resultType = 0;
            this.m_boolValue = false;
            Vector<String> pathPatternValues = rightSide.getPathPatternValues();
            if (pathPatternValues == null) {
                return;
            }
            if (leftSide.m_resultType == 1) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    int parsedNum = Integer.parseInt(pathPatternValues.elementAt(i).toString());
                    if (parsedNum != leftSide.m_intValue) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (leftSide.m_resultType == 2) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    float parsedNum = Float.parseFloat(pathPatternValues.elementAt(i).toString());
                    if (parsedNum != (float)leftSide.m_intValue) continue;
                    this.m_boolValue = true;
                    break;
                }
            } else if (leftSide.m_resultType == 3) {
                for (int i = 0; i < pathPatternValues.size(); ++i) {
                    if (!(this.m_bCaseSensitive ? pathPatternValues.elementAt(i).equals(leftSide.m_stringValue) : pathPatternValues.elementAt(i).equalsIgnoreCase(leftSide.m_stringValue))) continue;
                    this.m_boolValue = true;
                    break;
                }
            }
        } else if (!(leftSide.m_resultType != 2 && leftSide.m_resultType != 1 || rightSide.m_resultType != 2 && rightSide.m_resultType != 1)) {
            this.m_resultType = 0;
            float leftSideVal = 1.0f;
            float rightSideVal = 1.0f;
            if (leftSide.m_resultType == 1) {
                leftSideVal = leftSide.m_intValue;
            } else if (leftSide.m_resultType == 2) {
                leftSideVal = leftSide.m_floatValue;
            }
            if (rightSide.m_resultType == 1) {
                rightSideVal = rightSide.m_intValue;
            } else if (rightSide.m_resultType == 2) {
                rightSideVal = rightSide.m_floatValue;
            }
            this.m_boolValue = leftSideVal == rightSideVal;
        } else if (leftSide.m_resultType == 3 && rightSide.m_resultType == 3) {
            this.m_resultType = 0;
            this.m_boolValue = leftSide.m_stringValue == null ? leftSide.m_stringValue == rightSide.m_stringValue : leftSide.m_stringValue.equals(rightSide.m_stringValue);
        } else if (leftSide.m_resultType == 0 && rightSide.m_resultType == 0) {
            this.m_resultType = 0;
            this.m_boolValue = leftSide.m_boolValue == rightSide.m_boolValue;
        } else {
            this.throwUnsupported("MFWXPathExpressionResult::handleOperatorEqual");
        }
    }

    public boolean getBoolResult() {
        return this.m_boolValue;
    }

    public int getIntResult() {
        return this.m_intValue;
    }

    public float getFloatResult() {
        return this.m_floatValue;
    }

    public String getStringResult() {
        return this.m_stringValue;
    }

    public int getExpressionResultType() {
        return this.m_resultType;
    }

    private void throwUnsupported(String location) {
        throw new RuntimeException(location);
    }
}

