/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.implHeap;

import com.cognos.mfw4j.framework.MFWIndexManager;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWNodeObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class MFWIndexManagerHeap
implements MFWIndexManager {
    Object mLock = new Object();
    HashMap<MFWInfoProperty, HashMap<String, MFWNodeObject>> mProp2IndexMap = new HashMap(2);
    HashMap<Short, ArrayList<MFWNodeObject>> mType2InstancesMap = new HashMap(10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToIndex(MFWInfoProperty indexPropInfo, MFWNodeObject indexObjNode, String indexValue) {
        Object object = this.mLock;
        synchronized (object) {
            HashMap<String, MFWNodeObject> anIndex = this.mProp2IndexMap.get(indexPropInfo);
            if (anIndex == null) {
                anIndex = new HashMap(200);
                this.mProp2IndexMap.put(indexPropInfo, anIndex);
            }
            anIndex.put(indexValue, indexObjNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MFWNodeObject lookup(MFWInfoProperty indexPropInfo, String value) {
        MFWNodeObject objNode = null;
        Object object = this.mLock;
        synchronized (object) {
            HashMap<String, MFWNodeObject> anIndex = this.mProp2IndexMap.get(indexPropInfo);
            if (anIndex != null) {
                objNode = anIndex.get(value);
            }
        }
        return objNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromIndex(MFWInfoProperty indexPropInfo, String indexValue) {
        Object object = this.mLock;
        synchronized (object) {
            HashMap<String, MFWNodeObject> anIndex = this.mProp2IndexMap.get(indexPropInfo);
            if (anIndex != null) {
                anIndex.remove(indexValue);
            }
        }
    }

    @Override
    public void destroy() {
        for (HashMap<String, MFWNodeObject> anIndex : this.mProp2IndexMap.values()) {
            anIndex.clear();
        }
        this.mProp2IndexMap.clear();
        this.mProp2IndexMap = null;
        for (ArrayList<MFWNodeObject> aList : this.mType2InstancesMap.values()) {
            aList.clear();
        }
        this.mType2InstancesMap.clear();
        this.mType2InstancesMap = null;
        this.mLock = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexObject(MFWNodeObject anObj) {
        Object object = this.mLock;
        synchronized (object) {
            Short typekey = anObj.getInfo().getGUID();
            ArrayList<MFWNodeObject> objList = this.mType2InstancesMap.get(typekey);
            if (objList == null) {
                objList = new ArrayList(100);
                this.mType2InstancesMap.put(typekey, objList);
            }
            objList.add(anObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lookupObjectsByType(short guid, List<MFWNodeObject> outObjs) {
        Object object = this.mLock;
        synchronized (object) {
            Short typekey = guid;
            ArrayList<MFWNodeObject> objList = this.mType2InstancesMap.get(typekey);
            if (objList != null) {
                outObjs.addAll(objList);
            }
        }
    }
}

