/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.implHeap;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoObjectImpl;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWInfoPropertyImpl;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeLink;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWNodeObjectRoot;
import com.cognos.mfw4j.framework.MFWNodeProperty;
import com.cognos.mfw4j.framework.MFWNodePropertyDynamic;
import com.cognos.mfw4j.framework.MFWNodePropertyInt;
import com.cognos.mfw4j.framework.MFWNodePropertyString;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.implHeap.MFWIndexManagerHeap;
import com.cognos.mfw4j.framework.implHeap.MFWNodeLinkHeap;
import com.cognos.mfw4j.framework.implHeap.MFWNodeObjectHeapExpandable;
import com.cognos.mfw4j.framework.implHeap.MFWStringPoolHeap;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.ArrayList;
import java.util.List;

class MFWNodeObjectHeap
extends MFWNodeObject {
    private MFWNodeObject mParent = null;
    protected MFWInfoObjectImpl mInfo = null;
    protected ArrayList<MFWNode> mChildObjects = null;
    protected Object[] mPropertySlots = null;

    MFWNodeObjectHeap(MFWNodeObjectHeap objParent, MFWInfoObjectImpl objInfo) {
        this.mParent = objParent;
        this.mInfo = objInfo;
        this.mChildObjects = new ArrayList(this.mInfo.getInitialChildrenListSize());
        this.mPropertySlots = new Object[objInfo.getNumberOfChildProperties()];
    }

    @Override
    public MFWNodeObject getParentObject() {
        return this.mParent;
    }

    @Override
    public MFWCluster getCluster() {
        MFWNodeObjectRoot myRoot = MFWNode.walkupToRoot(this);
        return myRoot.getOwnerCluster();
    }

    @Override
    public void destroy() {
        this.mParent = null;
        for (int idx = 0; idx < this.mChildObjects.size(); ++idx) {
            MFWNode aChild = this.mChildObjects.get(idx);
            aChild.destroy();
        }
        this.mChildObjects.clear();
        for (MFWInfoObjectImpl.ChildInfo aChildInfo : this.mInfo.getDetailedChildrenInfo()) {
            ArrayList propInstances;
            if (aChildInfo.getInfo().getNodeType() != 1 || aChildInfo.hasSingleMultiplicity() || (propInstances = (ArrayList)this.mPropertySlots[aChildInfo.getPropertyIndex()]) == null) continue;
            propInstances.clear();
        }
        this.mPropertySlots = null;
        this.mInfo = null;
        super.destroy();
    }

    @Override
    public void reserveChildren(short ridChildName, int initialSize) {
        if (initialSize <= 0) {
            return;
        }
        MFWInfoObjectImpl.ChildInfo childInfo = this.mInfo.findDetailedChildInfo(ridChildName);
        if (childInfo.getInfo().getNodeType() != 1) {
            return;
        }
        if (this.mPropertySlots[childInfo.getPropertyIndex()] == null && !childInfo.hasSingleMultiplicity()) {
            this.mPropertySlots[childInfo.getPropertyIndex()] = new ArrayList(initialSize);
        }
    }

    @Override
    public final MFWInfoObject getObjectInfo() {
        return this.mInfo;
    }

    @Override
    public final List<MFWNode> getChildNodes() {
        ArrayList<MFWNode> outList = new ArrayList<MFWNode>(this.mChildObjects.size() + this.mPropertySlots.length);
        for (MFWInfoObjectImpl.ChildInfo aChildInfo : this.mInfo.getDetailedChildrenInfo()) {
            Object[] pValues;
            if (aChildInfo.getInfo().getNodeType() != 1 || (pValues = this.retrieveProperties(aChildInfo, false)) == null) continue;
            for (int idx = 0; idx < pValues.length; ++idx) {
                outList.add(this.makePropertyNode((MFWInfoPropertyImpl)aChildInfo.getInfo(), pValues[idx]));
            }
        }
        outList.addAll(this.mChildObjects);
        return outList;
    }

    @Override
    public final List<String> getPropertyValues(short ridPropName) {
        ArrayList<String> outValues = null;
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        Object[] pValues = this.retrieveProperties(childInfo, false);
        if (pValues == null) {
            return null;
        }
        outValues = new ArrayList<String>(pValues.length);
        for (int idx = 0; idx < pValues.length; ++idx) {
            String aValue = this.calculateStringValue((MFWInfoPropertyImpl)childInfo.getInfo(), pValues[idx]);
            outValues.add(aValue);
        }
        return outValues;
    }

    @Override
    public final String getPropertyValue(short ridPropName) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        Object[] pValues = this.retrieveProperties(childInfo, true);
        if (pValues == null) {
            return null;
        }
        return this.calculateStringValue((MFWInfoPropertyImpl)childInfo.getInfo(), pValues[0]);
    }

    @Override
    public final boolean getBooleanPropertyValue(short ridPropName) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        MFWException.ASSERT(((MFWInfoProperty)childInfo.getInfo()).getDataType() == 4, "adding boolean Value is supported only for boolean properties");
        Object[] pValues = this.retrieveProperties(childInfo, true);
        if (pValues == null) {
            return false;
        }
        return (Integer)pValues[0] == 1;
    }

    @Override
    public final int getEnumPropertyValue(short ridPropName) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        MFWException.ASSERT(((MFWInfoProperty)childInfo.getInfo()).getDataType() == 2, "adding enum Value is supported only for enumerated properties");
        Object[] pValues = this.retrieveProperties(childInfo, true);
        if (pValues == null) {
            return 0;
        }
        return (Integer)pValues[0];
    }

    @Override
    public final void addProperty(short ridPropName, String sValue) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        Object propValue = this.calculatePersistentValue((MFWInfoPropertyImpl)childInfo.getInfo(), sValue);
        this.persistProperty(childInfo, propValue);
    }

    @Override
    public final void addProperty(short ridPropName, boolean bValue) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        MFWException.ASSERT(((MFWInfoProperty)childInfo.getInfo()).getDataType() == 4, "adding boolean Value is supported only for boolean properties");
        this.persistProperty(childInfo, bValue ? 1 : 0);
    }

    @Override
    public final void addProperty(short ridPropName, int iValue) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        MFWException.ASSERT(((MFWInfoProperty)childInfo.getInfo()).getDataType() == 2, "adding enum Value is supported only for enumerated properties");
        this.persistProperty(childInfo, iValue);
    }

    @Override
    public final List<MFWNode> getObjectNodes(short ridObjName) {
        MFWInfoObjectImpl.ChildInfo detailedInfo = this.validateChild(ridObjName, (short)2);
        ArrayList<MFWNode> outResults = new ArrayList<MFWNode>();
        this.getChildObjects(detailedInfo, outResults);
        return outResults;
    }

    @Override
    public final MFWNodeObject getObjectNode(short ridObjName) {
        MFWInfoObjectImpl.ChildInfo detailedInfo = this.validateChild(ridObjName, (short)2);
        return (MFWNodeObject)this.getFirstChildObject(detailedInfo);
    }

    @Override
    public final MFWNodeObject addObjectNode(short ridObjName) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridObjName, (short)2);
        MFWNodeObjectHeap newObj = new MFWNodeObjectHeap(this, (MFWInfoObjectImpl)childInfo.getInfo());
        this.updateAllChildrenList(newObj);
        this.setExpandStatus(ridObjName, (byte)1);
        if (((MFWInfoObjectImpl)childInfo.getInfo()).isIndexed()) {
            MFWCluster ownerCluster = this.getCluster();
            ownerCluster.getIndexManager().indexObject(newObj);
        }
        return newObj;
    }

    @Override
    public final MFWNodeObject addExpandableObjectNode(short ridObjName) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridObjName, (short)2);
        MFWNodeObjectHeapExpandable newObj = new MFWNodeObjectHeapExpandable(this, (MFWInfoObjectImpl)childInfo.getInfo());
        this.updateAllChildrenList(newObj);
        this.setExpandStatus(ridObjName, (byte)1);
        if (((MFWInfoObjectImpl)childInfo.getInfo()).isIndexed()) {
            MFWCluster ownerCluster = this.getCluster();
            ownerCluster.getIndexManager().indexObject(newObj);
        }
        return newObj;
    }

    @Override
    public final void addLinkNode(short ridChildName, short idLinkSrc, String queryPath) {
        this.validateChild(ridChildName, (short)0);
        MFWNodeLinkHeap newLink = new MFWNodeLinkHeap(this, ridChildName, idLinkSrc, queryPath);
        this.updateAllChildrenList(newLink);
    }

    @Override
    public List<MFWNodeLink> getLinkNodes() {
        ArrayList<MFWNodeLink> outResults = null;
        for (MFWNode aChildNode : this.mChildObjects) {
            if (aChildNode.getInfo().getNodeType() != 3) continue;
            if (outResults == null) {
                outResults = new ArrayList<MFWNodeLink>();
            }
            outResults.add((MFWNodeLink)aChildNode);
        }
        return outResults;
    }

    @Override
    public final void removeChildNode(MFWNode childNode) {
        MFWException.ASSERT(childNode.isObject(), "Removing non-object nodes is not supported for heap implementation of MFW objects");
        int nodeIndex = this.mChildObjects.indexOf(childNode);
        MFWException.ASSERT(nodeIndex >= 0, "Failed to locate the remove node in the list of children, trying to remove a node of type ", childNode.getName());
        this.mChildObjects.remove(nodeIndex);
    }

    @Override
    public byte getExpandStatus(short ridChildName) {
        return 1;
    }

    @Override
    public void setExpandStatus(short ridChildName, byte expandStat) {
    }

    @Override
    public Object getExpandLock() {
        return null;
    }

    @Override
    protected void queryChild(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, List<MFWNode> outResults) {
        short ridChildName = aQuerySpec.getCurrentStepPatternRID();
        MFWInfoObjectImpl.ChildInfo detailedInfo = this.validateChild(ridChildName, (short)0);
        this.queryChildInstances(aContext, detailedInfo, aQuerySpec, outResults);
    }

    @Override
    protected void queryChild(MFWRequestContextUser aContext, short ridChildName, List<MFWNode> outResults) {
        MFWInfoObjectImpl.ChildInfo detailedInfo = this.validateChild(ridChildName, (short)0);
        this.queryChildInstances(aContext, detailedInfo, null, outResults);
    }

    @Override
    protected MFWNode querySingleChild(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec) {
        short ridChildName = aQuerySpec.getCurrentStepPatternRID();
        return this.querySingleChild(aContext, ridChildName);
    }

    @Override
    protected MFWNode querySingleChild(MFWRequestContextUser aContext, short ridChildName) {
        MFWNode outNode = null;
        MFWInfoObjectImpl.ChildInfo detailedInfo = this.validateChild(ridChildName, (short)0);
        outNode = this.querySingleChildInstance(aContext, detailedInfo);
        return outNode;
    }

    @Override
    protected void queryAllChildren(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, List<MFWNode> outResults) {
        this.queryAllChildren(aContext, outResults);
    }

    @Override
    protected void queryAllChildren(MFWRequestContextUser aContext, List<MFWNode> outResults) {
        MFWInfoObjectImpl myInfo = (MFWInfoObjectImpl)this.getObjectInfo();
        for (MFWInfoObjectImpl.ChildInfo aChildInfo : myInfo.getDetailedChildrenInfo()) {
            Object[] pValues;
            if (aChildInfo.getInfo().getNodeType() != 1 || (pValues = this.retrieveProperties(aChildInfo, false)) == null) continue;
            for (int idx = 0; idx < pValues.length; ++idx) {
                outResults.add(this.makePropertyNode((MFWInfoPropertyImpl)aChildInfo.getInfo(), pValues[idx]));
            }
        }
        MFWCluster ownerCluster = this.getCluster();
        for (MFWNode aChildNode : this.mChildObjects) {
            if (aChildNode.getInfo().getNodeType() == 3) {
                ((MFWNodeLink)aChildNode).getLinkedNodes(ownerCluster, aContext, null, outResults);
                continue;
            }
            outResults.add(aChildNode);
        }
    }

    protected final void queryChildInstances(MFWRequestContextUser aContext, MFWInfoObjectImpl.ChildInfo childInfo, MFWQuerySpec aQuerySpec, List<MFWNode> outResults) {
        if (childInfo.getInfo().getNodeType() == 1) {
            MFWInfoPropertyImpl propInfo = (MFWInfoPropertyImpl)childInfo.getInfo();
            if (propInfo.isDynamic()) {
                outResults.add(new MFWNodePropertyDynamic(this, (MFWInfoPropertyImpl)childInfo.getInfo(), aContext, this.getCluster().getConnection()));
                return;
            }
            Object[] pValues = this.retrieveProperties(childInfo, false);
            if (pValues == null) {
                MFWNodeProperty defNode = MFWNodeProperty.makeDefaultPropertyNode(this, childInfo);
                if (defNode != null) {
                    outResults.add(defNode);
                }
                return;
            }
            for (int idx = 0; idx < pValues.length; ++idx) {
                outResults.add(this.makePropertyNode(propInfo, pValues[idx]));
            }
        } else {
            MFWCluster ownerCluster = this.getCluster();
            for (MFWNode aChildNode : this.mChildObjects) {
                MFWInfo aChildInfo = aChildNode.getInfo();
                if (aChildInfo.getNodeType() == 3) {
                    MFWNodeLinkHeap aChildLinkNode = (MFWNodeLinkHeap)aChildNode;
                    if (childInfo.getInfo().getRID() != aChildLinkNode.getLinkChildRID()) continue;
                    aChildLinkNode.getLinkedNodes(ownerCluster, aContext, aQuerySpec, outResults);
                    continue;
                }
                if (childInfo.getInfo().getRID() != aChildInfo.getRID()) continue;
                outResults.add(aChildNode);
            }
        }
    }

    protected final MFWNode querySingleChildInstance(MFWRequestContextUser aContext, MFWInfoObjectImpl.ChildInfo childInfo) {
        if (childInfo.getInfo().getNodeType() == 1) {
            MFWInfoPropertyImpl propInfo = (MFWInfoPropertyImpl)childInfo.getInfo();
            if (propInfo.isDynamic()) {
                return new MFWNodePropertyDynamic(this, (MFWInfoPropertyImpl)childInfo.getInfo(), aContext, this.getCluster().getConnection());
            }
            Object[] pValues = this.retrieveProperties(childInfo, true);
            if (pValues == null) {
                return MFWNodeProperty.makeDefaultPropertyNode(this, childInfo);
            }
            return this.makePropertyNode(propInfo, pValues[0]);
        }
        MFWCluster ownerCluster = this.getCluster();
        for (MFWNode aChildNode : this.mChildObjects) {
            MFWInfo aChildInfo = aChildNode.getInfo();
            if (aChildInfo.getNodeType() == 3) {
                MFWNodeLinkHeap aChildLinkNode = (MFWNodeLinkHeap)aChildNode;
                if (childInfo.getInfo().getRID() != aChildLinkNode.getLinkChildRID()) continue;
                ArrayList<MFWNode> outResults = new ArrayList<MFWNode>();
                aChildLinkNode.getLinkedNodes(ownerCluster, aContext, null, outResults);
                if (outResults.size() <= 0) continue;
                return outResults.get(0);
            }
            if (childInfo.getInfo().getRID() != aChildInfo.getRID()) continue;
            return aChildNode;
        }
        return null;
    }

    private String calculateStringValue(MFWInfoPropertyImpl propInfo, Object prstValue) {
        String sValue = null;
        switch (propInfo.getDataType()) {
            case 2: {
                sValue = propInfo.validateEnumeratedValue((Integer)prstValue);
                break;
            }
            case 4: {
                sValue = (Integer)prstValue == 1 ? "true" : "false";
                break;
            }
            default: {
                sValue = (String)prstValue;
            }
        }
        return sValue;
    }

    private Object[] retrieveProperties(MFWInfoObjectImpl.ChildInfo childInfo, boolean bOnlyFirst) {
        Object[] outValues = null;
        Object childSlotValue = this.mPropertySlots[childInfo.getPropertyIndex()];
        if (childSlotValue == null) {
            return null;
        }
        if (childInfo.hasSingleMultiplicity()) {
            outValues = new Object[]{childSlotValue};
        } else {
            ArrayList propInstances = (ArrayList)childSlotValue;
            outValues = new Object[bOnlyFirst ? 1 : propInstances.size()];
            for (int idx = 0; idx < outValues.length; ++idx) {
                outValues[idx] = propInstances.get(idx);
            }
        }
        return outValues;
    }

    private Object calculatePersistentValue(MFWInfoPropertyImpl propInfo, String sValue) {
        if (sValue == null) {
            return null;
        }
        Object pValue = null;
        switch (propInfo.getDataType()) {
            case 2: {
                pValue = propInfo.getEnumCode(sValue);
                break;
            }
            case 4: {
                pValue = "true".equals(sValue) ? 1 : 0;
                break;
            }
            default: {
                MFWCluster ownerCluster = this.getCluster();
                MFWStringPoolHeap myPool = (MFWStringPoolHeap)ownerCluster.getStringPool();
                Object object = pValue = sValue.length() > 10 ? myPool.poolString(sValue) : sValue.intern();
                if (!propInfo.isIndexed() || sValue.length() <= 0) break;
                ((MFWIndexManagerHeap)ownerCluster.getIndexManager()).addToIndex(propInfo, this, (String)pValue);
            }
        }
        return pValue;
    }

    private void persistProperty(MFWInfoObjectImpl.ChildInfo childInfo, Object prstValue) {
        if (childInfo.hasSingleMultiplicity()) {
            this.mPropertySlots[childInfo.getPropertyIndex()] = prstValue;
        } else {
            ArrayList<Object> propInstances = (ArrayList<Object>)this.mPropertySlots[childInfo.getPropertyIndex()];
            if (propInstances == null) {
                this.mPropertySlots[childInfo.getPropertyIndex()] = propInstances = new ArrayList<Object>();
            }
            propInstances.add(prstValue);
        }
        this.setExpandStatus(childInfo.getInfo().getRID(), (byte)1);
    }

    private MFWNodeProperty makePropertyNode(MFWInfoPropertyImpl propInfo, Object propValue) {
        MFWNodeProperty outNode = null;
        outNode = propInfo.getDataType() == 2 || propInfo.getDataType() == 4 ? new MFWNodePropertyInt(this, propInfo, (Integer)propValue) : new MFWNodePropertyString(this, propInfo, (String)propValue);
        return outNode;
    }

    private void getChildObjects(MFWInfoObjectImpl.ChildInfo childInfo, List<MFWNode> outResults) {
        for (MFWNode aChild : this.mChildObjects) {
            if (childInfo.getInfo().getRID() != aChild.getInfo().getRID()) continue;
            outResults.add(aChild);
        }
    }

    private MFWNode getFirstChildObject(MFWInfoObjectImpl.ChildInfo childInfo) {
        MFWNode outNode = null;
        for (MFWNode aChild : this.mChildObjects) {
            if (childInfo.getInfo().getRID() != aChild.getInfo().getRID()) continue;
            return aChild;
        }
        return outNode;
    }

    private void updateAllChildrenList(MFWNode childNode) {
        this.mChildObjects.add(childNode);
    }
}

