/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.implPersistence;

import com.cognos.mfw4j.framework.MFWIndexManager;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.implPersistence.MFWNodeObjectPrst;
import com.cognos.mfw4j.framework.implPersistence.MFWPersistentMetadataCluster;
import com.cognos.mfw4j.persistence.MFWPElementInt;
import com.cognos.mfw4j.persistence.MFWPHashMap;
import com.cognos.mfw4j.persistence.MFWPList;
import com.cognos.mfw4j.persistence.MFWPStore;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public final class MFWIndexManagerPrst
implements MFWIndexManager {
    private static short ID_Index_Size_Primary = (short)128;
    private static short ID_Index_Size_Secondary = (short)32;
    private static short OBJ_Index_Size_Primary = (short)4;
    private static short OBJ_Index_Size_Secondary = (short)4;
    private static short OBJ_List_Bucket_Size = (short)10;
    private int mIndexMngrPosition = 0;
    private MFWPHashMap<MFWPElementInt, MFWPElementInt> mIDIndex = null;
    private MFWPersistentMetadataCluster mPMC = null;
    private MFWPHashMap<MFWPElementInt, MFWPElementInt> mTypeIndex = null;

    public static MFWIndexManagerPrst create(MFWPersistentMetadataCluster myPMC) {
        MFWPStore myStore = myPMC.getPMCStore();
        int indexMngrPosition = myStore.putInt(0);
        myStore.putInt(0);
        MFWPHashMap<MFWPElementInt, MFWPElementInt> myIDMap = MFWPHashMap.create(MFWPElementInt.class, MFWPElementInt.class, myStore, ID_Index_Size_Primary, ID_Index_Size_Secondary);
        MFWPHashMap<MFWPElementInt, MFWPElementInt> myTypeMap = MFWPHashMap.create(MFWPElementInt.class, MFWPElementInt.class, myStore, OBJ_Index_Size_Primary, OBJ_Index_Size_Secondary);
        myStore.updateInt(indexMngrPosition, myIDMap.getPosition());
        myStore.updateInt(indexMngrPosition + 4, myTypeMap.getPosition());
        return new MFWIndexManagerPrst(myPMC, indexMngrPosition, myIDMap, myTypeMap);
    }

    public static MFWIndexManagerPrst open(MFWPersistentMetadataCluster myPMC, int indexMngrPosition) {
        MFWPStore myStore = myPMC.getPMCStore();
        int posIDIndex = myStore.getInt(indexMngrPosition);
        int posTypeIndex = myStore.getInt(indexMngrPosition + 4);
        MFWPHashMap<MFWPElementInt, MFWPElementInt> myIDMap = MFWPHashMap.open(MFWPElementInt.class, MFWPElementInt.class, myPMC.getPMCStore(), posIDIndex);
        MFWPHashMap<MFWPElementInt, MFWPElementInt> myTypeMap = MFWPHashMap.open(MFWPElementInt.class, MFWPElementInt.class, myPMC.getPMCStore(), posTypeIndex);
        return new MFWIndexManagerPrst(myPMC, indexMngrPosition, myIDMap, myTypeMap);
    }

    private MFWIndexManagerPrst(MFWPersistentMetadataCluster myPMC, int indexMngrPosition, MFWPHashMap<MFWPElementInt, MFWPElementInt> anIDIndex, MFWPHashMap<MFWPElementInt, MFWPElementInt> aTypeIndex) {
        this.mPMC = myPMC;
        this.mIndexMngrPosition = indexMngrPosition;
        this.mIDIndex = anIDIndex;
        this.mTypeIndex = aTypeIndex;
    }

    @Override
    public void destroy() {
        this.mPMC = null;
        this.mIDIndex = null;
        this.mTypeIndex = null;
    }

    int getPosition() {
        return this.mIndexMngrPosition;
    }

    public void addToIndex(MFWInfoProperty indexProp, MFWNodeObject indexObj, int pooledIndexValue) {
        this.mIDIndex.put(new MFWPElementInt(pooledIndexValue), new MFWPElementInt(((MFWNodeObjectPrst)indexObj).getPosition()));
    }

    @Override
    public MFWNodeObject lookup(MFWInfoProperty indexPropInfo, String inValue) {
        MFWPElementInt outValue;
        MFWNodeObject objNode = null;
        int pooledValue = this.mPMC.getStringPool().findString(inValue);
        if (pooledValue > 0 && (outValue = this.mIDIndex.get(new MFWPElementInt(pooledValue))) != null && outValue.getValue() > 0) {
            objNode = (MFWNodeObject)this.mPMC.getProxyFor(outValue.getValue());
        }
        return objNode;
    }

    @Override
    public void indexObject(MFWNodeObject anObj) {
        MFWPElementInt guidKey = new MFWPElementInt(anObj.getInfo().getGUID());
        MFWPElementInt objValue = new MFWPElementInt();
        MFWPElementInt listPos = this.mTypeIndex.get(guidKey);
        MFWPList<MFWPElementInt> listObjs = null;
        if (listPos == null || listPos.getValue() == 0) {
            listObjs = MFWPList.create(this.mPMC.getPMCStore(), OBJ_List_Bucket_Size, objValue);
            this.mTypeIndex.put(guidKey, objValue.reset(listObjs.getPosition()));
        } else {
            listObjs = MFWPList.open(this.mPMC.getPMCStore(), listPos.getValue());
        }
        listObjs.add(objValue.reset(((MFWNodeObjectPrst)anObj).getPosition()));
    }

    @Override
    public void lookupObjectsByType(short guid, List<MFWNodeObject> outObjs) {
        MFWPElementInt guidKey = new MFWPElementInt(guid);
        MFWPElementInt listPos = this.mTypeIndex.get(guidKey);
        if (listPos == null || listPos.getValue() == 0) {
            return;
        }
        MFWPList listObjs = MFWPList.open(this.mPMC.getPMCStore(), listPos.getValue());
        MFWPList.Iterator itr = listObjs.getIterator();
        while (itr.hasNext()) {
            itr.next(guidKey);
            outObjs.add((MFWNodeObject)this.mPMC.getProxyFor(guidKey.getValue()));
        }
    }

    void asXML(Writer osw, boolean bDetailed) throws IOException {
        osw.write("<indexManager>");
        osw.write("<ID_Index primaryIndexSize=\"");
        osw.write(Integer.toString(ID_Index_Size_Primary));
        osw.write("\" secondaryIndexSize=\"");
        osw.write(Integer.toString(ID_Index_Size_Secondary));
        osw.write("\">");
        int totalEntries = 0;
        MFWPElementInt myKey = new MFWPElementInt();
        MFWPElementInt myVal = new MFWPElementInt();
        if (bDetailed) {
            MFWPHashMap.Iterator itr = this.mIDIndex.getIterator();
            while (itr.hasNext()) {
                itr.next(myKey, myVal);
                String sKey = this.mPMC.getStringPool().getString(myKey.getValue());
                osw.write("<entry key=\"");
                osw.write(sKey == null ? "" : MFWStringHelper.escapeXMLChars(sKey));
                osw.write("\" value=\"");
                osw.write(Integer.toString(myVal.getValue()));
                osw.write("\"/>");
                ++totalEntries;
            }
        } else {
            totalEntries = this.mIDIndex.size();
        }
        osw.write("\n<totalEntries>" + Integer.toString(this.mIDIndex.size()) + "</totalEntries>");
        osw.write("</ID_Index>");
        MFWModel gModel = MFWModel.getInstance();
        MFWPHashMap.Iterator itr = this.mTypeIndex.getIterator();
        while (itr.hasNext()) {
            itr.next(myKey, myVal);
            MFWInfo anInfo = gModel.findInfoByGUID((short)myKey.getValue());
            MFWException.ASSERT(anInfo != null, "Unable to look up an INFO object for GUID:", Integer.toString(myKey.getValue()));
            osw.write("<typeIndex type=\"");
            osw.write(anInfo.getName());
            osw.write("\" numberOfInstances=\"");
            int size = 0;
            if (myVal.getValue() > 0) {
                size = MFWPList.open(this.mPMC.getPMCStore(), myVal.getValue()).size();
            }
            osw.write(Integer.toString(size));
            osw.write("\"/>");
            ++totalEntries;
        }
        osw.write("</indexManager>");
    }
}

