/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.implPersistence;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWLinkManager;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.implPersistence.MFWNodeObjectPrst;
import com.cognos.mfw4j.framework.implPersistence.MFWPersistentMetadataCluster;
import com.cognos.mfw4j.framework.implPersistence.MFWStringPoolPrst;
import com.cognos.mfw4j.persistence.MFWPElement;
import com.cognos.mfw4j.persistence.MFWPList;
import com.cognos.mfw4j.persistence.MFWPStore;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.Vector;

public final class MFWLinkManagerPrst
extends MFWLinkManager {
    Vector<MFWLinkManager.Link> mLinks = new Vector();
    MFWPList<PElementLinkSrc> mPLinks = null;

    public static MFWLinkManagerPrst create(MFWPersistentMetadataCluster myPMC, MFWCluster aCluster) {
        MFWPList<PElementLinkSrc> myList = MFWPList.create(myPMC.getPMCStore(), (short)4, new PElementLinkSrc(myPMC.getStringPool()));
        return new MFWLinkManagerPrst(aCluster, myList);
    }

    public static MFWLinkManagerPrst open(MFWPersistentMetadataCluster myPMC, MFWCluster aCluster, int aPos) {
        MFWPList<PElementLinkSrc> myList = MFWPList.open(myPMC.getPMCStore(), aPos);
        MFWLinkManagerPrst newLnkMngr = new MFWLinkManagerPrst(aCluster, myList);
        newLnkMngr.load(myPMC);
        return newLnkMngr;
    }

    MFWLinkManagerPrst(MFWCluster aCluster, MFWPList<PElementLinkSrc> aList) {
        super(aCluster);
        this.mPLinks = aList;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mLinks.clear();
    }

    int getPosition() {
        return this.mPLinks.getPosition();
    }

    @Override
    protected MFWMetadataSource getLinkSource(short idLink) {
        MFWException.ASSERT(idLink >= 0 && idLink < this.mLinks.size(), "Invalid link id:" + Integer.toString(idLink));
        MFWLinkManager.Link aLink = this.mLinks.get(idLink);
        return aLink.mMetadataSrc;
    }

    @Override
    protected MFWNodeObject getLinkContainer(short idLink) {
        MFWException.ASSERT(idLink >= 0 && idLink < this.mLinks.size(), "Invalid link id" + Integer.toString(idLink));
        MFWLinkManager.Link aLink = this.mLinks.get(idLink);
        return aLink.mLinkParent;
    }

    @Override
    public short findOrAddLink(MFWMetadataSource aSource, MFWNodeObject aParent) {
        for (int idx = 0; idx < this.mLinks.size(); ++idx) {
            MFWLinkManager.Link aLink = this.mLinks.get(idx);
            MFWMetadataSource aSrc = aLink.mMetadataSrc;
            if (!aSrc.equals(aSource)) continue;
            return (short)idx;
        }
        this.mLinks.add(new MFWLinkManager.Link(aSource, aParent));
        short idNewLink = (short)(this.mLinks.size() - 1);
        this.mPLinks.add(new PElementLinkSrc((MFWStringPoolPrst)this.mOwnerCluster.getStringPool(), ((MFWNodeObjectPrst)aParent).getPosition(), aSource));
        this.setupGlobalLinks(aSource, idNewLink);
        return idNewLink;
    }

    @Override
    protected short[] getLinkIDs() {
        short[] outIDs = new short[this.mLinks.size()];
        for (int idx = 0; idx < this.mLinks.size(); ++idx) {
            outIDs[idx] = (short)idx;
        }
        return outIDs;
    }

    private void load(MFWPersistentMetadataCluster myPMC) {
        PElementLinkSrc anEntry = new PElementLinkSrc(myPMC.getStringPool());
        MFWPList.Iterator keyItr = this.mPLinks.getIterator();
        while (keyItr.hasNext()) {
            keyItr.next(anEntry);
            MFWNode parent = myPMC.getProxyFor(anEntry.getLinkParentPosition());
            this.mLinks.add(new MFWLinkManager.Link(anEntry.getLinkSource(), (MFWNodeObject)parent));
        }
    }

    private static final class PElementLinkSrc
    implements MFWPElement {
        int mParentPos = 0;
        MFWMetadataSource.PElement mSourceElement = null;
        MFWStringPoolPrst mStringPool = null;

        PElementLinkSrc(MFWStringPoolPrst aStringPool, int posLinkContainer, MFWMetadataSource aSource) {
            this.mParentPos = posLinkContainer;
            this.mStringPool = aStringPool;
            this.mSourceElement = new MFWMetadataSource.PElement(this.mStringPool, aSource);
        }

        PElementLinkSrc(MFWStringPoolPrst aStringPool) {
            this.mParentPos = 0;
            this.mSourceElement = null;
            this.mStringPool = aStringPool;
        }

        @Override
        public boolean isEqual(MFWPStore store, MFWPElement that) {
            PElementLinkSrc thatLink = (PElementLinkSrc)that;
            if (this.mParentPos != thatLink.mParentPos) {
                return false;
            }
            if (this.mSourceElement == thatLink.mSourceElement) {
                return true;
            }
            if (this.mSourceElement == null || thatLink.mSourceElement == null) {
                return false;
            }
            return this.mSourceElement.isEqual(store, thatLink.mSourceElement);
        }

        @Override
        public void load(MFWPStore aStore, int aPosition) {
            this.mParentPos = aStore.getInt(aPosition);
            if (this.mSourceElement == null) {
                this.mSourceElement = new MFWMetadataSource.PElement(this.mStringPool);
            }
            this.mSourceElement.load(aStore, aPosition + 4);
        }

        @Override
        public void persist(MFWPStore aStore, int aPosition) {
            aStore.updateInt(aPosition, this.mParentPos);
            MFWException.ASSERT(this.mSourceElement != null, "Persist requires a valid Metadata Source element");
            this.mSourceElement.persist(aStore, aPosition + 4);
        }

        @Override
        public short sizeof() {
            if (this.mSourceElement == null) {
                this.mSourceElement = new MFWMetadataSource.PElement(this.mStringPool);
            }
            return (short)(4 + this.mSourceElement.sizeof());
        }

        @Override
        public int getHashCode() {
            if (this.mSourceElement == null) {
                return this.hashCode();
            }
            return this.mParentPos * this.mSourceElement.getHashCode();
        }

        int getLinkParentPosition() {
            return this.mParentPos;
        }

        MFWMetadataSource getLinkSource() {
            MFWException.ASSERT(this.mSourceElement != null, "Expecting a valid persistent Metadata Source element");
            return this.mSourceElement.getSource();
        }
    }
}

