/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.implPersistence;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoLinkImpl;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoObjectImpl;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWInfoPropertyImpl;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeLink;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWNodeProperty;
import com.cognos.mfw4j.framework.MFWNodePropertyDynamic;
import com.cognos.mfw4j.framework.MFWNodePropertyInt;
import com.cognos.mfw4j.framework.MFWNodePropertyString;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.implPersistence.MFWNodeLinkPrst;
import com.cognos.mfw4j.framework.implPersistence.MFWPersistentMetadataCluster;
import com.cognos.mfw4j.persistence.MFWPElementInt;
import com.cognos.mfw4j.persistence.MFWPList;
import com.cognos.mfw4j.persistence.MFWPStore;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.ArrayList;
import java.util.List;

class MFWNodeObjectPrst
extends MFWNodeObject {
    private static final int UNINITIALIZED = -1;
    private static final int LAYOUT_OFFSET_GUID = 0;
    private static final int LAYOUT_OFFSET_PARENT = 2;
    private static final int LAYOUT_OFFSET_CHILDREN_ALL_LIST = 6;
    private static final int LAYOUT_OFFSET_LINKS_LIST = 10;
    private static final int LAYOUT_OFFSET_CHILDREN_BY_TYPE_LIST = 14;
    private int mPosition = -1;
    protected MFWPersistentMetadataCluster mPMC = null;
    private MFWInfoObjectImpl mObjInfo = null;

    private static int create(MFWNodeObjectPrst objParent, MFWInfoObjectImpl objInfo) {
        MFWPStore aStore = objParent.getPMC().getPMCStore();
        return MFWNodeObjectPrst.initalizePrstObject(aStore, objParent.getPosition(), objInfo);
    }

    protected static int initalizePrstObject(MFWPStore aStore, int parentPos, MFWInfoObjectImpl objInfo) {
        int objPos = aStore.putShort(objInfo.getGUID());
        aStore.putInt(parentPos);
        aStore.putInt(0);
        aStore.putInt(0);
        for (int idx = 0; idx < objInfo.getDetailedChildrenInfo().size(); ++idx) {
            aStore.putInt(-1);
        }
        return objPos;
    }

    MFWNodeObjectPrst(MFWPersistentMetadataCluster myPMC, int position) {
        this.mPMC = myPMC;
        this.mPosition = position;
    }

    int getPosition() {
        return this.mPosition;
    }

    MFWPersistentMetadataCluster getPMC() {
        return this.mPMC;
    }

    @Override
    public int hashCode() {
        return this.mPosition;
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof MFWNodeObjectPrst) {
            return this.mPosition == ((MFWNodeObjectPrst)that).mPosition && this.mPMC == ((MFWNodeObjectPrst)that).mPMC;
        }
        return false;
    }

    @Override
    public void destroy() {
        this.mPMC = null;
        super.destroy();
    }

    @Override
    public MFWNodeObject getParentObject() {
        int parentPos = this.mPMC.getPMCStore().getInt(this.mPosition + 2);
        return (MFWNodeObject)this.mPMC.getProxyFor(parentPos);
    }

    @Override
    public MFWCluster getCluster() {
        return this.mPMC.getCluster();
    }

    private int calculateChildEntryPosition(MFWInfoObjectImpl.ChildInfo childInfo) {
        int childEntry = this.mPosition + 14 + childInfo.getIndex() * 4;
        return childEntry;
    }

    @Override
    public void reserveChildren(short ridChildName, int initialSize) {
        if (initialSize <= 0) {
            return;
        }
        MFWInfoObjectImpl objInfo = (MFWInfoObjectImpl)this.getObjectInfo();
        MFWInfoObjectImpl.ChildInfo childInfo = objInfo.findDetailedChildInfo(ridChildName);
        int childEntryPos = this.mPMC.getPMCStore().getInt(this.calculateChildEntryPosition(childInfo));
        if (childEntryPos == -1 && !childInfo.hasSingleMultiplicity()) {
            MFWPElementInt myValue = new MFWPElementInt();
            MFWPList<MFWPElementInt> myList = MFWPList.create(this.mPMC.getPMCStore(), (short)initialSize, myValue);
            this.mPMC.getPMCStore().updateInt(this.calculateChildEntryPosition(childInfo), myList.getPosition());
        }
    }

    @Override
    public MFWInfoObject getObjectInfo() {
        if (this.mObjInfo == null) {
            short aGUID = this.mPMC.getPMCStore().getShort(this.mPosition + 0);
            this.mObjInfo = (MFWInfoObjectImpl)MFWInfo.getInfoForGUID(aGUID, (short)2);
        }
        return this.mObjInfo;
    }

    @Override
    public final List<MFWNode> getChildNodes() {
        int outSize = 0;
        MFWPList objChildren = null;
        int allList = this.mPMC.getPMCStore().getInt(this.mPosition + 6);
        if (allList != 0) {
            objChildren = MFWPList.open(this.mPMC.getPMCStore(), allList);
            outSize = objChildren.size();
        }
        MFWInfoObjectImpl myInfo = (MFWInfoObjectImpl)this.getObjectInfo();
        ArrayList<MFWNode> outList = new ArrayList<MFWNode>(outSize += myInfo.getDetailedChildrenInfo().size());
        for (MFWInfoObjectImpl.ChildInfo aChildInfo : myInfo.getDetailedChildrenInfo()) {
            int[] pValues;
            if (aChildInfo.getInfo().getNodeType() != 1 || (pValues = this.retrieveProperties(aChildInfo, false)) == null) continue;
            for (int idx = 0; idx < pValues.length; ++idx) {
                outList.add(this.makePropertyNode(aChildInfo, pValues[idx]));
            }
        }
        if (objChildren != null) {
            MFWPElementInt aValue = new MFWPElementInt();
            MFWPList.Iterator itr = objChildren.getIterator();
            while (itr.hasNext()) {
                itr.next(aValue);
                outList.add(this.mPMC.getProxyFor(aValue.getValue()));
            }
        }
        return outList;
    }

    @Override
    public final List<String> getPropertyValues(short ridPropName) {
        ArrayList<String> outValues = null;
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        int[] pValues = this.retrieveProperties(childInfo, false);
        if (pValues == null) {
            return null;
        }
        outValues = new ArrayList<String>(pValues.length);
        for (int idx = 0; idx < pValues.length; ++idx) {
            String aValue = this.calculateStringValue((MFWInfoPropertyImpl)childInfo.getInfo(), pValues[idx]);
            outValues.add(aValue);
        }
        return outValues;
    }

    @Override
    public final String getPropertyValue(short ridPropName) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        int[] pValues = this.retrieveProperties(childInfo, true);
        if (pValues == null) {
            return null;
        }
        return this.calculateStringValue((MFWInfoPropertyImpl)childInfo.getInfo(), pValues[0]);
    }

    @Override
    public final boolean getBooleanPropertyValue(short ridPropName) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        MFWException.ASSERT(((MFWInfoProperty)childInfo.getInfo()).getDataType() == 4, "adding boolean Value is supported only for boolean properties");
        int[] pValues = this.retrieveProperties(childInfo, true);
        if (pValues == null) {
            return false;
        }
        return pValues[0] == 1;
    }

    @Override
    public final int getEnumPropertyValue(short ridPropName) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        MFWException.ASSERT(((MFWInfoProperty)childInfo.getInfo()).getDataType() == 2, "adding enum Value is supported only for enumerated properties");
        int[] pValues = this.retrieveProperties(childInfo, true);
        if (pValues == null) {
            return 0;
        }
        return pValues[0];
    }

    @Override
    public final void addProperty(short ridPropName, String sValue) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        int propValue = this.calculatePersistentValue((MFWInfoPropertyImpl)childInfo.getInfo(), sValue);
        this.persistProperty(childInfo, propValue);
    }

    @Override
    public final void addProperty(short ridPropName, boolean bValue) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        MFWException.ASSERT(((MFWInfoProperty)childInfo.getInfo()).getDataType() == 4, "adding boolean Value is supported only for boolean properties");
        this.persistProperty(childInfo, bValue ? 1 : 0);
    }

    @Override
    public final void addProperty(short ridPropName, int iValue) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridPropName, (short)1);
        MFWException.ASSERT(((MFWInfoProperty)childInfo.getInfo()).getDataType() == 2, "adding enum Value is supported only for enumerated properties");
        this.persistProperty(childInfo, iValue);
    }

    @Override
    public final List<MFWNode> getObjectNodes(short ridObjName) {
        MFWInfoObjectImpl.ChildInfo detailedInfo = this.validateChild(ridObjName, (short)2);
        ArrayList<MFWNode> outResults = new ArrayList<MFWNode>();
        this.getChildObjects(detailedInfo, outResults);
        return outResults;
    }

    @Override
    public final MFWNodeObject getObjectNode(short ridObjName) {
        MFWInfoObjectImpl.ChildInfo detailedInfo = this.validateChild(ridObjName, (short)2);
        return (MFWNodeObject)this.getFirstChildObject(detailedInfo);
    }

    @Override
    public final MFWNodeObject addObjectNode(short ridObjName) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridObjName, (short)2);
        MFWInfoObjectImpl objInfo = (MFWInfoObjectImpl)childInfo.getInfo();
        int newObjPos = MFWNodeObjectPrst.create(this, objInfo);
        MFWNodeObject newObj = (MFWNodeObject)this.mPMC.getProxyFor(newObjPos, objInfo);
        this.updateAllChildrenList(newObjPos);
        this.updateChildrenByTypeList(childInfo, newObjPos);
        if (objInfo.isIndexed()) {
            this.mPMC.getIndexManager().indexObject(newObj);
        }
        return newObj;
    }

    @Override
    public final MFWNodeObject addExpandableObjectNode(short ridObjName) {
        return this.addObjectNode(ridObjName);
    }

    @Override
    public final void addLinkNode(short ridChildName, short idLinkSrc, String queryPath) {
        this.validateChild(ridChildName, (short)0);
        int newLinkPos = MFWNodeLinkPrst.create(this, ridChildName, idLinkSrc, queryPath);
        this.updateAllChildrenList(newLinkPos);
        this.updateLinkList(newLinkPos);
    }

    @Override
    public List<MFWNodeLink> getLinkNodes() {
        int linkListPos = this.mPMC.getPMCStore().getInt(this.mPosition + 10);
        if (linkListPos == 0) {
            return null;
        }
        MFWPList linkList = MFWPList.open(this.mPMC.getPMCStore(), linkListPos);
        ArrayList<MFWNodeLink> outLinks = new ArrayList<MFWNodeLink>(linkList.size());
        MFWPElementInt aValue = new MFWPElementInt();
        MFWPList.Iterator itr = linkList.getIterator();
        while (itr.hasNext()) {
            itr.next(aValue);
            MFWNodeLink aLinkNode = (MFWNodeLink)this.mPMC.getProxyFor(aValue.getValue(), MFWModel.getInstance().getLinkNodeInfo());
            outLinks.add(aLinkNode);
        }
        return outLinks;
    }

    @Override
    public final void removeChildNode(MFWNode childNode) {
        MFWException.ASSERT(false, "Removing nodes is not supported for persistent implementation of MFW objects");
    }

    @Override
    public byte getExpandStatus(short ridChildName) {
        return 1;
    }

    @Override
    public void setExpandStatus(short ridChildName, byte expandStat) {
    }

    @Override
    public Object getExpandLock() {
        return null;
    }

    @Override
    protected void queryChild(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, List<MFWNode> outResults) {
        short ridChildName = aQuerySpec.getCurrentStepPatternRID();
        MFWInfoObjectImpl.ChildInfo detailedInfo = this.validateChild(ridChildName, (short)0);
        this.queryChildInstances(aContext, detailedInfo, aQuerySpec, outResults);
    }

    @Override
    protected void queryChild(MFWRequestContextUser aContext, short ridChildName, List<MFWNode> outResults) {
        MFWInfoObjectImpl.ChildInfo detailedInfo = this.validateChild(ridChildName, (short)0);
        this.queryChildInstances(aContext, detailedInfo, null, outResults);
    }

    @Override
    protected MFWNode querySingleChild(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec) {
        short ridChildName = aQuerySpec.getCurrentStepPatternRID();
        return this.querySingleChild(aContext, ridChildName);
    }

    @Override
    protected MFWNode querySingleChild(MFWRequestContextUser aContext, short ridChildName) {
        MFWNode outNode = null;
        MFWInfoObjectImpl.ChildInfo detailedInfo = this.validateChild(ridChildName, (short)0);
        outNode = this.querySingleChildInstance(aContext, detailedInfo);
        return outNode;
    }

    @Override
    protected void queryAllChildren(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, List<MFWNode> outResults) {
        this.queryAllChildren(aContext, outResults);
    }

    @Override
    protected void queryAllChildren(MFWRequestContextUser aContext, List<MFWNode> outResults) {
        MFWInfoObjectImpl myInfo = (MFWInfoObjectImpl)this.getObjectInfo();
        for (MFWInfoObjectImpl.ChildInfo aChildInfo : myInfo.getDetailedChildrenInfo()) {
            int[] pValues;
            if (aChildInfo.getInfo().getNodeType() != 1 || (pValues = this.retrieveProperties(aChildInfo, false)) == null) continue;
            for (int idx = 0; idx < pValues.length; ++idx) {
                outResults.add(this.makePropertyNode(aChildInfo, pValues[idx]));
            }
        }
        int allList = this.mPMC.getPMCStore().getInt(this.mPosition + 6);
        if (allList == 0) {
            return;
        }
        MFWPList myChildren = MFWPList.open(this.mPMC.getPMCStore(), allList);
        MFWInfoLinkImpl linkInfo = MFWModel.getInstance().getLinkNodeInfo();
        MFWPElementInt aValue = new MFWPElementInt();
        MFWPList.Iterator itr = myChildren.getIterator();
        while (itr.hasNext()) {
            itr.next(aValue);
            short childGUID = this.mPMC.getPMCStore().getShort(aValue.getValue());
            if (childGUID == linkInfo.getGUID()) {
                MFWNodeLinkPrst aChildLinkNode = (MFWNodeLinkPrst)this.mPMC.getProxyFor(aValue.getValue(), linkInfo);
                try {
                    aChildLinkNode.getLinkedNodes(this.mPMC.getCluster(), aContext, null, outResults);
                    continue;
                }
                catch (RuntimeException ex) {
                    String errorCode = ex.getMessage();
                    boolean knownErrorCode = MFWConfiguration.getInstance().isKnownErrorCode(errorCode);
                    if (knownErrorCode) continue;
                    throw ex;
                }
            }
            outResults.add(this.mPMC.getProxyFor(aValue.getValue()));
        }
    }

    private void queryChildInstances(MFWRequestContextUser aContext, MFWInfoObjectImpl.ChildInfo childInfo, MFWQuerySpec aQuerySpec, List<MFWNode> outResults) {
        if (childInfo.getInfo().getNodeType() == 1) {
            if (((MFWInfoProperty)childInfo.getInfo()).isDynamic()) {
                outResults.add(new MFWNodePropertyDynamic(this, (MFWInfoPropertyImpl)childInfo.getInfo(), aContext, this.getCluster().getConnection()));
                return;
            }
            int[] pValues = this.retrieveProperties(childInfo, false);
            if (pValues == null) {
                MFWNodeProperty defNode = MFWNodeProperty.makeDefaultPropertyNode(this, childInfo);
                if (defNode != null) {
                    outResults.add(defNode);
                }
                return;
            }
            for (int idx = 0; idx < pValues.length; ++idx) {
                outResults.add(this.makePropertyNode(childInfo, pValues[idx]));
            }
        } else {
            this.getChildObjects(childInfo, outResults);
            this.queryLinkNodes(aContext, aQuerySpec, childInfo, outResults, false);
        }
    }

    protected final MFWNode querySingleChildInstance(MFWRequestContextUser aContext, MFWInfoObjectImpl.ChildInfo childInfo) {
        if (childInfo.getInfo().getNodeType() == 1) {
            if (((MFWInfoProperty)childInfo.getInfo()).isDynamic()) {
                return new MFWNodePropertyDynamic(this, (MFWInfoPropertyImpl)childInfo.getInfo(), aContext, this.getCluster().getConnection());
            }
            int[] pValues = this.retrieveProperties(childInfo, true);
            if (pValues == null) {
                return MFWNodeProperty.makeDefaultPropertyNode(this, childInfo);
            }
            return this.makePropertyNode(childInfo, pValues[0]);
        }
        MFWNode outNode = this.getFirstChildObject(childInfo);
        if (outNode != null) {
            return (MFWNodeObject)outNode;
        }
        ArrayList<MFWNode> outResults = new ArrayList<MFWNode>();
        this.queryLinkNodes(aContext, null, childInfo, outResults, true);
        if (outResults.size() > 0) {
            return outResults.get(0);
        }
        return null;
    }

    private String calculateStringValue(MFWInfoPropertyImpl propInfo, int prstValue) {
        String sValue = null;
        switch (propInfo.getDataType()) {
            case 2: {
                sValue = propInfo.validateEnumeratedValue(prstValue);
                break;
            }
            case 4: {
                sValue = prstValue == 1 ? "true" : "false";
                break;
            }
            default: {
                sValue = this.mPMC.getStringPool().getString(prstValue);
            }
        }
        return sValue;
    }

    private int[] retrieveProperties(MFWInfoObjectImpl.ChildInfo childInfo, boolean bOnlyFirst) {
        int[] outValues = null;
        MFWPStore aStore = this.mPMC.getPMCStore();
        int childSlotValue = aStore.getInt(this.calculateChildEntryPosition(childInfo));
        if (childSlotValue == -1) {
            return null;
        }
        if (childInfo.hasSingleMultiplicity()) {
            outValues = new int[]{childSlotValue};
        } else {
            MFWPList propInstances = MFWPList.open(aStore, childSlotValue);
            outValues = new int[bOnlyFirst ? 1 : propInstances.size()];
            MFWPList.Iterator itr = propInstances.getIterator();
            MFWPElementInt aValue = new MFWPElementInt();
            for (int idx = 0; idx < outValues.length && itr.hasNext(); ++idx) {
                itr.next(aValue);
                outValues[idx] = aValue.getValue();
            }
        }
        return outValues;
    }

    private int calculatePersistentValue(MFWInfoPropertyImpl propInfo, String sValue) {
        int pValue = 0;
        switch (propInfo.getDataType()) {
            case 2: {
                pValue = propInfo.getEnumCode(sValue);
                break;
            }
            case 4: {
                pValue = "true".equals(sValue) ? 1 : 0;
                break;
            }
            default: {
                pValue = this.mPMC.getStringPool().poolString(sValue);
                if (!propInfo.isIndexed() || sValue == null || sValue.length() <= 0) break;
                this.mPMC.getIndexManager().addToIndex(propInfo, this, pValue);
            }
        }
        return pValue;
    }

    private void persistProperty(MFWInfoObjectImpl.ChildInfo childInfo, int propPrstValue) {
        MFWPStore aStore = this.mPMC.getPMCStore();
        int childSlot = this.calculateChildEntryPosition(childInfo);
        if (childInfo.hasSingleMultiplicity()) {
            aStore.updateInt(childSlot, propPrstValue);
        } else {
            MFWPElementInt childValue = new MFWPElementInt(propPrstValue);
            MFWPList<Object> childList = null;
            int childPropPos = aStore.getInt(childSlot);
            if (childPropPos == -1) {
                childList = MFWPList.create(aStore, (short)4, childValue);
                aStore.updateInt(childSlot, childList.getPosition());
            } else {
                childList = MFWPList.open(aStore, childPropPos);
            }
            childList.add(childValue);
        }
    }

    private MFWNodeProperty makePropertyNode(MFWInfoObjectImpl.ChildInfo childInfo, int pValue) {
        MFWInfoPropertyImpl propInfo = (MFWInfoPropertyImpl)childInfo.getInfo();
        if (propInfo.getDataType() == 2 || propInfo.getDataType() == 4) {
            return new MFWNodePropertyInt(this, propInfo, pValue);
        }
        return new MFWNodePropertyString(this, propInfo, this.calculateStringValue(propInfo, pValue));
    }

    private void queryLinkNodes(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWInfoObjectImpl.ChildInfo childInfo, List<MFWNode> outResults, boolean bOnlyFirst) {
        int linksListPos = this.mPMC.getPMCStore().getInt(this.mPosition + 10);
        if (linksListPos != 0) {
            MFWCluster ownerCluster = this.getCluster();
            MFWPList myChildren = MFWPList.open(this.mPMC.getPMCStore(), linksListPos);
            MFWPElementInt aValue = new MFWPElementInt();
            MFWPList.Iterator itr = myChildren.getIterator();
            while (itr.hasNext()) {
                block4: {
                    itr.next(aValue);
                    MFWNodeLink aChildLinkNode = (MFWNodeLink)this.mPMC.getProxyFor(aValue.getValue(), MFWModel.getInstance().getLinkNodeInfo());
                    if (childInfo.getInfo().getRID() != aChildLinkNode.getLinkChildRID()) continue;
                    try {
                        aChildLinkNode.getLinkedNodes(ownerCluster, aContext, aQuerySpec, outResults);
                    }
                    catch (RuntimeException ex) {
                        String errorCode = ex.getMessage();
                        boolean knownErrorCode = MFWConfiguration.getInstance().isKnownErrorCode(errorCode);
                        if (knownErrorCode) break block4;
                        throw ex;
                    }
                }
                if (!bOnlyFirst || outResults.size() <= 0) continue;
                break;
            }
        }
    }

    private void getChildObjects(MFWInfoObjectImpl.ChildInfo childInfo, List<MFWNode> outResults) {
        int childPropPos = this.mPMC.getPMCStore().getInt(this.calculateChildEntryPosition(childInfo));
        if (childPropPos != -1) {
            if (childInfo.hasSingleMultiplicity()) {
                outResults.add(this.mPMC.getProxyFor(childPropPos, childInfo.getInfo()));
            } else {
                MFWPList myChildren = MFWPList.open(this.mPMC.getPMCStore(), childPropPos);
                MFWPElementInt aValue = new MFWPElementInt();
                MFWPList.Iterator itr = myChildren.getIterator();
                while (itr.hasNext()) {
                    itr.next(aValue);
                    outResults.add(this.mPMC.getProxyFor(aValue.getValue(), childInfo.getInfo()));
                }
            }
        }
    }

    private MFWNode getFirstChildObject(MFWInfoObjectImpl.ChildInfo childInfo) {
        MFWNode outNode = null;
        int childPropPos = this.mPMC.getPMCStore().getInt(this.calculateChildEntryPosition(childInfo));
        if (childPropPos != -1) {
            if (childInfo.hasSingleMultiplicity()) {
                outNode = this.mPMC.getProxyFor(childPropPos, childInfo.getInfo());
            } else {
                MFWPList myChildren = MFWPList.open(this.mPMC.getPMCStore(), childPropPos);
                MFWPList.Iterator itr = myChildren.getIterator();
                if (itr.hasNext()) {
                    MFWPElementInt aValue = new MFWPElementInt();
                    itr.next(aValue);
                    outNode = this.mPMC.getProxyFor(aValue.getValue(), childInfo.getInfo());
                }
            }
        }
        return outNode;
    }

    private void updateAllChildrenList(int childPos) {
        MFWPElementInt childValue = new MFWPElementInt(childPos);
        MFWPList<Object> allChildren = null;
        int allListPos = this.mPMC.getPMCStore().getInt(this.mPosition + 6);
        if (allListPos == 0) {
            short initialSize = ((MFWInfoObjectImpl)this.getObjectInfo()).getInitialChildrenListSize();
            allChildren = MFWPList.create(this.mPMC.getPMCStore(), initialSize > 0 ? initialSize : (short)4, childValue);
            this.mPMC.getPMCStore().updateInt(this.mPosition + 6, allChildren.getPosition());
        } else {
            allChildren = MFWPList.open(this.mPMC.getPMCStore(), allListPos);
        }
        allChildren.add(childValue);
    }

    private void updateChildrenByTypeList(MFWInfoObjectImpl.ChildInfo childInfo, int childPos) {
        MFWPStore aStore = this.mPMC.getPMCStore();
        if (childInfo.hasSingleMultiplicity()) {
            aStore.updateInt(this.calculateChildEntryPosition(childInfo), childPos);
        } else {
            MFWPElementInt childValue = new MFWPElementInt(childPos);
            MFWPList<Object> childList = null;
            int childPropPos = aStore.getInt(this.calculateChildEntryPosition(childInfo));
            if (childPropPos == -1) {
                childList = MFWPList.create(aStore, (short)4, childValue);
                aStore.updateInt(this.calculateChildEntryPosition(childInfo), childList.getPosition());
            } else {
                childList = MFWPList.open(aStore, childPropPos);
            }
            childList.add(childValue);
        }
    }

    private void updateLinkList(int childPos) {
        MFWPElementInt childValue = new MFWPElementInt(childPos);
        MFWPList<Object> linkList = null;
        int linkListPos = this.mPMC.getPMCStore().getInt(this.mPosition + 10);
        if (linkListPos == 0) {
            linkList = MFWPList.create(this.mPMC.getPMCStore(), (short)4, childValue);
            this.mPMC.getPMCStore().updateInt(this.mPosition + 10, linkList.getPosition());
        } else {
            linkList = MFWPList.open(this.mPMC.getPMCStore(), linkListPos);
        }
        linkList.add(childValue);
    }
}

