/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.implPersistence;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.implPersistence.MFWDumpPMC;
import com.cognos.mfw4j.framework.implPersistence.MFWIndexManagerPrst;
import com.cognos.mfw4j.framework.implPersistence.MFWLinkManagerPrst;
import com.cognos.mfw4j.framework.implPersistence.MFWNodeLinkPrst;
import com.cognos.mfw4j.framework.implPersistence.MFWNodeObjectPrst;
import com.cognos.mfw4j.framework.implPersistence.MFWNodeObjectRootPrst;
import com.cognos.mfw4j.framework.implPersistence.MFWPersistedConnectionReuseInfo;
import com.cognos.mfw4j.framework.implPersistence.MFWStringPoolPrst;
import com.cognos.mfw4j.framework.log.MFWLogEventObject;
import com.cognos.mfw4j.framework.log.MFWLogEviction;
import com.cognos.mfw4j.framework.log.MFWLogEvictionExaminationPMC;
import com.cognos.mfw4j.framework.log.MFWLogPersistentCluster;
import com.cognos.mfw4j.framework.policies.MFWEvictionPolicy;
import com.cognos.mfw4j.persistence.MFWPStore;
import com.cognos.mfw4j.utilities.MFWException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MFWPersistentMetadataCluster {
    private static final short PMC_MAJ_VER = 1;
    private static final short PMC_MIN_VER = 25;
    private static final short PMC_CONTENT_COMPLETE = 1;
    private static final short PMC_CONTENT_INCOMPLETE = 0;
    private static final int PMC_LAYOUT_OFFSET_CONTENT_STATUS = 0;
    private static final int PMC_LAYOUT_OFFSET_MAJ_VER = 2;
    private static final int PMC_LAYOUT_OFFSET_MIN_VER = 4;
    private static final int PMC_LAYOUT_OFFSET_REUSE_INFO = 6;
    private static final int PMC_LAYOUT_OFFSET_STRING_POOL = 10;
    private static final int PMC_LAYOUT_OFFSET_INDEX_MANAGER = 14;
    private static final int PMC_LAYOUT_OFFSET_LINK_MANAGER = 18;
    private static final int PMC_LAYOUT_OFFSET_ROOT_OBJECT = 22;
    private MFWCluster mCluster = null;
    private MFWPStore mStorePMC = null;
    private MFWStringPoolPrst mStringPool = null;
    private MFWIndexManagerPrst mIndexManager = null;
    private MFWLinkManagerPrst mLinkManager = null;
    private MFWNodeObjectRootPrst mRootObject = null;

    public static boolean findOrCreate(MFWRequestContextUser aContext, MFWCluster aCluster, MFWConnectionReuseInfo inReuseInfo) {
        boolean bCreated = false;
        MFWPersistentMetadataCluster myPMC = new MFWPersistentMetadataCluster(aCluster);
        File pmcFile = new File(inReuseInfo.getPersistentClusterFilePath());
        if (!pmcFile.exists()) {
            myPMC.create(inReuseInfo);
            bCreated = true;
        } else {
            boolean bOpened = myPMC.open(inReuseInfo);
            if (!bOpened) {
                myPMC.create(inReuseInfo);
                bCreated = true;
            }
        }
        aCluster.getConnection().setPMC(myPMC);
        return bCreated;
    }

    public static void collectIfExpired(List<MFWEvictionPolicy> vPMCPolicies, File aPMCFile, Map<String, ArrayList<String>> mapExpiredPMCs) {
        MFWPersistentMetadataCluster newPMC = new MFWPersistentMetadataCluster();
        newPMC.collectIfExpired(vPMCPolicies, aPMCFile.getPath(), mapExpiredPMCs);
    }

    public static void deletePMCFile(String aPMCFilePath) {
        File aPMCFile = new File(aPMCFilePath);
        MFWException.ASSERT(aPMCFile != null, "Unable to get a file handler for expired PMC file:", aPMCFilePath);
        aPMCFile.delete();
        if (aPMCFile.getParentFile().listFiles().length == 0) {
            aPMCFile.getParentFile().delete();
        }
    }

    static void dump(String pmcFilePath, boolean isDetailed) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(pmcFilePath + "_dump.xml"), Charset.forName("UTF-8"));
        MFWPersistentMetadataCluster dumpPMC = new MFWPersistentMetadataCluster();
        dumpPMC.dumpContent(pmcFilePath, isDetailed, osw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpContent(String pmcFilePath, boolean isDetailed, OutputStreamWriter osw) throws IOException {
        try {
            this.mStorePMC = new MFWPStore(pmcFilePath);
            this.mStorePMC.open(MFWPStore.EMode.kModeReadOnly);
            this.mStringPool = MFWStringPoolPrst.open(this.mStorePMC, this.mStorePMC.getInt(10));
            this.mIndexManager = MFWIndexManagerPrst.open(this, this.mStorePMC.getInt(14));
            this.mLinkManager = MFWLinkManagerPrst.open(this, this.mCluster, this.mStorePMC.getInt(18));
            this.mRootObject = new MFWNodeObjectRootPrst(this, this.mStorePMC.getInt(22));
            osw.write("<pmc>");
            this.dumpHeading(this.mStorePMC, osw);
            this.mStringPool.asXML(osw, isDetailed);
            MFWPersistedConnectionReuseInfo pmcRI = MFWPersistedConnectionReuseInfo.reconstruct(this, this.mStorePMC.getInt(6));
            pmcRI.asXML(osw);
            this.mIndexManager.asXML(osw, isDetailed);
            this.mLinkManager.asXML(osw, isDetailed);
            osw.write("<model>");
            MFWDumpPMC.nodeAsXML(osw, this.mRootObject, isDetailed);
            osw.write("</model>");
            osw.write("</pmc>");
        }
        finally {
            osw.flush();
            osw.close();
            this.mStorePMC.close();
        }
    }

    private void dumpHeading(MFWPStore pmcStore, OutputStreamWriter osw) throws IOException {
        osw.write("<filePath v=\"");
        osw.write(pmcStore.getFilePath());
        osw.write("\"/>");
        short contentStat = pmcStore.getShort(0);
        osw.write("<status v=\"");
        osw.write(contentStat == 1 ? "complete\"/>" : "incomplete\"/>");
        osw.write("<version major=\"");
        osw.write(Short.toString(pmcStore.getShort(2)));
        osw.write("\" minor=\"");
        osw.write(Short.toString(pmcStore.getShort(4)));
        osw.write("\"/>");
    }

    private MFWPersistentMetadataCluster(MFWCluster aCluster) {
        this.mCluster = aCluster;
    }

    private MFWPersistentMetadataCluster() {
        this.mCluster = null;
    }

    public MFWPStore getPMCStore() {
        return this.mStorePMC;
    }

    public MFWStringPoolPrst getStringPool() {
        return this.mStringPool;
    }

    public MFWIndexManagerPrst getIndexManager() {
        return this.mIndexManager;
    }

    public MFWLinkManagerPrst getLinkManager() {
        return this.mLinkManager;
    }

    public MFWNodeObjectRootPrst getRootObject() {
        return this.mRootObject;
    }

    public MFWCluster getCluster() {
        return this.mCluster;
    }

    public void deleteUnOwned() {
        try {
            this.mStorePMC.close();
            this.mStringPool.destroy();
            MFWPersistentMetadataCluster.deletePMCFile(this.mStorePMC.getFilePath());
        }
        catch (Throwable th) {
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException("Failed to delete the un-owned PMC file:" + this.mStorePMC.getFilePath(), th);
        }
    }

    private void create(MFWConnectionReuseInfo inReuseInfo) {
        String pmcFilePath = inReuseInfo.getPersistentClusterFilePath();
        MFWLogPersistentCluster pc = new MFWLogPersistentCluster(inReuseInfo, this.mCluster.hashCode(), "Create new PMC");
        try {
            this.mStorePMC = new MFWPStore(pmcFilePath);
            this.mStorePMC.create(100);
            this.mStorePMC.putShort((short)0);
            this.mStorePMC.putShort((short)1);
            this.mStorePMC.putShort((short)25);
            this.mStorePMC.putInt(0);
            this.mStorePMC.putInt(0);
            this.mStorePMC.putInt(0);
            this.mStorePMC.putInt(0);
            this.mStorePMC.putInt(0);
            this.mStringPool = MFWStringPoolPrst.create(this.mStorePMC);
            this.mStorePMC.updateInt(10, this.mStringPool.getPosition());
            int riAddr = inReuseInfo.persist(this);
            this.mStorePMC.updateInt(6, riAddr);
            this.mIndexManager = MFWIndexManagerPrst.create(this);
            this.mStorePMC.updateInt(14, this.mIndexManager.getPosition());
            this.mLinkManager = MFWLinkManagerPrst.create(this, this.mCluster);
            this.mStorePMC.updateInt(18, this.mLinkManager.getPosition());
            this.mRootObject = MFWNodeObjectRootPrst.create(this);
            this.mStorePMC.updateInt(22, this.mRootObject.getPosition());
            pc.logEnd();
        }
        catch (Throwable th) {
            pc.logEnd(th);
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException("Failed to create a persistent cluster:" + pmcFilePath, th);
        }
    }

    private boolean open(MFWConnectionReuseInfo inReuseInfo) {
        String pmcFilePath = inReuseInfo.getPersistentClusterFilePath();
        MFWLogPersistentCluster pc = new MFWLogPersistentCluster(inReuseInfo, this.mCluster.hashCode(), "Open Existing PMC");
        try {
            this.mStorePMC = new MFWPStore(pmcFilePath);
            if (this.mStorePMC.open(MFWPStore.EMode.kModeReadOnly) < 0) {
                return false;
            }
            if (!this.isUsable()) {
                this.mStorePMC.close();
                return false;
            }
            this.mStringPool = MFWStringPoolPrst.open(this.mStorePMC, this.mStorePMC.getInt(10));
            this.mIndexManager = MFWIndexManagerPrst.open(this, this.mStorePMC.getInt(14));
            this.mLinkManager = MFWLinkManagerPrst.open(this, this.mCluster, this.mStorePMC.getInt(18));
            this.mRootObject = new MFWNodeObjectRootPrst(this, this.mStorePMC.getInt(22));
            pc.logEnd();
            return true;
        }
        catch (Throwable th) {
            pc.logEnd(th);
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException("Failed to open a persistent cluster:" + pmcFilePath, th);
        }
    }

    private boolean isUsable() {
        try {
            short contentStat = this.mStorePMC.getShort(0);
            short verMaj = this.mStorePMC.getShort(2);
            short verMin = this.mStorePMC.getShort(4);
            return contentStat == 1 && verMaj == 1 && verMin == 25;
        }
        catch (Throwable t) {
            throw new RuntimeException("PMC file is not usable " + this.mStorePMC.getCanonicalFilePath(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collectIfExpired(List<MFWEvictionPolicy> vPMCPolicies, String pmcFilePath, Map<String, ArrayList<String>> mapExpiredPMCs) {
        boolean bRemove = false;
        MFWLogEventObject log = null;
        try {
            this.mStorePMC = new MFWPStore(pmcFilePath);
            this.mStorePMC.open(MFWPStore.EMode.kModeReadWrite);
            this.mStringPool = MFWStringPoolPrst.open(this.mStorePMC, this.mStorePMC.getInt(10));
            MFWPersistedConnectionReuseInfo pmcReuseInfo = MFWPersistedConnectionReuseInfo.reconstruct(this, this.mStorePMC.getInt(6));
            log = new MFWLogEvictionExaminationPMC("MFWAdaptor::removePMCsIfRequired", pmcReuseInfo, pmcFilePath);
            bRemove = MFWPersistentMetadataCluster.shouldRemovePMC(vPMCPolicies, pmcReuseInfo);
            if (bRemove) {
                ArrayList<String> expList = mapExpiredPMCs.get(pmcReuseInfo.getMetadataSource().getType());
                if (expList == null) {
                    expList = new ArrayList(100);
                    mapExpiredPMCs.put(pmcReuseInfo.getMetadataSource().getType(), expList);
                }
                expList.add(this.mStorePMC.getCanonicalFilePath());
            }
            this.mStorePMC.close();
            log.logEnd();
        }
        catch (OverlappingFileLockException e) {
            this.mStorePMC.close();
        }
        catch (Throwable th) {
            if (log != null) {
                log.logEnd(th);
            }
            this.mStorePMC.close();
        }
        finally {
            this.mStorePMC = null;
        }
        return bRemove;
    }

    public void updateUsageInfoAndClose() {
        MFWException.ASSERT(this.mStorePMC.getMode() == MFWPStore.EMode.kModeReadOnly, "Expecting a rean-only mode when evicting PMC:", this.mStorePMC.getFilePath());
        this.mStorePMC.close();
        this.mStorePMC.open(MFWPStore.EMode.kModeReadWrite);
        MFWConnectionReuseInfo.refreshLastAccessTime(this.mStorePMC, this.mStorePMC.getInt(6));
        this.mStorePMC.close();
        this.mStringPool.destroy();
    }

    public void saveAndReopen() {
        this.mStorePMC.updateShort(0, (short)1);
        this.mStorePMC.close();
        this.mStorePMC.open(MFWPStore.EMode.kModeReadOnly);
    }

    private static boolean shouldRemovePMC(List<MFWEvictionPolicy> vPolicies, MFWConnectionReuseInfo pmcReuseInfo) {
        boolean bRemove = false;
        for (int i = 0; !bRemove && i < vPolicies.size(); ++i) {
            MFWEvictionPolicy aPolicy = vPolicies.get(i);
            short evictAction = aPolicy.getEvictionAction(pmcReuseInfo);
            if (evictAction != 1) continue;
            bRemove = true;
            MFWLogEviction log = new MFWLogEviction("MFWAdaptor::evictClusterIfRequred", pmcReuseInfo, aPolicy.toString());
            log.logEnd();
        }
        return bRemove;
    }

    MFWNode getProxyFor(int objPosition) {
        short aGUID = this.mStorePMC.getShort(objPosition);
        MFWInfo anInfo = MFWInfo.getInfoForGUID(aGUID, (short)0);
        return this.getProxyFor(objPosition, anInfo);
    }

    MFWNode getProxyFor(int nodePosition, MFWInfo nodeInfo) {
        MFWNode aProxy = null;
        switch (nodeInfo.getNodeType()) {
            case 2: {
                aProxy = nodeInfo.getGUID() == 0 ? this.mRootObject : new MFWNodeObjectPrst(this, nodePosition);
                break;
            }
            case 3: {
                aProxy = new MFWNodeLinkPrst(this, nodePosition);
                break;
            }
            default: {
                MFWException.ASSERT(false, "Unexpected node type when creating proxy for ", nodeInfo.getName());
            }
        }
        return aProxy;
    }
}

