/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.implPersistence;

import com.cognos.mfw4j.framework.MFWStringPool;
import com.cognos.mfw4j.persistence.MFWPElementString;
import com.cognos.mfw4j.persistence.MFWPList;
import com.cognos.mfw4j.persistence.MFWPStore;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class MFWStringPoolPrst
implements MFWStringPool {
    private static int Index_Size_Primary = 256;
    private static int Index_Size_Secondary = 32;
    private static short Max_List_Bucket_Size = (short)8;
    private static int Slot_Unknown = -1;
    private static int Slot_Empty = 0;
    private static int Max_Retrieval_PoolSize = 2048;
    private static int MAX_Retrival_BucketCapacity = 8;
    private boolean mFirstCreate = false;
    private MFWPStore mStore = null;
    private int mPool = 0;
    private int[] mArraysSlots = new int[Index_Size_Primary * Index_Size_Secondary];
    private Bucket[] mRetrievalPool = new Bucket[Max_Retrieval_PoolSize];

    public static MFWStringPoolPrst create(MFWPStore aStore) {
        int poolPosition = aStore.getPosition();
        for (int idx = 0; idx < Index_Size_Primary * Index_Size_Secondary; ++idx) {
            aStore.putInt(Slot_Empty);
        }
        return new MFWStringPoolPrst(true, aStore, poolPosition);
    }

    public static MFWStringPoolPrst open(MFWPStore aStore, int poolPosition) {
        return new MFWStringPoolPrst(false, aStore, poolPosition);
    }

    private MFWStringPoolPrst(boolean isFirstCreate, MFWPStore aStore, int aPool) {
        this.mFirstCreate = isFirstCreate;
        this.mStore = aStore;
        this.mPool = aPool;
        if (this.mFirstCreate) {
            Arrays.fill(this.mArraysSlots, Slot_Empty);
        } else {
            Arrays.fill(this.mArraysSlots, Slot_Unknown);
            for (int i = 0; i < this.mRetrievalPool.length; ++i) {
                this.mRetrievalPool[i] = new Bucket();
            }
        }
    }

    @Override
    public void destroy() {
        for (int idx = 0; idx < this.mRetrievalPool.length; ++idx) {
            if (this.mRetrievalPool[idx] == null) continue;
            this.mRetrievalPool[idx].destroy();
        }
    }

    int getPosition() {
        return this.mPool;
    }

    public int findString(String inString) {
        int idxSlotSecondary;
        if (inString == null) {
            return 0;
        }
        int idxSlotPrimary = Math.abs(inString.hashCode() % Index_Size_Primary);
        int slotIndex = idxSlotPrimary * Index_Size_Secondary + (idxSlotSecondary = Math.abs(inString.hashCode()) / Index_Size_Primary % Index_Size_Secondary);
        int aList = this.getListPosition(slotIndex);
        if (aList != 0) {
            MFWPElementString inValue = new MFWPElementString(inString);
            MFWPElementString listValue = new MFWPElementString();
            MFWPList myList = MFWPList.open(this.mStore, aList);
            MFWPList.Iterator itr = myList.getIterator();
            while (itr.hasNext()) {
                itr.next(listValue);
                if (!listValue.isEqual(this.mStore, inValue)) continue;
                return listValue.getPosition();
            }
        }
        return -1;
    }

    private int getListPosition(int slotIndex) {
        int aList = this.mArraysSlots[slotIndex];
        if (aList == Slot_Unknown) {
            this.mArraysSlots[slotIndex] = aList = this.mStore.getInt(this.mPool + slotIndex * 4);
        }
        return aList;
    }

    public int poolString(String inString) {
        int idxSlotSecondary;
        if (inString == null) {
            return 0;
        }
        MFWPElementString inValue = new MFWPElementString(inString);
        int idxSlotPrimary = Math.abs(inString.hashCode() % Index_Size_Primary);
        int slotIndex = idxSlotPrimary * Index_Size_Secondary + (idxSlotSecondary = Math.abs(inString.hashCode()) / Index_Size_Primary % Index_Size_Secondary);
        int aList = this.getListPosition(slotIndex);
        if (aList == 0) {
            MFWPList<MFWPElementString> myList = MFWPList.create(this.mStore, Max_List_Bucket_Size, inValue);
            int aListPosition = this.mPool + idxSlotPrimary * 4 * Index_Size_Secondary + idxSlotSecondary * 4;
            this.mStore.updateInt(aListPosition, myList.getPosition());
            this.mArraysSlots[slotIndex] = myList.getPosition();
            myList.add(inValue);
            return inValue.getPosition();
        }
        MFWPElementString listValue = new MFWPElementString();
        MFWPList<MFWPElementString> myList = MFWPList.open(this.mStore, aList);
        MFWPList.Iterator itr = myList.getIterator();
        while (itr.hasNext()) {
            itr.next(listValue);
            if (!listValue.isEqual(this.mStore, inValue)) continue;
            return listValue.getPosition();
        }
        myList.add(inValue);
        return inValue.getPosition();
    }

    public String getString(int valuePosition) {
        if (valuePosition == 0) {
            return null;
        }
        if (this.mFirstCreate) {
            return this.mStore.getString(valuePosition);
        }
        int idx = Math.abs(valuePosition % Max_Retrieval_PoolSize);
        return this.mRetrievalPool[idx].getString(this.mStore, valuePosition);
    }

    void asXML(Writer osw, boolean bDetailed) throws IOException {
        MFWPElementString myValue = new MFWPElementString();
        int totalNum = 0;
        osw.write("<stringPool primaryIndexSize=\"");
        osw.write(Integer.toString(Index_Size_Primary));
        osw.write("\" secondaryIndexSize=\"");
        osw.write(Integer.toString(Index_Size_Secondary));
        osw.write("\">");
        for (int idx1 = 0; idx1 < Index_Size_Primary; ++idx1) {
            int primaryNum = 0;
            if (bDetailed) {
                osw.write("\n<slot no=\"" + Integer.toString(idx1) + "\">");
            }
            for (int idx2 = 0; idx2 < Index_Size_Secondary; ++idx2) {
                int aList = this.mStore.getInt(this.mPool + idx1 * 4 * Index_Size_Secondary + idx2 * 4);
                if (aList == 0) continue;
                MFWPList myList = MFWPList.open(this.mStore, aList);
                int slotNum = myList.size();
                if (bDetailed) {
                    osw.write("\n<slot no=\"" + Integer.toString(idx2) + "\">");
                    osw.write("\n<numEntries>" + Integer.toString(slotNum) + "</numEntries>");
                    MFWPList.Iterator itr = myList.getIterator();
                    while (itr.hasNext()) {
                        itr.next(myValue);
                        osw.write("<v>" + MFWStringHelper.escapeXMLChars(this.getString(myValue.getPosition())) + "</v>");
                    }
                    osw.write("</slot>");
                }
                totalNum += slotNum;
                primaryNum += slotNum;
            }
            if (!bDetailed) continue;
            osw.write("\n<totalSlotEntries>" + Integer.toString(primaryNum) + "</totalSlotEntries>");
            osw.write("</slot>");
        }
        osw.write("\n<totalEntries>" + Integer.toString(totalNum) + "</totalEntries>");
        osw.write("</stringPool>");
    }

    private class Bucket {
        private ReentrantReadWriteLock mRWLock = new ReentrantReadWriteLock();
        private byte mCurrentIdx = 0;
        private SoftReference<String>[] mValues = new SoftReference[MFWStringPoolPrst.access$000()];
        private int[] mAddresses = new int[MFWStringPoolPrst.access$000()];
        private Bucket mNext = null;

        Bucket() {
        }

        void destroy() {
            for (int idx = 0; idx < this.mCurrentIdx; ++idx) {
                this.mValues[idx] = null;
            }
            if (this.mNext != null) {
                this.mNext.destroy();
            }
            this.mNext = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getString(MFWPStore aStore, int strAddr) {
            String outValue;
            this.mRWLock.readLock().lock();
            try {
                outValue = this.find(aStore, strAddr);
                if (outValue != null) {
                    String string = outValue;
                    return string;
                }
            }
            finally {
                this.mRWLock.readLock().unlock();
            }
            this.mRWLock.writeLock().lock();
            try {
                outValue = this.find(aStore, strAddr);
                if (outValue != null) {
                    String string = outValue;
                    return string;
                }
                if (this.mCurrentIdx < MAX_Retrival_BucketCapacity) {
                    String string = this.add(aStore, strAddr);
                    return string;
                }
                this.mNext = new Bucket();
                String string = this.mNext.add(aStore, strAddr);
                return string;
            }
            finally {
                this.mRWLock.writeLock().unlock();
            }
        }

        private String add(MFWPStore aStore, int strAddr) {
            String strValue = aStore.getString(strAddr);
            this.mValues[this.mCurrentIdx] = new SoftReference<String>(strValue);
            this.mAddresses[this.mCurrentIdx] = strAddr;
            this.mCurrentIdx = (byte)(this.mCurrentIdx + 1);
            return strValue;
        }

        private String find(MFWPStore aStore, int strAddr) {
            for (int idx = 0; idx < this.mCurrentIdx; ++idx) {
                if (strAddr != this.mAddresses[idx]) continue;
                String strValue = this.mValues[idx].get();
                if (strValue == null) {
                    strValue = aStore.getString(strAddr);
                    this.mValues[idx] = new SoftReference<String>(strValue);
                }
                return strValue;
            }
            if (this.mNext != null) {
                return this.mNext.find(aStore, strAddr);
            }
            return null;
        }
    }
}

