/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.modelHelper;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MFWScopeRelationship {
    private static MFWModelRes gModelRes = MFWModelRes.getInstance();
    private static MFWInfoProperty gIDProperty = MFWModel.getInstance().getIDPropertyInfo();
    private HashMap<String, List<ScopeInfo>> mMeasureScoping = new HashMap(50);

    public MFWScopeRelationship(MFWRequestContextUser aContext, MFWCluster aCluster) {
        this.setupMeasuresScopedLevels(aContext, aCluster);
    }

    public List<String> getLowestLevelsInScope(MFWNodeHandle hMsrItem, MFWNodeHandle hMsrDim, MFWNodeHandle hRegDim) {
        String idMsrItem = ((MFWNodeObject)hMsrItem).getPropertyValue(MFWScopeRelationship.gModelRes.RID_ID);
        String idMsrDim = ((MFWNodeObject)hMsrDim).getPropertyValue(MFWScopeRelationship.gModelRes.RID_ID);
        String idRegDim = ((MFWNodeObject)hRegDim).getPropertyValue(MFWScopeRelationship.gModelRes.RID_ID);
        MFWException.ASSERT(idMsrItem != null && idMsrItem.length() > 0, "Expecting a avlid ID for measure item when invoking getLowestLevelsInScope");
        MFWException.ASSERT(idMsrDim != null && idMsrDim.length() > 0, "Expecting a avlid ID for measure dimension when invoking getLowestLevelsInScope");
        MFWException.ASSERT(idRegDim != null && idRegDim.length() > 0, "Expecting a avlid ID for regular dimension when invoking getLowestLevelsInScope");
        List<ScopeInfo> vScopeInfo = this.mMeasureScoping.get(idMsrItem);
        if (vScopeInfo == null || vScopeInfo.size() == 0) {
            return null;
        }
        ArrayList<String> outIDs = new ArrayList<String>(vScopeInfo.size());
        this.findMatchingScope(vScopeInfo, idMsrDim, idRegDim, outIDs);
        if (outIDs.size() == 0 && (hMsrDim.getNameRID() == MFWScopeRelationship.gModelRes.RID_shortcut || hRegDim.getNameRID() == MFWScopeRelationship.gModelRes.RID_shortcut)) {
            if (hMsrDim.getNameRID() == MFWScopeRelationship.gModelRes.RID_shortcut) {
                idMsrDim = ((MFWNodeObject)hMsrDim).getPropertyValue(MFWScopeRelationship.gModelRes.RID_refobj);
            }
            if (hRegDim.getNameRID() == MFWScopeRelationship.gModelRes.RID_shortcut) {
                idRegDim = ((MFWNodeObject)hRegDim).getPropertyValue(MFWScopeRelationship.gModelRes.RID_refobj);
            }
            this.findMatchingScope(vScopeInfo, idMsrDim, idRegDim, outIDs);
        }
        return outIDs;
    }

    private void findMatchingScope(List<ScopeInfo> vScopeInfo, String idMsrDim, String idRegDim, List<String> outIDs) {
        for (ScopeInfo aScopeInfo : vScopeInfo) {
            if (!aScopeInfo.mMsrDimID.equals(idMsrDim) || !aScopeInfo.mRegDimID.equals(idRegDim)) continue;
            outIDs.add(aScopeInfo.mLevelID);
        }
    }

    private MFWNodeObject getRefObj(MFWRequestContextUser aContext, MFWCluster aCluster, String refID, boolean resolveShortcut) {
        MFWNode objRef = null;
        if (refID != null && refID.length() > 0) {
            objRef = aCluster.lookup(gIDProperty, refID, aContext, null);
        }
        if (resolveShortcut && objRef != null && objRef.getNameRID() == MFWScopeRelationship.gModelRes.RID_shortcut) {
            refID = ((MFWNodeObject)objRef).getPropertyValue(MFWScopeRelationship.gModelRes.RID_refobj);
            objRef = aCluster.lookup(gIDProperty, refID, aContext, null);
        }
        return objRef;
    }

    private void setupMeasuresScopedLevels(MFWRequestContextUser aContext, MFWCluster aCluster) {
        ArrayList<MFWNodeObject> vScopeRels = new ArrayList<MFWNodeObject>(20);
        aCluster.getIndexManager().lookupObjectsByType((short)249, vScopeRels);
        for (MFWNodeObject objScopeRel : vScopeRels) {
            String idMsrDimEnd = objScopeRel.getPropertyValue(MFWScopeRelationship.gModelRes.RID_rightrefobj);
            MFWNodeObject objMsrDim = this.getRefObj(aContext, aCluster, idMsrDimEnd, true);
            String idRegDimEnd = objScopeRel.getPropertyValue(MFWScopeRelationship.gModelRes.RID_leftrefobj);
            MFWNodeObject objRegDim = this.getRefObj(aContext, aCluster, idRegDimEnd, true);
            if (objMsrDim == null || objRegDim == null) continue;
            MFWException.ASSERT(objMsrDim.getNameRID() == MFWScopeRelationship.gModelRes.RID_dimension, "Expecting a valid dimension for the right end of the scope relationship:", objScopeRel.getPropertyValue(MFWScopeRelationship.gModelRes.RID_ID));
            MFWException.ASSERT(objRegDim.getNameRID() == MFWScopeRelationship.gModelRes.RID_dimension, "Expecting a valid dimension for the left end of the scope relationship:", objScopeRel.getPropertyValue(MFWScopeRelationship.gModelRes.RID_ID));
            if (objMsrDim.getEnumPropertyValue(MFWScopeRelationship.gModelRes.RID_definitionType) == 4 || objRegDim.getEnumPropertyValue(MFWScopeRelationship.gModelRes.RID_definitionType) == 4) continue;
            List<MFWNode> vScopeInfo = objScopeRel.getObjectNodes(MFWScopeRelationship.gModelRes.RID_scope);
            if (vScopeInfo == null || vScopeInfo.size() == 0) {
                this.addDefaultScope(idMsrDimEnd, idRegDimEnd, objMsrDim, objRegDim);
                continue;
            }
            this.processScopeInfo(aContext, aCluster, idMsrDimEnd, idRegDimEnd, objMsrDim, objRegDim, vScopeInfo);
        }
    }

    private void addDefaultScope(String idMrsDimEnd, String idRegDimEnd, MFWNodeObject objMsrDim, MFWNodeObject objRegDim) {
        List<String> idMeasures = this.collectMeasureItemIDs(objMsrDim);
        ArrayList<MFWNodeObject> childHrchys = new ArrayList<MFWNodeObject>();
        objRegDim.findObjectNodesRecursively(MFWScopeRelationship.gModelRes.RID_hierarchy, MFWScopeRelationship.gModelRes.RID_hierarchyFolder, (short)-1, null, false, childHrchys);
        for (MFWNodeObject objHrchy : childHrchys) {
            String idLeafLevel = this.getLeafLevelID(objHrchy);
            if (idLeafLevel == null || idLeafLevel.length() == 0) continue;
            for (String idMsr : idMeasures) {
                this.recordMeasureScope(idMrsDimEnd, idRegDimEnd, idMsr, idLeafLevel);
            }
        }
    }

    private void processScopeInfo(MFWRequestContextUser aContext, MFWCluster aCluster, String idMrsDimEnd, String idRegDimEnd, MFWNodeObject objMsrDim, MFWNodeObject objRegDim, List<MFWNode> vScopeInfo) {
        List<String> allMeasures = this.collectMeasureItemIDs(objMsrDim);
        ArrayList<MFWNodeObject> allHierarchies = new ArrayList<MFWNodeObject>();
        objRegDim.findObjectNodesRecursively(MFWScopeRelationship.gModelRes.RID_hierarchy, MFWScopeRelationship.gModelRes.RID_hierarchyFolder, (short)-1, null, false, allHierarchies);
        HashMap<String, boolean[]> mapMeasureHierarchyIntersections = new HashMap<String, boolean[]>(allMeasures.size());
        for (String string : allMeasures) {
            boolean[] scopedHierarchy = new boolean[allHierarchies.size()];
            Arrays.fill(scopedHierarchy, false);
            mapMeasureHierarchyIntersections.put(string, scopedHierarchy);
        }
        for (MFWNode mFWNode : vScopeInfo) {
            int idxHierarchy;
            MFWNodeObject objScopeInfo = (MFWNodeObject)mFWNode;
            String idLevel = objScopeInfo.getPropertyValue(MFWScopeRelationship.gModelRes.RID_levelRef);
            MFWNodeObject objHierarchy = this.getLevelHierarchy(aContext, aCluster, idLevel);
            if (objHierarchy == null || (idxHierarchy = allHierarchies.indexOf(objHierarchy)) < 0) continue;
            List<MFWNode> vMsrScopeInfo = objScopeInfo.getObjectNodes(MFWScopeRelationship.gModelRes.RID_measureScope);
            for (MFWNode aMsrScope : vMsrScopeInfo) {
                boolean[] scopedHierarchy;
                MFWNodeObject objMsrScope = (MFWNodeObject)aMsrScope;
                String idMeasure = objMsrScope.getPropertyValue(MFWScopeRelationship.gModelRes.RID_refobj);
                if (idMeasure == null || idMeasure.length() == 0) continue;
                if (!objMsrScope.getBooleanPropertyValue(MFWScopeRelationship.gModelRes.RID_excluded)) {
                    this.recordMeasureScope(idMrsDimEnd, idRegDimEnd, idMeasure, idLevel);
                }
                if ((scopedHierarchy = (boolean[])mapMeasureHierarchyIntersections.get(idMeasure)) == null) {
                    String msg = "The scope relationship between measure dimension " + idMrsDimEnd + " and regular dimension " + idRegDimEnd + " is not valid. Please re-define the scope relationship.";
                    MFWException.ASSERT(scopedHierarchy != null, msg);
                }
                scopedHierarchy[idxHierarchy] = true;
            }
        }
        for (Map.Entry entry : mapMeasureHierarchyIntersections.entrySet()) {
            String idMeasureItem = (String)entry.getKey();
            boolean[] msrHryIntersect = (boolean[])entry.getValue();
            for (int idx = 0; idx < msrHryIntersect.length; ++idx) {
                String idLeafLevel;
                if (msrHryIntersect[idx] || (idLeafLevel = this.getLeafLevelID(allHierarchies.get(idx))) == null) continue;
                this.recordMeasureScope(idMrsDimEnd, idRegDimEnd, idMeasureItem, idLeafLevel);
            }
        }
    }

    private MFWNodeObject getLevelHierarchy(MFWRequestContextUser aContext, MFWCluster aCluster, String idLevel) {
        MFWNodeObject objLevel;
        MFWNodeObject objParent;
        if (idLevel == null || idLevel.length() == 0) {
            return null;
        }
        for (objParent = objLevel = this.getRefObj(aContext, aCluster, idLevel, false); objParent != null && objParent.getNameRID() != MFWScopeRelationship.gModelRes.RID_hierarchy; objParent = objParent.getParentObject()) {
        }
        return objParent;
    }

    private void recordMeasureScope(String idMrsDimEnd, String idRegDimEnd, String idMeasure, String idLevel) {
        List<ScopeInfo> vScopedLevels = this.mMeasureScoping.get(idMeasure);
        if (vScopedLevels == null) {
            vScopedLevels = new ArrayList<ScopeInfo>(5);
            this.mMeasureScoping.put(idMeasure, vScopedLevels);
        }
        vScopedLevels.add(new ScopeInfo(idMrsDimEnd, idRegDimEnd, idLevel));
    }

    private List<String> collectMeasureItemIDs(MFWNodeObject objMsrDim) {
        ArrayList<MFWNodeObject> childMsrs = new ArrayList<MFWNodeObject>();
        objMsrDim.findObjectNodesRecursively(MFWScopeRelationship.gModelRes.RID_measure, MFWScopeRelationship.gModelRes.RID_measureFolder, (short)-1, null, false, childMsrs);
        ArrayList<String> idMeasures = new ArrayList<String>(childMsrs.size() + 1);
        for (MFWNodeObject objMsr : childMsrs) {
            idMeasures.add(objMsr.getPropertyValue(MFWScopeRelationship.gModelRes.RID_ID));
        }
        return idMeasures;
    }

    private String getLeafLevelID(MFWNodeObject objHierarchy) {
        List<MFWNode> vLevels = objHierarchy.getObjectNodes(MFWScopeRelationship.gModelRes.RID_level);
        if (vLevels == null || vLevels.size() == 0) {
            return null;
        }
        MFWNodeObject leafLevel = (MFWNodeObject)vLevels.get(vLevels.size() - 1);
        return leafLevel.getPropertyValue(MFWScopeRelationship.gModelRes.RID_ID);
    }

    private static class ScopeInfo {
        String mMsrDimID = null;
        String mRegDimID = null;
        String mLevelID = null;

        ScopeInfo(String idMsrDim, String idRegDim, String idLevelID) {
            this.mMsrDimID = idMsrDim;
            this.mRegDimID = idRegDim;
            this.mLevelID = idLevelID;
        }
    }
}

