/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.persistence;

import com.cognos.mfw4j.persistence.MFWPElement;
import com.cognos.mfw4j.persistence.MFWPStore;
import com.cognos.mfw4j.utilities.MFWException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class MFWPElementString
implements MFWPElement {
    int mHashCode;
    String mStrValue;
    byte[] mByteValue;
    int mByteValueAddr;

    public MFWPElementString(String inStr) {
        this.reset(inStr);
    }

    public MFWPElementString() {
        this.mHashCode = 0;
        this.mStrValue = null;
        this.mByteValue = null;
        this.mByteValueAddr = 0;
    }

    @Override
    public void persist(MFWPStore aStore, int aPosition) {
        this.getByteValue(aStore);
        if (this.mByteValue != null) {
            this.mByteValueAddr = aStore.putBytes(this.mByteValue);
        }
        aStore.updateInt(aPosition, this.mHashCode);
        aStore.updateInt(aPosition + 4, this.mByteValueAddr);
    }

    @Override
    public void load(MFWPStore aStore, int aPosition) {
        this.mHashCode = aStore.getInt(aPosition);
        this.mByteValueAddr = aStore.getInt(aPosition + 4);
        this.mByteValue = null;
        this.mStrValue = null;
    }

    public int getPosition() {
        return this.mByteValueAddr;
    }

    public String getString(MFWPStore aStore) {
        if (this.mStrValue != null) {
            return this.mStrValue;
        }
        MFWException.ASSERT(this.mByteValueAddr != 0, "MFWPElementString:Invalid string buffer address");
        this.mByteValue = aStore.getBytes(this.mByteValueAddr);
        try {
            this.mStrValue = new String(this.mByteValue, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.mStrValue;
    }

    @Override
    public short sizeof() {
        return 8;
    }

    @Override
    public boolean isEqual(MFWPStore aStore, MFWPElement that) {
        MFWPElementString thatStr = (MFWPElementString)that;
        if (this.mHashCode != thatStr.mHashCode) {
            return false;
        }
        return Arrays.equals(this.getByteValue(aStore), thatStr.getByteValue(aStore));
    }

    @Override
    public int getHashCode() {
        return this.mHashCode;
    }

    public MFWPElementString reset(String inStr) {
        this.mHashCode = inStr.hashCode();
        this.mStrValue = inStr;
        this.mByteValue = null;
        this.mByteValueAddr = 0;
        return this;
    }

    private byte[] getByteValue(MFWPStore aStore) {
        if (this.mByteValue != null) {
            return this.mByteValue;
        }
        this.mByteValue = this.mStrValue != null ? MFWPElementString.toBytes(this.mStrValue) : aStore.getBytes(this.mByteValueAddr);
        return this.mByteValue;
    }

    private static byte[] toBytes(String inString) {
        byte[] outBytes = null;
        try {
            outBytes = inString.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return outBytes;
    }
}

