/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.persistence;

import com.cognos.mfw4j.persistence.MFWPElement;
import com.cognos.mfw4j.persistence.MFWPStore;
import com.cognos.mfw4j.utilities.MFWException;

public final class MFWPList<E extends MFWPElement> {
    private static final byte BUCKET_FIELD_CURRENT = 1;
    private static final byte BUCKET_FIELD_NEXT = 2;
    private static final byte BUCKET_FIELD_ELEMENT = 3;
    private static final byte LIST_FIELD_CAPACITY = 1;
    private static final byte LIST_FIELD_AVAILABLE_BUCKET = 2;
    private static final byte LIST_FIELD_FIRST_BUCKET = 3;
    private MFWPStore mStore;
    private int mList;
    private short mBucketCapacity;

    public static <E extends MFWPElement> MFWPList<E> create(MFWPStore aStore, short bucketCapacity, E element) {
        MFWException.ASSERT(bucketCapacity > 0, "Invalid bucket capacity when creating a persistet list");
        MFWException.ASSERT(element.sizeof() > 0, "Invalid element size when creating a persistet list");
        MFWException.ASSERT(bucketCapacity * element.sizeof() % 4 == 0, "Element size * bucket capacity must be a factor of 4");
        int aPosition = aStore.putShort(bucketCapacity);
        aStore.putInt(0);
        MFWPList<E> aList = new MFWPList<E>(aStore, aPosition, bucketCapacity);
        int firstBucket = super.addBucket(element.sizeof());
        super.updateFirstAvailableBucket(firstBucket);
        return aList;
    }

    public static <E extends MFWPElement> MFWPList<E> open(MFWPStore aStore, int listPosition) {
        short aCapacity = aStore.getShort(listPosition);
        return new MFWPList<E>(aStore, listPosition, aCapacity);
    }

    private MFWPList(MFWPStore aStore, int listPosition, short bucketCapacity) {
        this.mStore = aStore;
        this.mList = listPosition;
        this.mBucketCapacity = bucketCapacity;
    }

    public int getPosition() {
        return this.mList;
    }

    public int add(E aValue) {
        int availableBucket = this.mStore.getInt(MFWPList.getListField(this.mList, (byte)2));
        return this.addElement(availableBucket, aValue);
    }

    public Iterator getIterator() {
        return new Iterator(this);
    }

    public int size() {
        int outSize = 0;
        int aBucket = MFWPList.getListField(this.mList, (byte)3);
        int nextBucket = this.mStore.getInt(MFWPList.getBucketField(aBucket, (byte)2, (short)0, (short)0));
        while (nextBucket != 0) {
            outSize += this.mBucketCapacity;
            aBucket = nextBucket;
            nextBucket = this.mStore.getInt(MFWPList.getBucketField(nextBucket, (byte)2, (short)0, (short)0));
        }
        short currIdx = this.mStore.getShort(aBucket);
        return outSize + currIdx;
    }

    private static int getListField(int aList, byte eField) {
        switch (eField) {
            case 1: {
                return aList;
            }
            case 2: {
                return aList + 2;
            }
            case 3: {
                return aList + 6;
            }
        }
        MFWException.ASSERT(false, "Invalid list field selection");
        return 0;
    }

    private static int getBucketField(int aBucket, byte eField, short idx, short elmSize) {
        switch (eField) {
            case 1: {
                return aBucket;
            }
            case 2: {
                return aBucket + 2;
            }
            case 3: {
                return aBucket + 6 + idx * elmSize;
            }
        }
        MFWException.ASSERT(false, "Invalid lbucket field selection");
        return 0;
    }

    private int addBucket(short elementSize) {
        int bucket = this.mStore.putShort((short)0);
        this.mStore.putInt(0);
        for (int idx = 0; idx < this.mBucketCapacity * elementSize / 4; ++idx) {
            this.mStore.putInt(0);
        }
        return bucket;
    }

    private int addElement(int aBucket, E aValue) {
        short currIdx = this.mStore.getShort(aBucket);
        if (currIdx < this.mBucketCapacity) {
            return this.fillBucket(aBucket, currIdx, aValue);
        }
        int newBucket = this.addBucket(aValue.sizeof());
        this.mStore.updateInt(MFWPList.getBucketField(aBucket, (byte)2, (short)0, (short)0), newBucket);
        this.updateFirstAvailableBucket(newBucket);
        return this.fillBucket(newBucket, (short)0, aValue);
    }

    private int fillBucket(int aBucket, short idx, E aValue) {
        this.mStore.updateShort(aBucket, (short)(idx + 1));
        int elementPos = MFWPList.getBucketField(aBucket, (byte)3, idx, aValue.sizeof());
        aValue.persist(this.mStore, elementPos);
        return elementPos;
    }

    private void updateFirstAvailableBucket(int aBucket) {
        this.mStore.updateInt(MFWPList.getListField(this.mList, (byte)2), aBucket);
    }

    public final class Iterator {
        private int mBucket;
        private short mBucketCurrent;
        private short mIndex;

        private Iterator(MFWPList<E> aList) {
            this.mBucket = MFWPList.getListField(aList.getPosition(), (byte)3);
            this.mBucketCurrent = MFWPList.this.mStore.getShort(MFWPList.getBucketField(this.mBucket, (byte)1, (short)0, (short)0));
            this.mIndex = (short)-1;
        }

        public boolean hasNext() {
            this.mIndex = (short)(this.mIndex + 1);
            if (this.mIndex < this.mBucketCurrent) {
                return true;
            }
            this.mBucket = MFWPList.this.mStore.getInt(MFWPList.getBucketField(this.mBucket, (byte)2, (short)0, (short)0));
            this.mBucketCurrent = this.mBucket != 0 ? MFWPList.this.mStore.getShort(MFWPList.getBucketField(this.mBucket, (byte)1, (short)0, (short)0)) : (short)0;
            this.mIndex = 0;
            return this.mBucket != 0;
        }

        public void next(E elm) {
            int nextPos = MFWPList.getBucketField(this.mBucket, (byte)3, this.mIndex, elm.sizeof());
            elm.load(MFWPList.this.mStore, nextPos);
        }
    }
}

