/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.resourcePool;

import com.cognos.mfw4j.utilities.MFWException;

public final class MFWDSConnectionSpec {
    private String mDataSourceName = null;
    private String mDataSourceType = null;
    private String mConnectionName = null;
    private String mConnectionString = null;
    private String mSignonUID = null;
    private String mSignonPWD = null;
    private String mCubeAuthNamespace = null;
    private String mCubeAuthPassword = null;
    private String mConnectionSearchPath = null;
    private String mTicket = null;
    private String mCryptoHandle = null;

    public MFWDSConnectionSpec(String dataSourceName) {
        this.mDataSourceName = dataSourceName;
    }

    public String getLogicalName() {
        return this.mDataSourceName;
    }

    public String getDataSourceType() {
        if (this.mDataSourceType != null) {
            return this.mDataSourceType;
        }
        if (this.mConnectionString == null || this.mConnectionString.length() == 0) {
            return null;
        }
        int begin = this.mConnectionString.indexOf("LOCAL;");
        MFWException.ASSERT(begin > 0, "Unexpected connection string format - missing LOCALE");
        int end = this.mConnectionString.indexOf(";", begin + 6);
        return this.mConnectionString.substring(begin + 6, end);
    }

    public String getConnectionName() {
        return this.mConnectionName;
    }

    public String getConnectionString() {
        return this.mConnectionString;
    }

    public String getSignonUserID() {
        return this.mSignonUID;
    }

    public String getCubeAuthenticationNamespace() {
        return this.mCubeAuthNamespace;
    }

    public String getConnectionSearchPath() {
        return this.mConnectionSearchPath;
    }

    public String getSignonUserPWD() {
        return this.mSignonPWD;
    }

    public String getCubeAuthenticationPassword() {
        return this.mCubeAuthPassword;
    }

    public String getTicket() {
        return this.mTicket;
    }

    public String getCryptoHandle() {
        return this.mCryptoHandle;
    }

    public void setConnectionName(String connName) {
        this.mConnectionName = connName;
    }

    public void setDataSourceType(String dataSourceType) {
        this.mDataSourceType = dataSourceType;
    }

    public void setConnectionString(String connStr) {
        this.mConnectionString = connStr;
    }

    public void setSignonUID(String signonUID) {
        this.mSignonUID = signonUID;
    }

    public void setSignonPWD(String signonPWD) {
        this.mSignonPWD = signonPWD;
    }

    public void setCubeAuthenicationNamespace(String namespace) {
        this.mCubeAuthNamespace = namespace;
    }

    public void setConnectionSearchPath(String connectionSearchPath) {
        this.mConnectionSearchPath = connectionSearchPath;
    }

    public void setCryptoHandle(String cryptoHandle) {
        this.mCryptoHandle = cryptoHandle;
    }

    public void setCubeAuthenticationPassword(String cubePassword) {
        this.mCubeAuthPassword = cubePassword;
    }

    public void setTicket(String ticket) {
        this.mTicket = ticket;
    }
}

