/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.resourcePool;

import com.cognos.mfw4j.utilities.MFWException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class MFWGenericEntry {
    private static final int VALUE_STATE_NOT_SET = 0;
    private static final int VALUE_STATE_BEING_SET = 1;
    private static final int VALUE_STATE_SET = 2;
    private static final int VALUE_STATE_SET_FAILED = 3;
    private String mPreviousValue;
    private Object mValue = null;
    private long mInceptionTime;
    private final AtomicInteger mSetValueState = new AtomicInteger(0);
    private final ReentrantLock mSetValueLock = new ReentrantLock();
    private final Condition mSetValueCond = this.mSetValueLock.newCondition();
    private volatile RuntimeException mSetValueException = null;

    MFWGenericEntry() {
        this.mInceptionTime = System.currentTimeMillis();
    }

    boolean isStale(int retentionPeriod) {
        if (this.mSetValueState.get() == 3) {
            return true;
        }
        return this.mSetValueState.get() == 2 && System.currentTimeMillis() - this.mInceptionTime > (long)retentionPeriod;
    }

    void reset() {
        if (this.mSetValueState.get() == 2 || this.mSetValueState.get() == 3) {
            this.mSetValueState.set(0);
            this.mInceptionTime = System.currentTimeMillis();
        }
    }

    public RuntimeException getSetException() {
        return this.mSetValueException;
    }

    public boolean doesValueNeedSetting() {
        return this.mSetValueState.compareAndSet(0, 1);
    }

    public void setValue(Object aValue) {
        if (this.mValue != null && this.mValue instanceof String) {
            this.mPreviousValue = (String)this.mValue;
        }
        this.mValue = aValue;
        this.mSetValueState.set(2);
        this.mSetValueException = null;
        this.mSetValueLock.lock();
        try {
            this.mSetValueCond.signalAll();
        }
        finally {
            this.mSetValueLock.unlock();
        }
    }

    public void setValueFailed(Throwable th) {
        MFWException.ASSERT(this.mSetValueState.get() == 1, "Expecting an 'in progress' state when setting the failure!");
        this.mValue = null;
        this.mSetValueState.set(3);
        this.mSetValueException = th instanceof RuntimeException ? (RuntimeException)th : new RuntimeException(th);
        this.mSetValueLock.lock();
        try {
            this.mSetValueCond.signalAll();
        }
        finally {
            this.mSetValueLock.unlock();
        }
    }

    public Object getValue() {
        this.waitForSetValue();
        return this.mValue;
    }

    public String getPreviousValue() {
        return this.mPreviousValue;
    }

    private void waitForSetValue() {
        if (this.mSetValueException != null) {
            throw this.mSetValueException;
        }
        if (this.mSetValueState.get() == 2) {
            return;
        }
        this.mSetValueLock.lock();
        try {
            while (this.mSetValueState.get() != 2 && this.mSetValueState.get() != 3) {
                this.mSetValueCond.await();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        finally {
            this.mSetValueLock.unlock();
        }
    }
}

