/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.resourcePool;

import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.resourcePool.MFWDSConnectionSpec;
import com.cognos.mfw4j.resourcePool.MFWDSSelectionCriteria;
import com.cognos.mfw4j.resourcePool.MFWDataSourceConnectionResolver;
import com.cognos.mfw4j.resourcePool.MFWGenericEntry;
import com.cognos.mfw4j.resourcePool.MFWUserEntry;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MFWUserPool {
    private static MFWUserPool gSingleton = new MFWUserPool();
    private ReentrantReadWriteLock mRWLockUser = new ReentrantReadWriteLock();
    private HashMap<String, MFWUserEntry> mUserEntries = null;
    private ReentrantReadWriteLock mRWLockGeneric = new ReentrantReadWriteLock();
    private HashMap<Object, MFWGenericEntry> mGenericEntries = null;

    public static MFWUserPool getInstance() {
        return gSingleton;
    }

    private MFWUserPool() {
        this.mUserEntries = new HashMap(MFWConfiguration.getInstance().getUserPoolMaxSize());
        this.mGenericEntries = new HashMap(MFWConfiguration.getInstance().getGenericPoolMaxSize());
    }

    void destroy() {
        this.mUserEntries.clear();
    }

    public void clearGenericEntries() {
        this.mGenericEntries.clear();
    }

    public MFWDSConnectionSpec getConnectionSpec(MFWRequestContext reqContext, MFWDSSelectionCriteria dsSelectionCriteria) {
        MFWUserEntry userEntry = this.findOrAddUserEntry(reqContext.getUserPassport());
        return MFWDataSourceConnectionResolver.resolve(reqContext, dsSelectionCriteria, userEntry);
    }

    public List<String> getUserIdentity(MFWRequestContext reqContext) {
        MFWUserEntry userEntry = this.findOrAddUserEntry(reqContext.getUserPassport());
        return userEntry.getUserIdentity(reqContext);
    }

    public byte[] getDigestedUserIdentity(MFWRequestContext reqContext) {
        MFWUserEntry userEntry = this.findOrAddUserEntry(reqContext.getUserPassport());
        return userEntry.getDigestedUserIdentity(reqContext);
    }

    public List<String> getPackageViews(MFWRequestContext reqContext, String aPackagePath) {
        MFWUserEntry userEntry = this.findOrAddUserEntry(reqContext.getUserPassport());
        return userEntry.getPackageViews(reqContext, aPackagePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MFWGenericEntry findOrAddGenericCacheItem(Object aKey, int retentionPeriod, boolean ignoreRetentionPeriod) {
        MFWGenericEntry aCacheEntry = null;
        this.mRWLockGeneric.readLock().lock();
        try {
            aCacheEntry = this.mGenericEntries.get(aKey);
            if (aCacheEntry != null && !ignoreRetentionPeriod && !aCacheEntry.isStale(retentionPeriod)) {
                MFWGenericEntry mFWGenericEntry = aCacheEntry;
                return mFWGenericEntry;
            }
        }
        finally {
            this.mRWLockGeneric.readLock().unlock();
        }
        this.mRWLockGeneric.writeLock().lock();
        try {
            if (aCacheEntry != null) {
                aCacheEntry.reset();
            } else {
                aCacheEntry = this.addGenericCacheEntry(aKey, retentionPeriod);
            }
        }
        finally {
            this.mRWLockGeneric.writeLock().unlock();
        }
        return aCacheEntry;
    }

    private MFWGenericEntry addGenericCacheEntry(Object aKey, int retentionPeriod) {
        if (this.mGenericEntries.size() >= MFWConfiguration.getInstance().getGenericPoolMaxSize()) {
            for (Map.Entry<Object, MFWGenericEntry> anEntry : this.mGenericEntries.entrySet()) {
                if (!anEntry.getValue().isStale(retentionPeriod)) continue;
                this.mGenericEntries.remove(anEntry);
                break;
            }
        }
        MFWGenericEntry newEntry = new MFWGenericEntry();
        this.mGenericEntries.put(aKey, newEntry);
        return newEntry;
    }

    private void enforceMaxSize() {
        if (this.mUserEntries.size() < MFWConfiguration.getInstance().getUserPoolMaxSize()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        int maxIdleTime = MFWConfiguration.getInstance().getUserEntryMaxIdleTime();
        boolean removedOne = false;
        Iterator<Map.Entry<String, MFWUserEntry>> keyValuePairs = this.mUserEntries.entrySet().iterator();
        while (!removedOne && keyValuePairs.hasNext()) {
            Map.Entry<String, MFWUserEntry> aPair = keyValuePairs.next();
            MFWUserEntry userEntry = aPair.getValue();
            if (userEntry.isInUse() || currentTime - userEntry.getLastAccessTime() < (long)maxIdleTime) continue;
            this.mUserEntries.remove(aPair.getKey());
            removedOne = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MFWUserEntry findOrAddUserEntry(String userPassport) {
        MFWUserEntry userEntry = null;
        this.mRWLockUser.readLock().lock();
        try {
            userEntry = this.mUserEntries.get(userPassport);
        }
        finally {
            this.mRWLockUser.readLock().unlock();
        }
        if (userEntry == null) {
            this.mRWLockUser.writeLock().lock();
            try {
                userEntry = this.mUserEntries.get(userPassport);
                if (userEntry == null) {
                    this.enforceMaxSize();
                    userEntry = new MFWUserEntry();
                    this.mUserEntries.put(userPassport, userEntry);
                }
            }
            finally {
                this.mRWLockUser.writeLock().unlock();
            }
        }
        userEntry.recordAccessTime();
        return userEntry;
    }
}

