/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities;

import com.cognos.ccl4j.util.CCLFileUtils;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWModelNotFoundException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class MFWContentHelperXml
extends MFWContentHelper {
    private Element mRoot = null;
    private String mPassport = null;
    private String mUserName = null;

    MFWContentHelperXml(String userPassport, File cmFile) {
        this.mPassport = userPassport;
        try {
            SAXReader reader = new SAXReader();
            Document resultsDoc = reader.read(cmFile);
            this.mRoot = resultsDoc.getRootElement();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
    }

    @Override
    public String authenticateUser(String namespace, String uid, String pwd) {
        Element elmUser;
        if (!(namespace != null && namespace.length() != 0 || uid != null && uid.length() != 0 || pwd != null && pwd.length() != 0)) {
            namespace = "NTLM";
            uid = "Anonymous";
            pwd = "";
        }
        MFWException.ASSERT((elmUser = (Element)this.mRoot.selectSingleNode("//namespace[@name='" + namespace + "']/user[@uid='" + uid + "' and @pwd='" + pwd + "']")) != null, "Uanble to autnenticate user:", uid);
        if (elmUser == null) {
            return null;
        }
        this.mUserName = elmUser.attributeValue("name");
        StringBuilder outPassport = new StringBuilder(namespace);
        outPassport.append(":");
        outPassport.append(uid);
        this.mPassport = outPassport.toString();
        return this.mPassport;
    }

    @Override
    public MFWContentHelper.SignonRecord[] getConnectionSignons(String cmConnectionPath) {
        List listSignons = this.mRoot.selectNodes(cmConnectionPath + "/signon");
        if (listSignons.isEmpty()) {
            return null;
        }
        MFWContentHelper.SignonRecord[] outList = new MFWContentHelper.SignonRecord[listSignons.size()];
        for (int idx = 0; idx < listSignons.size(); ++idx) {
            Element elmSignon = (Element)listSignons.get(idx);
            StringBuilder cmPath = new StringBuilder(cmConnectionPath);
            cmPath.append("/signon[@name='");
            cmPath.append(elmSignon.attributeValue("name"));
            cmPath.append("']");
            String credentials = elmSignon.getTextTrim();
            outList[idx] = new MFWContentHelper.SignonRecord(elmSignon.attributeValue("name"), elmSignon.getPath(), credentials);
        }
        return outList;
    }

    @Override
    public MFWContentHelper.ConnectionRecord[] getDatasourceConnections(String cmDatasourceName) {
        StringBuilder path = new StringBuilder("//dataSource[@name='");
        path.append(cmDatasourceName);
        path.append("']/connection");
        List listConns = this.mRoot.selectNodes(path.toString());
        if (listConns.isEmpty()) {
            return null;
        }
        MFWContentHelper.ConnectionRecord[] outList = new MFWContentHelper.ConnectionRecord[listConns.size()];
        for (int idx = 0; idx < listConns.size(); ++idx) {
            Element elmConn = (Element)listConns.get(idx);
            StringBuilder cmPath = new StringBuilder(path.toString());
            cmPath.append("[@name='");
            cmPath.append(elmConn.attributeValue("name"));
            cmPath.append("']");
            outList[idx] = new MFWContentHelper.ConnectionRecord(elmConn.attributeValue("name"), cmPath.toString(), elmConn.attributeValue("connectionString"), null);
        }
        return outList;
    }

    @Override
    public List<Object> getObjectProperties(String cmSearchPath, String[] queryProps) {
        return this.getObjectProperties(cmSearchPath, queryProps, false);
    }

    @Override
    public List<Object> getObjectProperties(String cmSearchPath, String[] queryProps, boolean forceCMTrusted) {
        boolean metadataRequest = false;
        return this.getObjectProperties(cmSearchPath, queryProps, forceCMTrusted, metadataRequest);
    }

    @Override
    public List<Object> getObjectProperties(String cmSearchPath, String[] queryProps, boolean forceCMTrusted, boolean metadataRequest) {
        Element elmSrc = this.findPackage(cmSearchPath);
        if (elmSrc == null) {
            elmSrc = (Element)this.mRoot.selectSingleNode("//report[@name=\"" + cmSearchPath + "\"]");
        }
        if (elmSrc == null) {
            throw new MFWModelNotFoundException(cmSearchPath);
        }
        String filePath = elmSrc.attributeValue("location");
        ArrayList<Object> outList = new ArrayList<Object>(queryProps.length);
        for (int idx = 0; idx < queryProps.length; ++idx) {
            if ("defaultName".equals(queryProps[idx])) {
                outList.add(cmSearchPath);
                continue;
            }
            if ("modificationTime".equals(queryProps[idx])) {
                outList.add(this.getModificationTime(filePath));
                continue;
            }
            if ("creationTime".equals(queryProps[idx])) {
                outList.add(this.getModificationTime(filePath));
                continue;
            }
            if ("storeID".equals(queryProps[idx])) {
                String storeID = elmSrc.attributeValue("storeID");
                outList.add(storeID);
                continue;
            }
            if ("defaultScreenTip".equals(queryProps[idx])) {
                String storeID = elmSrc.attributeValue("defaultScreenTip");
                outList.add(storeID);
                continue;
            }
            if ("defaultDescription".equals(queryProps[idx])) {
                String storeID = elmSrc.attributeValue("defaultDescription");
                outList.add(storeID);
                continue;
            }
            if ("parent".equals(queryProps[idx])) {
                int jj = cmSearchPath.indexOf("model");
                String sPkg = jj > 0 ? cmSearchPath.substring(0, jj - 1) : "SOME_PACKAGE";
                outList.add(sPkg);
                String SID = elmSrc.attributeValue("storeID");
                outList.add(SID != null ? SID : "SOME_STORE_ID");
                continue;
            }
            if ("options".equals(queryProps[idx])) {
                outList.add(new ArrayList());
                continue;
            }
            MFWException.ASSERT(false, "Uusupported CM property");
        }
        return outList;
    }

    private Calendar getModificationTime(String filePath) {
        File aFile = null;
        try {
            aFile = CCLFileUtils.check((String)filePath, (int)49);
        }
        catch (CCLFileUtils.FileCheckException fileCheckException) {
            // empty catch block
        }
        MFWException.ASSERT(aFile != null, "Unable to get the last modification time for:", filePath);
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(aFile.lastModified());
        return lastModified;
    }

    @Override
    public void getUserIdentity(List<String> userMemberships) {
        MFWException.ASSERT(this.mPassport != null, "getUserIdentity() Expects a valid user passport");
        String[] pieces = this.mPassport.split(":");
        MFWException.ASSERT(pieces.length == 2, "The given passport seems incorrect:", this.mPassport);
        List listRoles = this.mRoot.selectNodes("//namespace[@name='" + pieces[0] + "']/user[@uid='" + pieces[1] + "']/roles/role");
        for (int idx = 0; idx < listRoles.size(); ++idx) {
            Element elmRole = (Element)listRoles.get(idx);
            String aRole = elmRole.attributeValue("name");
            if (aRole == null || aRole.length() <= 0) continue;
            userMemberships.add(aRole);
        }
    }

    @Override
    public String getUserName() {
        return this.mUserName;
    }

    @Override
    public Account getUserAccount() {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public void getViews(String packagePath, List<String> outViews) {
        Element packageElm = this.findPackage(packagePath);
        List listViews = packageElm.selectNodes("packageView");
        for (int idx = 0; idx < listViews.size(); ++idx) {
            Element elmRole = (Element)listViews.get(idx);
            String aView = elmRole.attributeValue("name");
            if (aView == null || aView.length() <= 0) continue;
            outViews.add(aView);
        }
    }

    @Override
    public InputStream queryPackage(String packagePath, boolean tryWithUntrustedConnection) {
        Element elmPkg = this.findPackage(packagePath);
        if (elmPkg == null) {
            return null;
        }
        String pkgLocation = elmPkg.attributeValue("location");
        MFWException.ASSERT(pkgLocation != null && pkgLocation.length() > 0, "Expecting a non-empty 'location' value for package: ", packagePath);
        FileInputStream aFileStream = null;
        try {
            aFileStream = new FileInputStream(pkgLocation);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return aFileStream;
    }

    @Override
    public void queryReport(String reportCmPath, Element connDOM, Element promptDOM, StringBuffer reportQuery, StringBuffer promptResult) {
        Element elmRpt = (Element)this.mRoot.selectSingleNode("//report[@name=\"" + reportCmPath + "\"]");
        if (elmRpt == null) {
            return;
        }
        String rptLocation = elmRpt.attributeValue("location");
        MFWException.ASSERT(rptLocation != null && rptLocation.length() > 0, "Expecting a non-empty 'location' value for report: ", reportCmPath);
        File rptFile = new File(rptLocation);
        try {
            BufferedReader input = new BufferedReader(new FileReader(rptFile));
            String line = null;
            while ((line = input.readLine()) != null) {
                reportQuery.append(line);
            }
            input.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String updateMetadata(String requestID, String request) throws RemoteException {
        StringBuilder sBuffer = new StringBuilder("../temp/mfw4j/");
        String fileName = "v5Resp" + requestID + ".xml";
        sBuffer.append(fileName);
        ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
        String path = cclConfig.resolveEffectivePath(sBuffer.toString());
        try {
            BufferedReader responseFile = new BufferedReader(new FileReader(path));
            StringBuilder responseText = new StringBuilder();
            String line = null;
            while ((line = responseFile.readLine()) != null) {
                responseText.append(line);
            }
            responseFile.close();
            return responseText.toString();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Response file missing: " + fileName, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed reading file " + fileName, e);
        }
    }

    private Element findPackage(String name) {
        List elList = this.mRoot.selectNodes("//package");
        for (Node e : elList) {
            if (!name.equals(((Element)e).attributeValue("name"))) continue;
            return (Element)e;
        }
        return null;
    }
}

